/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.image.ImageHistogram;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.EnumSet;

@JsonObject(value="AutoRescaleIntensityImageTransformerFactory")
public class AutoRescaleIntensityImageTransformerFactory
implements IImageTransformerFactory {
    private static final long serialVersionUID = 1L;
    private final float threshold;

    public AutoRescaleIntensityImageTransformerFactory(float threshold) {
        this.threshold = threshold;
    }

    public IImageTransformer createTransformer() {
        return new IImageTransformer(){

            public BufferedImage transform(BufferedImage image) {
                if (IntensityRescaling.isNotGrayscale((BufferedImage)image)) {
                    EnumSet channels = IntensityRescaling.getUsedRgbChannels((BufferedImage)image);
                    if (channels.size() != 1) {
                        ImageHistogram histogram = ImageHistogram.calculateHistogram((BufferedImage)image);
                        boolean isGray = histogram.isGray();
                        if (isGray) {
                            IntensityRescaling.Levels levels = IntensityRescaling.computeLevels((int)Math.round((float)(image.getHeight() * image.getWidth()) * AutoRescaleIntensityImageTransformerFactory.this.threshold), (int[])histogram.getRedHistogram());
                            return IntensityRescaling.rescaleAllIntensityLevelTo8Bits((BufferedImage)image, (IntensityRescaling.Levels)levels);
                        }
                        return image;
                    }
                    IntensityRescaling.Channel channel = (IntensityRescaling.Channel)channels.iterator().next();
                    IntensityRescaling.Levels levels = IntensityRescaling.computeLevels((BufferedImage)AutoRescaleIntensityImageTransformerFactory.this.toGrayScale(image, channel), (float)AutoRescaleIntensityImageTransformerFactory.this.threshold);
                    return IntensityRescaling.rescaleIntensityLevelTo8Bits((BufferedImage)image, (IntensityRescaling.Levels)levels, (IntensityRescaling.Channel)channel);
                }
                IntensityRescaling.Levels levels = IntensityRescaling.computeLevels((BufferedImage)image, (float)AutoRescaleIntensityImageTransformerFactory.this.threshold);
                return IntensityRescaling.rescaleIntensityLevelTo8Bits((BufferedImage)image, (IntensityRescaling.Levels)levels);
            }
        };
    }

    private BufferedImage toGrayScale(BufferedImage image, IntensityRescaling.Channel channel) {
        BufferedImage gray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        WritableRaster raster = gray.getRaster();
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int value = image.getRGB(x, y) >> channel.getShift() & 0xFF;
                raster.setPixel(x, y, new int[]{value});
                ++x;
            }
            ++y;
        }
        return gray;
    }
}

