/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.cifex.rpc.client.FileWithOverrideName;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXUploader;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.cifex.rpc.client.encryption.OpenPGPSymmetricKeyEncryption;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FileUploadCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "upload";
    private static FileUploadCommand instance;
    private Parameters parameters;

    private FileUploadCommand() {
        super(NAME);
    }

    @Override
    protected Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters(this.arguments);
        }
        return this.parameters;
    }

    public static final synchronized FileUploadCommand getInstance() {
        if (instance == null) {
            instance = new FileUploadCommand();
        }
        return instance;
    }

    private String getPassphraseOrExit() {
        String passphraseRepeat;
        if (this.parameters.isShortPassphrase()) {
            String passphrase = FileUploadCommand.generatePassphrase(true);
            System.out.println("Password is: " + passphrase);
            return passphrase;
        }
        if (this.parameters.isGeneratePassphrase()) {
            String passphrase = FileUploadCommand.generatePassphrase(false);
            System.out.println("Passphrase is: " + passphrase);
            return passphrase;
        }
        String passphrase = this.tryGetPassphrase("Passphrase: ", this.parameters.getPassphrase());
        if (StringUtils.isBlank((String)passphrase)) {
            System.err.println("No password has been specified, exiting.");
            System.exit(1);
        }
        if (!passphrase.equals(passphraseRepeat = this.tryGetPassphrase("Passphrase (repeat): ", this.parameters.getPassphrase()))) {
            System.err.println("The two passphrases do not match, exiting.");
            System.exit(1);
        }
        return passphrase;
    }

    @Override
    protected boolean isHelpRequest(String[] args) {
        this.arguments = args;
        return this.getParameters().isHelpRequest();
    }

    @Override
    protected int execute(String sessionToken, ICIFEXComponent cifex, String[] args) throws UserFailureException, EnvironmentFailureException {
        List<FileWithOverrideName> files;
        ICIFEXUploader uploader = cifex.createUploader(sessionToken);
        this.addConsoleProgressListener(uploader, this.getParameters().getFiles().size() > 1, this.getParameters().beQuiet());
        if (this.getParameters().isEncrypt()) {
            String passphrase = this.getPassphraseOrExit();
            files = new ArrayList<FileWithOverrideName>(this.getParameters().getFiles().size());
            for (FileWithOverrideName file : this.getParameters().getFiles()) {
                File encryptedFile = OpenPGPSymmetricKeyEncryption.encrypt(file.getOriginalFile(), file.getEncryptedFile(), passphrase, this.getParameters().isOverwriteOutputFile());
                file = new FileWithOverrideName(encryptedFile, file.tryGetOverrideName());
                files.add(file);
            }
        } else {
            files = this.getParameters().getFiles();
        }
        uploader.upload(files, this.getParameters().getRecipients(), this.getParameters().getComment());
        return 0;
    }

    private static class Parameters
    extends MinimalParameters {
        @Option(name="c", longName="comment", metaVar="STRING", usage="A comment to send to recipients of the download invitation.")
        private String comment;
        @Option(name="r", longName="recipients", metaVar="STRING", usage="Comma separated list of recipients.")
        private String recipients;
        @Option(name="q", longName="quiet", usage="Suppress progress reporting.")
        private boolean quiet;
        @Option(name="E", longName="encrypt", usage="Encrypt file before uploading.")
        private boolean encrypt;
        @Option(name="n", longName="name", usage="Name of the file as reported to the server (only allowed when exactly one file is given).")
        private String name;
        @Option(name="p", longName="passphrase", metaVar="STRING", usage="The pass phrase to use for encryption.")
        private String passphrase;
        @Option(name="g", longName="generate-passphrase", metaVar="FLAG", usage="Automatically generate a passphrase (incompatible with -p).", skipForExample=true)
        private boolean generatePassphrase;
        @Option(name="s", longName="short-passphrase", metaVar="FLAG", usage="Create a short and quite memorizable password (implies -g).", skipForExample=true)
        private boolean shortPassphrase;
        @Option(name="O", longName="overwrote-output-file", metaVar="FLAG", usage="Whether an already existing output file for the local encrypted file should be silently overwritten (only used if encryption is enabled).")
        private boolean overwriteOutputFile;
        private List<FileWithOverrideName> files;

        public Parameters(String[] args) {
            super(args, FileUploadCommand.NAME, "<file> [<file>...]");
            if (this.getArgs().isEmpty() || this.getPassphrase() != null && this.isGeneratePassphrase() || this.getArgs().size() > 1 && this.name != null) {
                this.printHelp(true);
            }
            this.files = new ArrayList<FileWithOverrideName>(this.getArgs().size());
            if (this.name != null) {
                this.files.add(new FileWithOverrideName(new File(this.getArgs().get(0)), this.name));
            } else {
                for (String filename : this.getArgs()) {
                    this.files.add(new FileWithOverrideName(new File(filename), null));
                }
            }
            this.comment = StringUtils.trimToEmpty((String)this.comment);
            this.recipients = StringUtils.trimToEmpty((String)this.recipients);
        }

        public boolean isEncrypt() {
            return this.encrypt || this.passphrase != null || this.generatePassphrase || this.shortPassphrase;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean isGeneratePassphrase() {
            return this.generatePassphrase || this.isShortPassphrase();
        }

        public boolean isShortPassphrase() {
            return this.shortPassphrase;
        }

        public boolean isOverwriteOutputFile() {
            return this.overwriteOutputFile;
        }

        String getComment() {
            return this.comment;
        }

        String getRecipients() {
            return this.recipients;
        }

        List<FileWithOverrideName> getFiles() {
            return this.files;
        }

        public boolean beQuiet() {
            return this.quiet;
        }
    }
}

