/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.featurevector;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.DispatcherStorageProcessor;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.openbis.dss.etl.HCSContainerDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureDefinition;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureVectorDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CanonicalFeatureVector;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CsvFeatureVectorParser;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.FeatureVectorStorageProcessorConfiguration;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.FeatureVectorUploader;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;

public class FeatureVectorStorageProcessor
extends AbstractDelegatingStorageProcessor
implements DispatcherStorageProcessor.IDispatchableStorageProcessor {
    private static final String ORIGINAL_DIR = "original";
    private final FeatureVectorStorageProcessorConfiguration configuration;
    private final DataSource dataSource;
    private final IEncapsulatedOpenBISService openBisService;

    public FeatureVectorStorageProcessor(Properties properties) {
        super(properties);
        this.configuration = new FeatureVectorStorageProcessorConfiguration(properties);
        this.dataSource = ServiceProvider.getDataSourceProvider().getDataSource(properties);
        this.openBisService = ServiceProvider.getOpenBISService();
    }

    @Override
    public boolean accepts(DataSetInformation dataSetInformation, File incomingDataSet) {
        return !(dataSetInformation instanceof ImageDataSetInformation) && (dataSetInformation instanceof FeatureVectorDataSetInformation || dataSetInformation.getDataSetType().getCode().toUpperCase().matches("HCS_IMAGE_ANALYSIS_DATA|HCS_ANALYSIS_WELL.*|HCS_ANALYSIS_CONTAINER_WELL.*"));
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        IStorageProcessorTransactional.IStorageProcessorTransaction superTransaction = super.createTransaction(parameters);
        return new FeatureVectorStorageProcessorTransaction(parameters, superTransaction, this);
    }

    private void loadDataSetIntoDatabase(IImagingQueryDAO dataAccessObject, File dataSet, DataSetInformation dataSetInformation) throws IOException {
        HCSContainerDatasetInfo datasetInfo = this.createScreeningDatasetInfo(dataSetInformation);
        List<CanonicalFeatureVector> fvecs = this.extractCanonicalFeatureVectors(dataSet, dataSetInformation, datasetInfo.getContainerGeometry());
        FeatureVectorUploader uploader = new FeatureVectorUploader(dataAccessObject, datasetInfo, dataSetInformation.getDataSetCode());
        uploader.uploadFeatureVectors(fvecs);
    }

    private List<CanonicalFeatureVector> extractCanonicalFeatureVectors(File dataSet, DataSetInformation dataSetInformation, Geometry plateGeometry) throws IOException {
        List<FeatureDefinition> featureDefinitions = dataSetInformation instanceof FeatureVectorDataSetInformation ? ((FeatureVectorDataSetInformation)dataSetInformation).getFeatures() : CsvFeatureVectorParser.parse(dataSet, this.configuration);
        return FeatureVectorStorageProcessor.extractCanonicalFeatureVectors(featureDefinitions, plateGeometry);
    }

    private static List<CanonicalFeatureVector> extractCanonicalFeatureVectors(List<FeatureDefinition> featuresDefinitions, Geometry plateGeometry) {
        ArrayList<CanonicalFeatureVector> canonicalFeatureVectors = new ArrayList<CanonicalFeatureVector>();
        for (FeatureDefinition featureDefinitionValues : featuresDefinitions) {
            CanonicalFeatureVector canonicalFeatureVector = featureDefinitionValues.getCanonicalFeatureVector(plateGeometry);
            canonicalFeatureVectors.add(canonicalFeatureVector);
        }
        return canonicalFeatureVectors;
    }

    private HCSContainerDatasetInfo createScreeningDatasetInfo(DataSetInformation dataSetInformation) {
        Sample sampleOrNull = this.tryFindSampleForDataSet(dataSetInformation);
        return HCSContainerDatasetInfo.createScreeningDatasetInfoWithSample(dataSetInformation, sampleOrNull);
    }

    private Sample tryFindSampleForDataSet(DataSetInformation dataSetInformation) {
        Sample sampleOrNull = dataSetInformation.tryToGetSample();
        if (sampleOrNull == null) {
            List<String> parentDataSetCodes = dataSetInformation.getParentDataSetCodes();
            for (String dataSetCode : parentDataSetCodes) {
                AbstractExternalData externalData = this.openBisService.tryGetDataSet(dataSetCode);
                if (externalData == null) {
                    throw new UserFailureException("Cannot find a parent dataset in openBIS: " + dataSetCode);
                }
                if (externalData.getSample() == null) continue;
                sampleOrNull = externalData.getSample();
                break;
            }
        }
        return sampleOrNull;
    }

    private IImagingQueryDAO createDAO() {
        return (IImagingQueryDAO)QueryTool.getQuery((DataSource)this.dataSource, IImagingQueryDAO.class);
    }

    private static final class FeatureVectorStorageProcessorTransaction
    extends AbstractDelegatingStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private transient IImagingQueryDAO dataAccessObject = null;
        private final transient FeatureVectorStorageProcessor processor;

        private FeatureVectorStorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, IStorageProcessorTransactional.IStorageProcessorTransaction transaction, FeatureVectorStorageProcessor processor) {
            super(parameters, transaction);
            this.processor = processor;
        }

        @Override
        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            this.nestedTransaction.storeData(typeExtractor, mailClient, this.incomingDataSetDirectory);
            this.dataAccessObject = this.processor.createDAO();
            File parent = new File(this.nestedTransaction.getStoredDataDirectory(), FeatureVectorStorageProcessor.ORIGINAL_DIR);
            File dataSet = new File(parent, this.incomingDataSetDirectory.getName());
            try {
                this.processor.loadDataSetIntoDatabase(this.dataAccessObject, dataSet, this.dataSetInformation);
            }
            catch (IOException ex) {
                throw new IOExceptionUnchecked(ex);
            }
            return this.nestedTransaction.getStoredDataDirectory();
        }

        @Override
        protected void executeCommit() {
            this.nestedTransaction.commit();
            if (this.dataAccessObject == null) {
                return;
            }
            this.dataAccessObject.commit();
            this.closeDataAccessObject();
        }

        @Override
        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable ex) {
            if (this.dataAccessObject != null) {
                this.dataAccessObject.rollback();
                this.closeDataAccessObject();
            }
            return this.nestedTransaction.rollback(ex);
        }

        private void closeDataAccessObject() {
            this.dataAccessObject.close();
            this.dataAccessObject = null;
        }
    }
}

