/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.ITimeAndWaitingProvider;
import ch.systemsx.cisd.common.utilities.IWaitingCondition;
import ch.systemsx.cisd.common.utilities.WaitingHelper;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetArchiveCleaner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchivingUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDeleter;
import ch.systemsx.cisd.openbis.dss.generic.shared.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetCodesWithStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class MultiDataSetArchivingFinalizer
implements IProcessingPluginTask {
    private static final long serialVersionUID = 1L;
    public static final String ORIGINAL_FILE_PATH_KEY = "original-file-path";
    public static final String REPLICATED_FILE_PATH_KEY = "replicated-file-path";
    public static final String FINALIZER_POLLING_TIME_KEY = "finalizer-polling-time";
    public static final String FINALIZER_MAX_WAITING_TIME_KEY = "finalizer-max-waiting-time";
    public static final String STATUS_KEY = "status";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MultiDataSetArchivingFinalizer.class);
    private final ITimeAndWaitingProvider timeProvider;
    private final Properties cleanerProperties;
    private transient IMultiDataSetArchiveCleaner cleaner;

    MultiDataSetArchivingFinalizer(Properties cleanerProperties, ITimeAndWaitingProvider timeProvider) {
        this.cleanerProperties = cleanerProperties;
        this.timeProvider = timeProvider;
    }

    @Override
    public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        List<String> dataSetCodes = this.extracCodes(datasets);
        Status status = Status.OK;
        try {
            boolean removeFromDataStore;
            Parameters parameters = this.getParameters(context);
            File originalFile = parameters.getOriginalFile();
            operationLog.info((Object)("Waiting for replication of archive '" + originalFile + "' containing the following data sets: " + CollectionUtils.abbreviate(dataSetCodes, 20)));
            boolean noTimeout = this.waitUntilReplicated(parameters);
            DataSetArchivingStatus archivingStatus = parameters.getStatus();
            boolean bl = removeFromDataStore = !archivingStatus.isAvailable();
            if (noTimeout) {
                DataSetCodesWithStatus codesWithStatus = new DataSetCodesWithStatus(dataSetCodes, archivingStatus, true);
                IDataSetDeleter dataSetDeleter = ServiceProvider.getDataStoreService().getDataSetDeleter();
                if (removeFromDataStore) {
                    dataSetDeleter.scheduleDeletionOfDataSets(datasets, 11, 10L);
                }
                this.updateStatus(codesWithStatus);
            } else {
                String message = "Replication of '" + originalFile + "' failed.";
                operationLog.error((Object)message);
                status = Status.createError(message);
                this.getCleaner().delete(originalFile);
                this.getCleaner().delete(parameters.getReplicatedFile());
                this.removeFromMapping(originalFile);
                this.updateStatus(new DataSetCodesWithStatus(dataSetCodes, DataSetArchivingStatus.AVAILABLE, false));
                ServiceProvider.getOpenBISService().archiveDataSets(dataSetCodes, removeFromDataStore);
            }
        }
        catch (Exception ex) {
            operationLog.error((Object)"Finalizing failed", (Throwable)ex);
            status = Status.createError(ex.getMessage());
        }
        ProcessingStatus processingStatus = new ProcessingStatus();
        processingStatus.addDatasetStatuses(datasets, status);
        return processingStatus;
    }

    private void removeFromMapping(File originalFile) {
        IMultiDataSetArchiverDBTransaction transaction = this.getTransaction();
        try {
            transaction.deleteContainer(originalFile.getName());
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
        }
        transaction.close();
    }

    protected void updateStatus(DataSetCodesWithStatus codesWithStatus) {
        ServiceProvider.getOpenBISService().updateDataSetStatuses(codesWithStatus.getDataSetCodes(), codesWithStatus.getStatus(), codesWithStatus.isPresentInArchive());
    }

    protected IMultiDataSetArchiveCleaner getCleaner() {
        if (this.cleaner == null) {
            this.cleaner = MultiDataSetArchivingUtils.createCleaner(this.cleanerProperties);
        }
        return this.cleaner;
    }

    IMultiDataSetArchiverDBTransaction getTransaction() {
        return new MultiDataSetArchiverDBTransaction();
    }

    private boolean waitUntilReplicated(Parameters parameters) {
        final File originalFile = parameters.getOriginalFile();
        final File replicatedFile = parameters.getReplicatedFile();
        final long originalSize = originalFile.length();
        long waitingTime = parameters.getWaitingTime();
        Log4jSimpleLogger logger = new Log4jSimpleLogger(operationLog);
        WaitingHelper waitingHelper = new WaitingHelper(waitingTime, parameters.getPollingTime(), this.timeProvider, logger);
        return waitingHelper.waitOn(new IWaitingCondition(){

            @Override
            public boolean conditionFulfilled() {
                return replicatedFile.length() >= originalSize;
            }

            public String toString() {
                return String.valueOf(FileUtilities.byteCountToDisplaySize(replicatedFile.length())) + " of " + FileUtilities.byteCountToDisplaySize(originalSize) + " are replicated for " + originalFile;
            }
        });
    }

    private List<String> extracCodes(List<DatasetDescription> datasets) {
        ArrayList<String> codes = new ArrayList<String>();
        for (DatasetDescription dataSet : datasets) {
            codes.add(dataSet.getDataSetCode());
        }
        return codes;
    }

    private Parameters getParameters(DataSetProcessingContext context) {
        Map<String, String> parameterBindings = context.getParameterBindings();
        operationLog.info((Object)("Parameters: " + parameterBindings));
        Parameters parameters = new Parameters();
        parameters.setOriginalFile(new File(this.getProperty(parameterBindings, ORIGINAL_FILE_PATH_KEY)));
        parameters.setReplicatedFile(new File(this.getProperty(parameterBindings, REPLICATED_FILE_PATH_KEY)));
        parameters.setPollingTime(this.getNumber(parameterBindings, FINALIZER_POLLING_TIME_KEY));
        parameters.setWaitingTime(this.getNumber(parameterBindings, FINALIZER_MAX_WAITING_TIME_KEY));
        parameters.setStatus(DataSetArchivingStatus.valueOf(this.getProperty(parameterBindings, STATUS_KEY)));
        return parameters;
    }

    private long getNumber(Map<String, String> parameterBindings, String property) {
        String value = this.getProperty(parameterBindings, property);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Property '" + property + "' isn't a number: " + value);
        }
    }

    private String getProperty(Map<String, String> parameterBindings, String property) {
        String value = parameterBindings.get(property);
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException("Unknown property '" + property + "'.");
        }
        return value;
    }

    private static final class Parameters {
        private File originalFile;
        private File replicatedFile;
        private long pollingTime;
        private long waitingTime;
        private DataSetArchivingStatus status;

        private Parameters() {
        }

        public void setOriginalFile(File file) {
            this.originalFile = file;
        }

        public File getOriginalFile() {
            return this.originalFile;
        }

        public void setPollingTime(long pollingTime) {
            this.pollingTime = pollingTime;
        }

        public long getPollingTime() {
            return this.pollingTime;
        }

        public void setWaitingTime(long waitingTime) {
            this.waitingTime = waitingTime;
        }

        public long getWaitingTime() {
            return this.waitingTime;
        }

        public void setReplicatedFile(File file) {
            this.replicatedFile = file;
        }

        public File getReplicatedFile() {
            return this.replicatedFile;
        }

        public void setStatus(DataSetArchivingStatus status) {
            this.status = status;
        }

        public DataSetArchivingStatus getStatus() {
            return this.status;
        }
    }
}

