/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.translator;

import ch.systemsx.cisd.common.string.ReflectingStringEscaper;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSet;

public final class ResultSetTranslator {
    private ResultSetTranslator() {
    }

    public static final <K, T> ResultSet<T> translate(IResultSet<String, T> result, Escape escape) {
        ResultSet<T> resultSet = new ResultSet<T>();
        GridRowModels<T> resultSetList = escape == Escape.YES ? ReflectingStringEscaper.escapeDeepWithCopy(result.getList()) : result.getList();
        resultSet.setList(resultSetList);
        resultSet.setTotalLength(result.getTotalLength());
        resultSet.setResultSetKey(result.getResultSetKey());
        resultSet.setPartial(result.isPartial());
        return resultSet;
    }

    public static enum Escape {
        YES,
        NO;

    }
}

