/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.maintenance.MaintenancePlugin;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskParameters;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MaintenanceTaskStarter
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    private List<MaintenancePlugin> plugins;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        CommonServiceProvider.setApplicationContext(applicationContext);
    }

    public void afterPropertiesSet() throws Exception {
        MaintenanceTaskParameters[] tasks = MaintenanceTaskUtils.createMaintenancePlugins(this.configurer.getResolvedProps());
        this.plugins = MaintenanceTaskUtils.startupMaintenancePlugins(tasks);
    }

    public void destroy() throws Exception {
        MaintenanceTaskUtils.shutdownMaintenancePlugins(this.plugins);
    }
}

