/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.migration;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.dbmigration.java.MigrationStepAdapter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.SimplePropertyValidator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public final class MigrationStepFrom036To037
extends MigrationStepAdapter {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MigrationStepFrom036To037.class);
    private static final String SELECT_ENTITY_PROPERTIES_QUERY = "SELECT id, value FROM %s WHERE %s IN (SELECT id FROM %s WHERE prty_id IN (SELECT id FROM property_types WHERE daty_id IN (SELECT id FROM data_types WHERE code = 'TIMESTAMP')));";
    private static final ParameterizedRowMapper<EntityProperty> ENTITY_PROPERTY_ROW_MAPPER = new ParameterizedRowMapper<EntityProperty>(){

        public final EntityProperty mapRow(ResultSet rs, int rowNum) throws SQLException {
            long id = rs.getLong("id");
            String value = rs.getString("value");
            return new EntityProperty(id, value);
        }
    };

    public static final String getNewDateValue(String oldDateValue) {
        return new SimplePropertyValidator.TimestampValidator().validate(oldDateValue);
    }

    @Override
    public final void performPostMigration(SimpleJdbcTemplate simpleJdbcTemplate, DataSource dataSource) throws DataAccessException {
        EntityKind[] entityKindArray = EntityKind.values();
        int n = entityKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind entityKind = entityKindArray[n2];
            this.migrateEntityProperties(simpleJdbcTemplate, entityKind);
            ++n2;
        }
    }

    private void migrateEntityProperties(SimpleJdbcTemplate simpleJdbcTemplate, EntityKind entityKind) {
        String entityName = entityKind.getDescription();
        switch (entityKind) {
            case DATA_SET: {
                this.migrateEntityProperties(simpleJdbcTemplate, entityName, "data_set_properties", "dstpt_id", "data_set_type_property_types");
                break;
            }
            case SAMPLE: {
                this.migrateEntityProperties(simpleJdbcTemplate, entityName, "sample_properties", "stpt_id", "sample_type_property_types");
                break;
            }
            case EXPERIMENT: {
                this.migrateEntityProperties(simpleJdbcTemplate, entityName, "experiment_properties", "etpt_id", "experiment_type_property_types");
                break;
            }
            case MATERIAL: {
                this.migrateEntityProperties(simpleJdbcTemplate, entityName, "material_properties", "mtpt_id", "material_type_property_types");
            }
        }
    }

    private void migrateEntityProperties(SimpleJdbcTemplate simpleJdbcTemplate, String entityName, String entityPropertiesTable, String entityTypePropertyTypeColumnName, String entityTypePropertyTypeTable) {
        List properties = simpleJdbcTemplate.query(String.format(SELECT_ENTITY_PROPERTIES_QUERY, entityPropertiesTable, entityTypePropertyTypeColumnName, entityTypePropertyTypeTable), ENTITY_PROPERTY_ROW_MAPPER, new Object[0]);
        if (properties.size() == 0) {
            operationLog.info((Object)String.format("No %s properties with data type 'TIMESTAMP' have been found to migrate.", entityName));
        } else {
            ArrayList<EntityProperty> migrated = new ArrayList<EntityProperty>();
            for (EntityProperty property : properties) {
                String oldDateValue = property.value;
                String newDateValue = MigrationStepFrom036To037.getNewDateValue(oldDateValue);
                if (newDateValue.equals(oldDateValue)) continue;
                int updated = simpleJdbcTemplate.update(String.format("update %s set value = ? where id = ?", entityPropertiesTable), new Object[]{newDateValue, property.id});
                if (updated != 1) {
                    throw new IncorrectResultSizeDataAccessException(1, updated);
                }
                migrated.add(property);
            }
            if (migrated.size() == 0) {
                operationLog.info((Object)String.format("All %s properties with data type 'TIMESTAMP' had proper format.", entityName));
            } else {
                operationLog.info((Object)String.format("Following %s properties have been migrated: %s", entityName, CollectionUtils.abbreviate(migrated, 10)));
            }
        }
    }

    static final class EntityProperty {
        final long id;
        final String value;

        EntityProperty(long id, String value) {
            this.id = id;
            this.value = value;
        }

        public final String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        }
    }
}

