/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorWithDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellReferenceWithDatasets;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.PropertyConfigurator;

public class ScreeningClientApiTest {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: <user> <password> <openbis-server-url>");
            System.err.println("Example parameters: test-user my-password http://localhost:8888");
            System.exit(1);
            return;
        }
        ScreeningClientApiTest.configureLogging();
        String userId = args[0];
        String userPassword = args[1];
        String serverUrl = args[2];
        ScreeningClientApiTest.print(String.format("Connecting to the server '%s' as a user '%s.", serverUrl, userId));
        IScreeningOpenbisServiceFacade facade = ScreeningOpenbisServiceFacadeFactory.INSTANCE.tryToCreate(userId, userPassword, serverUrl);
        if (facade == null) {
            System.err.println("Authentication failed: check the user name and password.");
            System.exit(1);
            return;
        }
        List<ExperimentIdentifier> experiments = facade.listExperiments();
        ScreeningClientApiTest.print("Experiments: " + experiments);
        MaterialIdentifier gene = new MaterialIdentifier(MaterialTypeIdentifier.GENE, "1111");
        ExperimentIdentifier experimentIdentifer = experiments.get(0);
        List<PlateWellReferenceWithDatasets> plateWells = null;
        List<FeatureVectorWithDescription> featuresForPlateWells = null;
        List<FeatureVectorWithDescription> featuresForPlateWellsCheck = null;
        try {
            plateWells = facade.listPlateWells(experimentIdentifer, gene, true);
            ScreeningClientApiTest.print(String.format("Wells with gene '%s' in experiment '%s': %s", gene, experimentIdentifer, plateWells));
            featuresForPlateWells = facade.loadFeaturesForPlateWells(experimentIdentifer, gene, null, null);
            ScreeningClientApiTest.print("Features for wells: " + featuresForPlateWells);
            featuresForPlateWellsCheck = facade.loadFeaturesForDatasetWellReferences(facade.convertToFeatureVectorDatasetWellIdentifier(plateWells), null);
        }
        catch (Exception e) {
            ScreeningClientApiTest.print(e.toString());
        }
        if (featuresForPlateWells != null && !featuresForPlateWells.equals(featuresForPlateWellsCheck)) {
            throw new IllegalStateException(String.format("Inconsistent results to fetch feature vectors, expected:\n%s\nbut got:\n%s", featuresForPlateWells, featuresForPlateWellsCheck));
        }
        List<Plate> plates = facade.listPlates();
        ScreeningClientApiTest.print("Plates: " + plates);
        List<ImageDatasetReference> imageDatasets = facade.listImageDatasets(plates);
        Collections.sort(imageDatasets, new Comparator<ImageDatasetReference>(){

            @Override
            public int compare(ImageDatasetReference r1, ImageDatasetReference r2) {
                return r2.getPlate().getPlateCode().compareTo(r1.getPlate().getPlateCode());
            }
        });
        ScreeningClientApiTest.print("Image datasets: " + imageDatasets.subList(0, Math.min(5, imageDatasets.size())));
        List<FeatureVectorDatasetReference> featureVectorDatasets = facade.listFeatureVectorDatasets(plates, null);
        Collections.sort(featureVectorDatasets, new Comparator<FeatureVectorDatasetReference>(){

            @Override
            public int compare(FeatureVectorDatasetReference r1, FeatureVectorDatasetReference r2) {
                return r2.getPlate().getPlateCode().compareTo(r1.getPlate().getPlateCode());
            }
        });
        ScreeningClientApiTest.print("Feature vector datasets: " + featureVectorDatasets.subList(0, Math.min(5, featureVectorDatasets.size())));
        List<String> featureCodes = facade.listAvailableFeatureCodes(featureVectorDatasets);
        Collections.sort(featureCodes);
        ScreeningClientApiTest.print("Feature codes: " + featureCodes);
        List<FeatureVectorDataset> features = facade.loadFeatures(featureVectorDatasets, featureCodes);
        Collections.sort(features, new Comparator<FeatureVectorDataset>(){

            @Override
            public int compare(FeatureVectorDataset f1, FeatureVectorDataset f2) {
                return f2.getDataset().getPlate().getPlateCode().compareTo(f1.getDataset().getPlate().getPlateCode());
            }
        });
        ScreeningClientApiTest.print("Loaded feature datasets: " + features.size());
        if (features.size() > 0) {
            ScreeningClientApiTest.print("Features of the first dataset: " + features.get(0));
        }
        HashMap<Object, ArrayList<ImageDatasetReference>> imageDataSetReferencesPerDss = new HashMap<Object, ArrayList<ImageDatasetReference>>();
        for (ImageDatasetReference imageDataset : imageDatasets) {
            String url = imageDataset.getDatastoreServerUrl();
            ArrayList<ImageDatasetReference> list = (ArrayList<ImageDatasetReference>)imageDataSetReferencesPerDss.get(url);
            if (list == null) {
                list = new ArrayList<ImageDatasetReference>();
                imageDataSetReferencesPerDss.put(url, list);
            }
            list.add(imageDataset);
        }
        Collection bundle = imageDataSetReferencesPerDss.values();
        for (List imageDataSets : bundle) {
            List<ImageDatasetMetadata> imageMetadata = facade.listImageMetadata(imageDataSets);
            ScreeningClientApiTest.print("Image metadata: " + imageMetadata);
        }
        ScreeningClientApiTest.loadImages(facade, ScreeningClientApiTest.getFirstTwo(facade, imageDatasets));
        List<PlateMetadata> plateMetadata = facade.getPlateMetadataList(Arrays.asList(plates.get(0), plates.get(1), plates.get(2)));
        for (PlateMetadata metadata : plateMetadata) {
            WellMetadata well = metadata.getWell(1, 1);
            if (well == null) continue;
            System.out.println(String.valueOf(metadata.getAugmentedCode()) + ": well:" + well.getCode() + " well properties:" + well.getProperties());
            Map<String, Material> materialProperties = well.getMaterialProperties();
            System.out.println(ScreeningClientApiTest.renderMaterialProperties(materialProperties));
        }
        facade.logout();
        System.out.println("Test finished");
    }

    private static String renderMaterialProperties(Map<String, Material> materialProperties) {
        StringBuilder builder = new StringBuilder();
        ScreeningClientApiTest.renderMaterials(materialProperties, builder, "  ");
        return builder.toString();
    }

    private static void renderMaterials(Map<String, Material> materialProperties, StringBuilder builder, String indent) {
        Set<Map.Entry<String, Material>> entrySet = materialProperties.entrySet();
        for (Map.Entry<String, Material> entry : entrySet) {
            builder.append(indent).append("material property of type ").append(entry.getKey()).append(":\n");
            ScreeningClientApiTest.renderMaterial(entry.getValue(), builder, String.valueOf(indent) + "  ");
        }
    }

    private static void renderMaterial(Material material, StringBuilder builder, String indent) {
        builder.append(indent).append(material.getAugmentedCode()).append(" properties: ");
        builder.append(material.getProperties()).append("\n");
        Map<String, Material> materialProperties = material.getMaterialProperties();
        ScreeningClientApiTest.renderMaterials(materialProperties, builder, indent);
    }

    private static <T extends DatasetIdentifier> List<T> getFirstTwo(IScreeningOpenbisServiceFacade facade, List<T> identfiers) {
        ArrayList<DatasetIdentifier> result = new ArrayList<DatasetIdentifier>();
        int i = 0;
        while (i < Math.min(2, identfiers.size())) {
            DatasetIdentifier ident = (DatasetIdentifier)identfiers.get(i);
            result.add(ident);
            IDatasetIdentifier fetchedIdent = ScreeningClientApiTest.getDatasetIdentifier(facade, ident.getDatasetCode());
            if (!fetchedIdent.getPermId().equals(ident.getPermId())) {
                throw new IllegalStateException("Fetched dataset identifier is not the same as the expected one. It is " + fetchedIdent + " instead of " + ident);
            }
            ++i;
        }
        return result;
    }

    private static IDatasetIdentifier getDatasetIdentifier(IScreeningOpenbisServiceFacade facade, String datasetCode) {
        IDatasetIdentifier datasetIdentifier = facade.getDatasetIdentifiers(Arrays.asList(datasetCode)).get(0);
        return datasetIdentifier;
    }

    private static void loadImages(IScreeningOpenbisServiceFacade facade, List<ImageDatasetReference> datasetIdentifiers) throws FileNotFoundException, IOException {
        List<PlateImageReference> imageRefs = ScreeningClientApiTest.createAllImagesReferences(facade, datasetIdentifiers);
        List<File> imageFiles = ScreeningClientApiTest.createImageFiles(imageRefs);
        ScreeningClientApiTest.loadImages(facade, imageRefs, imageFiles);
    }

    private static List<PlateImageReference> createAllImagesReferences(IScreeningOpenbisServiceFacade facade, List<ImageDatasetReference> datasetIdentifiers) {
        Map<IImageDatasetIdentifier, ImageDatasetMetadata> metadataMap = ScreeningClientApiTest.fetchMetadataMap(facade, datasetIdentifiers);
        ArrayList<PlateImageReference> imageRefs = new ArrayList<PlateImageReference>();
        for (ImageDatasetReference datasetIdentifier : datasetIdentifiers) {
            ImageDatasetMetadata metadata = metadataMap.get(datasetIdentifier);
            List<PlateImageReference> datasetImageRefs = ScreeningClientApiTest.createOneWellImageReferences(metadata, datasetIdentifier);
            imageRefs.addAll(datasetImageRefs);
        }
        return imageRefs;
    }

    private static List<File> createImageFiles(List<PlateImageReference> imageRefs) {
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (PlateImageReference imageRef : imageRefs) {
            File dir = new File(imageRef.getDatasetCode());
            dir.mkdir();
            imageFiles.add(new File(dir, ScreeningClientApiTest.createImageFileName(imageRef)));
        }
        return imageFiles;
    }

    private static List<PlateImageReference> createOneWellImageReferences(ImageDatasetMetadata metadata, ImageDatasetReference datasetIdentifier) {
        ArrayList<PlateImageReference> imageRefs = new ArrayList<PlateImageReference>();
        int wellRow = 1;
        int wellCol = 3;
        for (String channel : metadata.getChannelCodes()) {
            int tile = 0;
            while (tile < metadata.getNumberOfTiles()) {
                PlateImageReference imageRef = new PlateImageReference(wellRow, wellCol, tile, channel, datasetIdentifier);
                imageRefs.add(imageRef);
                ++tile;
            }
        }
        return imageRefs;
    }

    private static Map<IImageDatasetIdentifier, ImageDatasetMetadata> fetchMetadataMap(IScreeningOpenbisServiceFacade facade, List<ImageDatasetReference> datasetIdentifiers) {
        HashMap<IImageDatasetIdentifier, ImageDatasetMetadata> map = new HashMap<IImageDatasetIdentifier, ImageDatasetMetadata>();
        List<ImageDatasetMetadata> metadatum = facade.listImageMetadata(datasetIdentifiers);
        for (ImageDatasetMetadata metadata : metadatum) {
            map.put(metadata.getImageDataset(), metadata);
        }
        return map;
    }

    private static void loadImagesFromFeatureVectors(IScreeningOpenbisServiceFacade facade, List<FeatureVectorDatasetReference> datasetIdentifiers) throws FileNotFoundException, IOException {
        ArrayList<PlateImageReference> imageRefs = new ArrayList<PlateImageReference>();
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (IDatasetIdentifier iDatasetIdentifier : datasetIdentifiers) {
            File dir = new File(iDatasetIdentifier.getDatasetCode());
            dir.mkdir();
            PlateImageReference imageRef = new PlateImageReference(1, 1, 0, "DAPI", iDatasetIdentifier);
            imageRefs.add(imageRef);
            imageFiles.add(new File(dir, ScreeningClientApiTest.createImageFileName(imageRef)));
        }
        ScreeningClientApiTest.loadImages(facade, imageRefs, imageFiles);
    }

    private static void loadImages(IScreeningOpenbisServiceFacade facade, List<PlateImageReference> imageReferences, List<File> imageOutputFiles) throws IOException {
        ScreeningClientApiTest.print("Load " + imageReferences.size() + " images");
        final Map<PlateImageReference, OutputStream> imageRefToFileMap = ScreeningClientApiTest.createImageToFileMap(imageReferences, imageOutputFiles);
        try {
            facade.loadImages(imageReferences, new ScreeningOpenbisServiceFacade.IImageOutputStreamProvider(){

                @Override
                public OutputStream getOutputStream(PlateImageReference imageReference) throws IOException {
                    return (OutputStream)imageRefToFileMap.get(imageReference);
                }
            });
        }
        finally {
            ScreeningClientApiTest.closeOutputStreams(imageRefToFileMap.values());
        }
    }

    private static void print(String msg) {
        System.out.println(new Date() + "\t" + msg);
    }

    private static void closeOutputStreams(Collection<OutputStream> streams) throws IOException {
        for (OutputStream stream : streams) {
            stream.close();
        }
    }

    private static Map<PlateImageReference, OutputStream> createImageToFileMap(List<PlateImageReference> imageReferences, List<File> imageOutputFiles) throws FileNotFoundException {
        assert (imageReferences.size() == imageOutputFiles.size()) : "there should be one file specified for each image reference";
        HashMap<PlateImageReference, OutputStream> map = new HashMap<PlateImageReference, OutputStream>();
        int i = 0;
        while (i < imageReferences.size()) {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(imageOutputFiles.get(i)));
            map.put(imageReferences.get(i), out);
            ++i;
        }
        return map;
    }

    private static String createImageFileName(PlateImageReference image) {
        WellPosition well = image.getWellPosition();
        return "img_row" + well.getWellRow() + "_col" + well.getWellColumn() + "_" + image.getChannel() + "_tile" + image.getTile() + ".png";
    }

    private static void configureLogging() {
        Properties props = new Properties();
        props.put("log4j.appender.STDOUT", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.STDOUT.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.STDOUT.layout.ConversionPattern", "%d %-5p [%t] %c - %m%n");
        props.put("log4j.rootLogger", "INFO, STDOUT");
        PropertyConfigurator.configure((Properties)props);
    }
}

