/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class PlateMetadataBrowser
extends TypedTableGrid<WellMetadata> {
    public static final String BROWSER_ID = "openbis_plate_metadata_browser";
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final TechId sampleId;

    public static void openTab(String platePermId, final IViewContext<IScreeningClientServiceAsync> screeningViewContext) {
        screeningViewContext.getCommonService().getEntityInformationHolder(EntityKind.SAMPLE, platePermId, (AsyncCallback<IEntityInformationHolderWithPermId>)new AbstractAsyncCallback<IEntityInformationHolderWithPermId>(screeningViewContext){

            @Override
            protected void process(IEntityInformationHolderWithPermId plate) {
                PlateMetadataBrowser.openTab(plate, (IViewContext<IScreeningClientServiceAsync>)screeningViewContext);
            }
        });
    }

    public static void openTab(IEntityInformationHolderWithPermId plate, IViewContext<IScreeningClientServiceAsync> viewContext) {
        AbstractTabItemFactory factory = PlateMetadataBrowser.createPlateMetadataTabFactory(plate, viewContext);
        DispatcherHelper.dispatchNaviEvent(factory);
    }

    private static AbstractTabItemFactory createPlateMetadataTabFactory(final IEntityInformationHolderWithPermId plate, final IViewContext<IScreeningClientServiceAsync> viewContext) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                return DefaultTabItem.create(this.getTabTitle(), PlateMetadataBrowser.create(viewContext, new TechId(plate.getId())), viewContext);
            }

            @Override
            public String getId() {
                return "openbis_plate-metadata-" + plate.getId();
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.VIEW);
            }

            @Override
            public String getTabTitle() {
                return "Plate Report: " + plate.getCode();
            }

            @Override
            public String tryGetLink() {
                return ScreeningLinkExtractor.createPlateMetadataBrowserLink(plate.getPermId());
            }
        };
    }

    private static IDisposableComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, TechId sampleId) {
        return new PlateMetadataBrowser(viewContext, sampleId).asDisposableWithoutToolbar();
    }

    private PlateMetadataBrowser(IViewContext<IScreeningClientServiceAsync> viewContext, TechId sampleId) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, true, ScreeningDisplayTypeIDGenerator.PLATE_METADATA_GRID);
        this.screeningViewContext = viewContext;
        this.sampleId = sampleId;
        this.allowMultipleSelection();
        this.linkWellSample();
    }

    private void linkWellSample() {
        this.registerListenerAndLinkGenerator("CODE", new ICellListenerAndLinkGenerator<WellMetadata>(){

            @Override
            public void handle(TableModelRowWithObject<WellMetadata> rowItem, boolean specialKeyPressed) {
                PlateMetadataBrowser.this.showEntityInformationHolderViewer(rowItem.getObjectOrNull().getWellSample(), false, specialKeyPressed);
            }

            @Override
            public String tryGetLink(WellMetadata entity, ISerializableComparable value) {
                return LinkExtractor.tryExtract(entity.getWellSample());
            }
        });
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<WellMetadata>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<WellMetadata>> callback) {
        this.screeningViewContext.getService().listPlateMetadata(resultSetConfig, this.sampleId, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<WellMetadata>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.screeningViewContext.getService().prepareExportPlateMetadata(exportCriteria, callback);
    }
}

