/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.LogicalImageLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureList;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageSampleContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateImages;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateDimensionParser;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IHCSFeatureVectorLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlateContentLoader {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PlateContentLoader.class);
    private final Session session;
    private final IScreeningBusinessObjectFactory businessObjectFactory;
    private final LogicalImageLoader imageLoader;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public static PlateContent loadImagesAndMetadata(Session session, org.hibernate.classic.Session hibernateSession, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, TechId plateId) {
        return new PlateContentLoader(session, hibernateSession, businessObjectFactory, managedPropertyEvaluatorFactory).getPlateContent(plateId);
    }

    public static FeatureVectorDataset loadFeatureVectorDataset(Session session, org.hibernate.classic.Session hibernateSession, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DatasetReference dataset, CodeAndLabel featureName) {
        return new PlateContentLoader(session, hibernateSession, businessObjectFactory, managedPropertyEvaluatorFactory).fetchFeatureVector(dataset, featureName);
    }

    public static PlateImages loadImagesAndMetadataForDataset(Session session, org.hibernate.classic.Session hibernateSession, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, TechId datasetId) {
        return new PlateContentLoader(session, hibernateSession, businessObjectFactory, managedPropertyEvaluatorFactory).getPlateContentForDataset(datasetId);
    }

    public static ImageSampleContent getImageDatasetInfosForSample(Session session, org.hibernate.classic.Session hibernateSession, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, TechId sampleId, WellLocation wellLocationOrNull) {
        return new PlateContentLoader(session, hibernateSession, businessObjectFactory, managedPropertyEvaluatorFactory).getImageDatasetInfosForSample(sampleId, wellLocationOrNull);
    }

    public static List<PlateMetadata> loadPlateMetadata(Session session, org.hibernate.classic.Session hibernateSession, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, List<TechId> plateIds) {
        return new PlateContentLoader(session, hibernateSession, businessObjectFactory, managedPropertyEvaluatorFactory).getPlateMetadatas(plateIds);
    }

    private PlateContentLoader(Session session, org.hibernate.classic.Session hibernateSession, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.session = session;
        this.businessObjectFactory = businessObjectFactory;
        this.imageLoader = new LogicalImageLoader(session, hibernateSession, businessObjectFactory, managedPropertyEvaluatorFactory);
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    private PlateImages getPlateContentForDataset(TechId datasetId) {
        DataPE dataSet = this.loadDataset(datasetId);
        SamplePE plate = dataSet.tryGetSample();
        if (plate == null) {
            throw UserFailureException.fromTemplate("Dataset '%s' has no sample connected.", dataSet.getCode());
        }
        List<WellMetadata> wells = this.loadWells(new TechId(HibernateUtils.getId(plate)));
        DatasetImagesReference datasetImagesReference = this.imageLoader.tryLoadImageDatasetReference(dataSet);
        if (datasetImagesReference == null) {
            throw UserFailureException.fromTemplate("Dataset '%s' is not an image dataset.", dataSet.getCode());
        }
        Geometry plateGeometry = this.getPlateGeometry(plate);
        PlateMetadata plateMetadata = new PlateMetadata(this.translate(plate), wells, plateGeometry.getNumberOfRows(), plateGeometry.getNumberOfColumns());
        return new PlateImages(plateMetadata, datasetImagesReference);
    }

    private Geometry getPlateGeometry(SamplePE plate) {
        List<IEntityProperty> properties = EntityPropertyTranslator.translate(plate.getProperties(), null, this.managedPropertyEvaluatorFactory);
        return PlateDimensionParser.getPlateGeometry(properties);
    }

    private DataPE loadDataset(TechId datasetId) {
        IDataBO dataBO = this.businessObjectFactory.createDataBO(this.session);
        dataBO.loadDataByTechId(datasetId);
        DataPE dataSet = dataBO.getData();
        return dataSet;
    }

    private PlateContent getPlateContent(TechId plateId) {
        IDataSetTable dataSetTable = this.createDataSetTable();
        Sample plate = this.loadPlate(plateId);
        List<DataPE> datasets = PlateContentLoader.loadDatasets(plateId, dataSetTable);
        List<WellMetadata> wells = this.loadWells(plateId);
        List<ImageDatasetEnrichedReference> imageDatasetReferences = this.imageLoader.loadImageDatasets(datasets);
        List<DatasetReference> featureVectorDatasets = this.filterAndFetchFeatureVectors(datasets);
        List<DatasetReference> unknownDatasetReferences = this.extractUnknownDatasets(datasets);
        Geometry plateGeometry = PlateDimensionParser.getPlateGeometry(plate.getProperties());
        int rows = plateGeometry.getNumberOfRows();
        int cols = plateGeometry.getNumberOfColumns();
        PlateMetadata plateMetadata = new PlateMetadata(plate, wells, rows, cols);
        return new PlateContent(plateMetadata, imageDatasetReferences, featureVectorDatasets, unknownDatasetReferences);
    }

    private List<DatasetReference> extractUnknownDatasets(List<DataPE> datasets) {
        List<DataPE> unknownDatasets = ScreeningUtils.filterUnknownDatasets(datasets);
        List<DatasetReference> unknownDatasetReferences = this.createDatasetReferences(unknownDatasets);
        return unknownDatasetReferences;
    }

    private List<DatasetReference> filterAndFetchFeatureVectors(List<DataPE> datasets) {
        List<DataPE> analysisDatasets = ScreeningUtils.filterImageAnalysisDatasetsPE(datasets);
        List<DatasetReference> featureVectorDatasetReferences = this.createDatasetReferences(analysisDatasets);
        return featureVectorDatasetReferences;
    }

    private FeatureVectorDataset fetchFeatureVector(DatasetReference datasetReference, CodeAndLabel featureName) {
        IHCSFeatureVectorLoader loader = this.businessObjectFactory.createHCSFeatureVectorLoader(datasetReference.getDatastoreCode());
        if (featureName == null) {
            return this.loadFeatureVector(datasetReference, loader);
        }
        return this.loadFeatureVector(datasetReference, featureName, loader);
    }

    private FeatureVectorDataset loadFeatureVector(DatasetReference ref, IHCSFeatureVectorLoader loader) {
        Map<Long, GenericEntityPropertyRecord> analysisProcedures = this.businessObjectFactory.createDatasetLister(this.session).fetchProperties(Collections.singletonList(ref.getId()), "ANALYSIS_PROCEDURE");
        GenericEntityPropertyRecord analysisProcedure = analysisProcedures.get(ref.getId());
        FeatureVectorDataset featureVectorDataset = this.loadFeatureVector(ref, loader, analysisProcedure == null ? null : analysisProcedure.value);
        return featureVectorDataset;
    }

    private FeatureVectorDataset loadFeatureVector(DatasetReference datasetReference, IHCSFeatureVectorLoader loader, String analysisProcedure) {
        FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> featureValues = loader.fetchDatasetFeatureValues(this.session, Arrays.asList(datasetReference.getCode()), Collections.<String>emptyList());
        List<FeatureVectorValues> featureVectors = featureValues.getFeatures();
        List<FeatureList> featureLists = this.tryLoadFeatureLists(datasetReference);
        FeatureVectorDataset featureVectorDataset = new FeatureVectorDataset(datasetReference, featureVectors, featureLists, analysisProcedure);
        return featureVectorDataset;
    }

    private List<FeatureList> tryLoadFeatureLists(DatasetReference datasetReference) {
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(this.session);
        dataSetTable.loadByDataSetCodes(Collections.singletonList(datasetReference.getCode()), false, false);
        DataPE dataPE = dataSetTable.getDataSets().iterator().next();
        DatasetDescription datasetDescription = DataSetTranslator.translateToDescription(dataPE);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("data-set", datasetDescription);
        TableModel tableModel = dataSetTable.createReportFromAggregationService("feature-lists-aggregation-service", dataPE.getDataStore().getCode(), parameters);
        if (tableModel.getRows().size() > 0) {
            ArrayList<FeatureList> result = new ArrayList<FeatureList>();
            for (TableModelRow row : tableModel.getRows()) {
                String name = row.getValues().get(0).toString();
                String[] valuesArray = row.getValues().get(1).toString().split("\\r?\\n");
                ArrayList<String> values = new ArrayList<String>(Arrays.asList(valuesArray));
                result.add(new FeatureList(name, values));
            }
            return result;
        }
        return null;
    }

    private FeatureVectorDataset loadFeatureVector(DatasetReference datasetReference, CodeAndLabel featureName, IHCSFeatureVectorLoader loader) {
        FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> featureValues = loader.fetchDatasetFeatureValues(this.session, Arrays.asList(datasetReference.getCode()), Collections.singletonList(featureName.getCode()));
        List<FeatureVectorValues> featureVectors = featureValues.getFeatures();
        Map<Long, GenericEntityPropertyRecord> analysisProcedures = this.businessObjectFactory.createDatasetLister(this.session).fetchProperties(Arrays.asList(datasetReference.getId()), "ANALYSIS_PROCEDURE");
        GenericEntityPropertyRecord property = analysisProcedures.get(datasetReference.getId());
        List<FeatureList> featureLists = this.tryLoadFeatureLists(datasetReference);
        FeatureVectorDataset featureVectorDataset = new FeatureVectorDataset(datasetReference, featureVectors, featureLists, property == null ? null : property.value);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("loadFeatureVector(%s,%s):", datasetReference.getPermId(), featureName.toString()));
            int i = 0;
            while (i < featureVectorDataset.getDatasetFeatures().size()) {
                operationLog.debug((Object)String.format("%d: %s -> %s", i, featureVectorDataset.getDatasetFeatures().get(i).getWellLocation(), featureVectorDataset.getDatasetFeatures().get(i).getFeatureMap()));
                ++i;
            }
        }
        return featureVectorDataset;
    }

    private <T extends DataPE> List<DatasetReference> createDatasetReferences(List<T> datasets) {
        ArrayList<DatasetReference> datasetReferences = new ArrayList<DatasetReference>();
        for (DataPE dataset : datasets) {
            datasetReferences.add(ScreeningUtils.createDatasetReference(dataset, this.session.getBaseIndexURL(), this.managedPropertyEvaluatorFactory));
        }
        return datasetReferences;
    }

    private IDataSetTable createDataSetTable() {
        return this.businessObjectFactory.createDataSetTable(this.session);
    }

    private Sample loadPlate(TechId plateId) {
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(this.session);
        sampleBO.loadDataByTechId(plateId);
        sampleBO.enrichWithProperties();
        SamplePE sample = sampleBO.getSample();
        return this.translate(sample);
    }

    private Sample translate(SamplePE sample) {
        return SampleTranslator.translate(sample, this.session.getBaseIndexURL(), null, this.managedPropertyEvaluatorFactory);
    }

    private List<WellMetadata> loadWells(TechId plateId) {
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        List<Sample> wells = sampleLister.list(PlateContentLoader.createSamplesForContainerCriteria(plateId));
        List<Material> containedMaterials = PlateContentLoader.getReferencedMaterials(wells);
        IMaterialLister materialLister = this.businessObjectFactory.createMaterialLister(this.session);
        materialLister.enrichWithProperties(containedMaterials);
        return PlateContentLoader.createWells(wells);
    }

    private static List<Material> getReferencedMaterials(List<? extends IEntityPropertiesHolder> entities) {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (IEntityPropertiesHolder iEntityPropertiesHolder : entities) {
            List<IEntityProperty> properties = iEntityPropertiesHolder.getProperties();
            for (IEntityProperty prop : properties) {
                Material material = prop.getMaterial();
                if (material == null) continue;
                materials.add(material);
            }
        }
        return materials;
    }

    protected static List<DataPE> loadDatasets(TechId plateId, IDataSetTable dataSetTable) {
        dataSetTable.loadBySampleTechIdWithoutRelationships(plateId);
        return dataSetTable.getDataSets();
    }

    private static List<WellMetadata> createWells(List<Sample> wellSamples) {
        ArrayList<WellMetadata> wells = new ArrayList<WellMetadata>();
        for (Sample wellSample : wellSamples) {
            wells.add(PlateContentLoader.createWell(wellSample));
        }
        return wells;
    }

    private static WellMetadata createWell(Sample wellSample) {
        WellMetadata well = new WellMetadata();
        WellLocation locationOrNull = PlateContentLoader.tryGetLocation(wellSample);
        well.setWellSample(wellSample, locationOrNull);
        return well;
    }

    private static WellLocation tryGetLocation(Sample wellSample) {
        return ScreeningUtils.tryCreateLocationFromMatrixCoordinate(wellSample.getSubCode());
    }

    private static ListOrSearchSampleCriteria createSamplesForContainerCriteria(TechId plateId) {
        return new ListOrSearchSampleCriteria(ListSampleCriteria.createForContainer(plateId));
    }

    private TechId fetchContainerId(TechId wellId) {
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(this.session);
        sampleBO.loadDataByTechId(wellId);
        SamplePE sample = sampleBO.getSample();
        return new TechId(sample.getContainer().getId());
    }

    private ImageSampleContent getImageDatasetInfosForSample(TechId sampleId, WellLocation wellLocationOrNull) {
        TechId datasetOwnerSampleId = wellLocationOrNull != null ? this.fetchContainerId(sampleId) : sampleId;
        List<DataPE> datasets = PlateContentLoader.loadDatasets(datasetOwnerSampleId, this.createDataSetTable());
        List<DataPE> imageDatasets = ScreeningUtils.filterImageDatasets(datasets);
        ArrayList<LogicalImageInfo> logicalImages = new ArrayList<LogicalImageInfo>();
        for (DataPE imageDataset : imageDatasets) {
            LogicalImageInfo logicalImage = this.imageLoader.tryLoadLogicalImageInfo(imageDataset.getCode(), imageDataset.getDataStore().getCode(), wellLocationOrNull);
            if (logicalImage == null) continue;
            logicalImages.add(logicalImage);
        }
        List<DatasetReference> unknownDatasetReferences = this.extractUnknownDatasets(datasets);
        return new ImageSampleContent(logicalImages, unknownDatasetReferences);
    }

    private List<PlateMetadata> getPlateMetadatas(List<TechId> plateIds) {
        ArrayList<PlateMetadata> result = new ArrayList<PlateMetadata>();
        for (TechId plateId : plateIds) {
            Sample plate = this.loadPlate(plateId);
            List<WellMetadata> wells = this.loadWells(plateId);
            Geometry plateGeometry = PlateDimensionParser.getPlateGeometry(plate.getProperties());
            int rows = plateGeometry.getNumberOfRows();
            int cols = plateGeometry.getNumberOfColumns();
            PlateMetadata plateMetadata = new PlateMetadata(plate, wells, rows, cols);
            result.add(plateMetadata);
        }
        return result;
    }
}

