/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess;

import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.AbstractImgIdentifiable;
import net.lemnik.eodsql.ResultColumn;

public class ImgChannelDTO
extends AbstractImgIdentifiable {
    @ResultColumn(value="CODE")
    private String code;
    @ResultColumn(value="LABEL")
    private String label;
    @ResultColumn(value="DESCRIPTION")
    private String descriptionOrNull;
    @ResultColumn(value="WAVELENGTH")
    private Integer wavelengthOrNull;
    @ResultColumn(value="DS_ID")
    private Long datasetIdOrNull;
    @ResultColumn(value="EXP_ID")
    private Long experimentIdOrNull;
    @ResultColumn(value="RED_CC")
    private int redColorComponent;
    @ResultColumn(value="GREEN_CC")
    private int greenColorComponent;
    @ResultColumn(value="BLUE_CC")
    private int blueColorComponent;

    private ImgChannelDTO() {
    }

    public ImgChannelDTO(String code, String descriptionOrNull, Integer wavelengthOrNull, Long datasetIdOrNull, Long experimentIdOrNull, String label, int r, int g, int b) {
        assert (datasetIdOrNull == null && experimentIdOrNull != null || datasetIdOrNull != null && experimentIdOrNull == null);
        this.code = CodeNormalizer.normalize(code);
        this.label = label;
        this.descriptionOrNull = descriptionOrNull;
        this.wavelengthOrNull = wavelengthOrNull;
        this.datasetIdOrNull = datasetIdOrNull;
        this.experimentIdOrNull = experimentIdOrNull;
        this.redColorComponent = r;
        this.greenColorComponent = g;
        this.blueColorComponent = b;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.descriptionOrNull;
    }

    public void setDescription(String description) {
        this.descriptionOrNull = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getWavelength() {
        return this.wavelengthOrNull;
    }

    public void setWavelength(Integer wavelength) {
        this.wavelengthOrNull = wavelength;
    }

    public Long getDatasetId() {
        return this.datasetIdOrNull;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetIdOrNull = datasetId;
    }

    public Long getExperimentId() {
        return this.experimentIdOrNull;
    }

    public void setExperimentId(Long experimentId) {
        this.experimentIdOrNull = experimentId;
    }

    public int getRedColorComponent() {
        return this.redColorComponent;
    }

    public void setRedColorComponent(int redColorComponent) {
        this.redColorComponent = redColorComponent;
    }

    public int getGreenColorComponent() {
        return this.greenColorComponent;
    }

    public void setGreenColorComponent(int greenColorComponent) {
        this.greenColorComponent = greenColorComponent;
    }

    public int getBlueColorComponent() {
        return this.blueColorComponent;
    }

    public void setBlueColorComponent(int blueColorComponent) {
        this.blueColorComponent = blueColorComponent;
    }
}

