/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.plugin.Animator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;

public class AVI_Writer
implements PlugInFilter {
    public static final int NO_COMPRESSION = 0;
    public static final int JPEG_COMPRESSION = 1196444237;
    public static final int PNG_COMPRESSION = 543649392;
    private static final int FOURCC_00db = 1650733104;
    private static final int FOURCC_00dc = 1667510320;
    private static int compressionIndex = 2;
    private static int jpegQuality = 90;
    private static final String[] COMPRESSION_STRINGS = new String[]{"Uncompressed", "PNG", "JPEG"};
    private static final int[] COMPRESSION_TYPES = new int[]{0, 543649392, 1196444237};
    private ImagePlus imp;
    private RandomAccessFile raFile;
    private int xDim;
    private int yDim;
    private int zDim;
    private int bytesPerPixel;
    private int frameDataSize;
    private int biCompression;
    private int linePad;
    private byte[] bufferWrite;
    private BufferedImage bufferedImage;
    private RaOutputStream raOutputStream;
    private long[] sizePointers = new long[5];
    private int stackPointer;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        if (!this.showDialog(this.imp)) {
            return;
        }
        SaveDialog sd = new SaveDialog("Save as AVI...", this.imp.getTitle(), ".avi");
        String fileName = sd.getFileName();
        if (fileName == null) {
            return;
        }
        String fileDir = sd.getDirectory();
        FileInfo fi = this.imp.getOriginalFileInfo();
        if (this.imp.getStack().isVirtual() && fileDir.equals(fi.directory) && fileName.equals(fi.fileName)) {
            IJ.error("AVI Writer", "Virtual stacks cannot be saved in place.");
            return;
        }
        try {
            this.writeImage(this.imp, fileDir + fileName, COMPRESSION_TYPES[compressionIndex], jpegQuality);
            IJ.showStatus("");
        }
        catch (IOException e) {
            IJ.error("AVI Writer", "An error occured writing the file.\n \n" + e);
        }
        IJ.showStatus("");
    }

    private boolean showDialog(ImagePlus imp) {
        double fps;
        String options = Macro.getOptions();
        if (options != null && options.indexOf("compression=") == -1) {
            Macro.setOptions("compression=Uncompressed " + options);
        }
        int decimalPlaces = (double)((int)(fps = this.getFrameRate(imp))) == fps ? 0 : 1;
        GenericDialog gd = new GenericDialog("Save as AVI...");
        gd.addChoice("Compression:", COMPRESSION_STRINGS, COMPRESSION_STRINGS[compressionIndex]);
        gd.addNumericField("Frame Rate:", fps, decimalPlaces, 3, "fps");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        compressionIndex = gd.getNextChoiceIndex();
        fps = gd.getNextNumber();
        if (fps <= 0.5) {
            fps = 0.5;
        }
        if (fps > 60.0) {
            fps = 60.0;
        }
        imp.getCalibration().fps = fps;
        return true;
    }

    public void writeImage(ImagePlus imp, String path, int compression, int jpegQuality) throws IOException {
        int z;
        if (compression != 0 && compression != 1196444237 && compression != 543649392) {
            throw new IllegalArgumentException("Unsupported Compression 0x" + Integer.toHexString(compression));
        }
        this.biCompression = compression;
        if (jpegQuality < 0) {
            jpegQuality = 0;
        }
        if (jpegQuality > 100) {
            jpegQuality = 100;
        }
        AVI_Writer.jpegQuality = jpegQuality;
        File file = new File(path);
        this.raFile = new RandomAccessFile(file, "rw");
        this.raFile.setLength(0L);
        imp.startTiming();
        boolean isComposite = imp.isComposite();
        boolean isHyperstack = imp.isHyperStack();
        this.xDim = imp.getWidth();
        this.yDim = imp.getHeight();
        this.zDim = imp.getStackSize();
        boolean saveFrames = false;
        boolean saveSlices = false;
        boolean saveChannels = false;
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int channel = imp.getChannel();
        int slice = imp.getSlice();
        int frame = imp.getFrame();
        if (isHyperstack || isComposite) {
            if (frames > 1) {
                saveFrames = true;
                this.zDim = frames;
            } else if (slices > 1) {
                saveSlices = true;
                this.zDim = slices;
            } else if (channels > 1) {
                saveChannels = true;
                this.zDim = channels;
            } else {
                isHyperstack = false;
            }
        }
        this.bytesPerPixel = imp.getType() == 4 || isComposite || this.biCompression == 1196444237 ? 3 : 1;
        boolean writeLUT = this.bytesPerPixel == 1;
        this.linePad = 0;
        int minLineLength = this.bytesPerPixel * this.xDim;
        if (this.biCompression == 0 && minLineLength % 4 != 0) {
            this.linePad = 4 - minLineLength % 4;
        }
        this.frameDataSize = (this.bytesPerPixel * this.xDim + this.linePad) * this.yDim;
        int microSecPerFrame = (int)(1.0 / this.getFrameRate(imp) * 1000000.0);
        this.writeString("RIFF");
        this.chunkSizeHere();
        this.writeString("AVI ");
        this.writeString("LIST");
        this.chunkSizeHere();
        this.writeString("hdrl");
        this.writeString("avih");
        this.writeInt(56);
        this.writeInt(microSecPerFrame);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(16);
        this.writeInt(this.zDim);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(this.xDim);
        this.writeInt(this.yDim);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeString("LIST");
        this.chunkSizeHere();
        this.writeString("strl");
        this.writeString("strh");
        this.writeInt(56);
        this.writeString("vids");
        this.writeString("DIB ");
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt((int)this.getFrameRate(imp));
        this.writeInt(0);
        this.writeInt(this.zDim);
        this.writeInt(0);
        this.writeInt(-1);
        this.writeInt(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeString("strf");
        this.chunkSizeHere();
        this.writeInt(40);
        this.writeInt(this.xDim);
        this.writeInt(this.yDim);
        this.writeShort(1);
        this.writeShort((short)(8 * this.bytesPerPixel));
        this.writeInt(this.biCompression);
        int biSizeImage = this.biCompression == 0 ? 0 : this.xDim * this.yDim * this.bytesPerPixel;
        this.writeInt(biSizeImage);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(writeLUT ? 256 : 0);
        this.writeInt(0);
        if (writeLUT) {
            this.writeLUT(imp.getProcessor());
        }
        this.chunkEndWriteSize();
        this.writeString("strn");
        this.writeInt(16);
        this.writeString("ImageJ AVI     \u0000");
        this.chunkEndWriteSize();
        this.chunkEndWriteSize();
        this.writeString("JUNK");
        this.chunkSizeHere();
        this.raFile.seek(4096L);
        this.chunkEndWriteSize();
        this.writeString("LIST");
        this.chunkSizeHere();
        long moviPointer = this.raFile.getFilePointer();
        this.writeString("movi");
        if (this.biCompression == 0) {
            this.bufferWrite = new byte[this.frameDataSize];
        } else {
            this.raOutputStream = new RaOutputStream(this.raFile);
        }
        int dataSignature = this.biCompression == 0 ? 1650733104 : 1667510320;
        int maxChunkLength = 0;
        int[] dataChunkOffset = new int[this.zDim];
        int[] dataChunkLength = new int[this.zDim];
        for (z = 0; z < this.zDim; ++z) {
            IJ.showProgress(z, this.zDim);
            IJ.showStatus(z + "/" + this.zDim);
            ImageProcessor ip = null;
            if (isComposite || isHyperstack) {
                if (saveFrames) {
                    imp.setPositionWithoutUpdate(channel, slice, z + 1);
                } else if (saveSlices) {
                    imp.setPositionWithoutUpdate(channel, z + 1, frame);
                } else if (saveChannels) {
                    imp.setPositionWithoutUpdate(z + 1, slice, frame);
                }
                ip = new ColorProcessor(imp.getImage());
            } else {
                ip = this.zDim == 1 ? imp.getProcessor() : imp.getStack().getProcessor(z + 1);
            }
            int chunkPointer = (int)this.raFile.getFilePointer();
            this.writeInt(dataSignature);
            this.chunkSizeHere();
            if (this.biCompression == 0) {
                if (this.bytesPerPixel == 1) {
                    this.writeByteFrame(ip);
                } else {
                    this.writeRGBFrame(ip);
                }
            } else {
                this.writeCompressedFrame(ip);
            }
            dataChunkOffset[z] = (int)((long)chunkPointer - moviPointer);
            dataChunkLength[z] = (int)(this.raFile.getFilePointer() - (long)chunkPointer - 8L);
            if (maxChunkLength < dataChunkLength[z]) {
                maxChunkLength = dataChunkLength[z];
            }
            this.chunkEndWriteSize();
        }
        this.chunkEndWriteSize();
        if (isComposite || isHyperstack) {
            imp.setPosition(channel, slice, frame);
        }
        this.writeString("idx1");
        this.chunkSizeHere();
        for (z = 0; z < this.zDim; ++z) {
            this.writeInt(dataSignature);
            this.writeInt(16);
            this.writeInt(dataChunkOffset[z]);
            this.writeInt(dataChunkLength[z]);
        }
        this.chunkEndWriteSize();
        this.chunkEndWriteSize();
        this.raFile.close();
        IJ.showProgress(1.0);
    }

    private void chunkSizeHere() throws IOException {
        this.sizePointers[this.stackPointer] = this.raFile.getFilePointer();
        this.writeInt(0);
        ++this.stackPointer;
    }

    private void chunkEndWriteSize() throws IOException {
        --this.stackPointer;
        long position = this.raFile.getFilePointer();
        this.raFile.seek(this.sizePointers[this.stackPointer]);
        this.writeInt((int)(position - (this.sizePointers[this.stackPointer] + 4L)));
        this.raFile.seek((position + 1L) / 2L * 2L);
    }

    private void writeByteFrame(ImageProcessor ip) throws IOException {
        ip = ip.convertToByte(true);
        byte[] pixels = (byte[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        int index = 0;
        for (int y = height - 1; y >= 0; --y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                this.bufferWrite[index++] = pixels[offset++];
            }
            for (int i = 0; i < this.linePad; ++i) {
                this.bufferWrite[index++] = 0;
            }
        }
        this.raFile.write(this.bufferWrite);
    }

    private void writeRGBFrame(ImageProcessor ip) throws IOException {
        ip = ip.convertToRGB();
        int[] pixels = (int[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        int index = 0;
        for (int y = height - 1; y >= 0; --y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int c = pixels[offset++];
                this.bufferWrite[index++] = (byte)(c & 0xFF);
                this.bufferWrite[index++] = (byte)((c & 0xFF00) >> 8);
                this.bufferWrite[index++] = (byte)((c & 0xFF0000) >> 16);
            }
            for (int i = 0; i < this.linePad; ++i) {
                this.bufferWrite[index++] = 0;
            }
        }
        this.raFile.write(this.bufferWrite);
    }

    private void writeCompressedFrame(ImageProcessor ip) throws IOException {
        BufferedImage bufferedImage = ip.getBufferedImage();
        if (this.biCompression == 1196444237) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", this.raOutputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "png", this.raOutputStream);
        }
    }

    private void writeLUT(ImageProcessor ip) throws IOException {
        IndexColorModel cm = (IndexColorModel)ip.getCurrentColorModel();
        int mapSize = cm.getMapSize();
        byte[] lutWrite = new byte[1024];
        for (int i = 0; i < 256; ++i) {
            if (i >= mapSize) continue;
            lutWrite[4 * i] = (byte)cm.getBlue(i);
            lutWrite[4 * i + 1] = (byte)cm.getGreen(i);
            lutWrite[4 * i + 2] = (byte)cm.getRed(i);
            lutWrite[4 * i + 3] = 0;
        }
        this.raFile.write(lutWrite);
    }

    private double getFrameRate(ImagePlus imp) {
        double rate = imp.getCalibration().fps;
        if (rate == 0.0) {
            rate = Animator.getFrameRate();
        }
        if (rate <= 0.5) {
            rate = 0.5;
        }
        if (rate > 60.0) {
            rate = 60.0;
        }
        return rate;
    }

    private void writeString(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF8");
        this.raFile.write(bytes);
    }

    private void writeInt(int v) throws IOException {
        this.raFile.write(v & 0xFF);
        this.raFile.write(v >>> 8 & 0xFF);
        this.raFile.write(v >>> 16 & 0xFF);
        this.raFile.write(v >>> 24 & 0xFF);
    }

    private void writeShort(int v) throws IOException {
        this.raFile.write(v & 0xFF);
        this.raFile.write(v >>> 8 & 0xFF);
    }

    class RaOutputStream
    extends OutputStream {
        RandomAccessFile raFile;

        RaOutputStream(RandomAccessFile raFile) {
            this.raFile = raFile;
        }

        public void write(int b) throws IOException {
            this.raFile.writeByte(b);
        }

        public void write(byte[] b) throws IOException {
            this.raFile.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.raFile.write(b, off, len);
        }
    }
}

