/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.action.AbstractDelegatedActionWithResult;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.AbstractTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.DataSetRegistrationAlgorithm;
import ch.systemsx.cisd.etlserver.DataSetRegistrationAlgorithmRunner;
import ch.systemsx.cisd.etlserver.DataSetRegistrationHelper;
import ch.systemsx.cisd.etlserver.DataSetRegistrationRollbacker;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.DataStrategyStore;
import ch.systemsx.cisd.etlserver.ETLServerPluginFactory;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.etlserver.IDataSetHandlerWithMailClient;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IDataStrategyStore;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.IExtensibleDataSetHandler;
import ch.systemsx.cisd.etlserver.IPostRegistrationAction;
import ch.systemsx.cisd.etlserver.IPreRegistrationAction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.IStoreRootDirectoryHolder;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.NamedDataStrategy;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.MarkerFileUtility;
import ch.systemsx.cisd.etlserver.registrator.TopLevelDataSetChecker;
import ch.systemsx.cisd.etlserver.utils.PostRegistrationExecutor;
import ch.systemsx.cisd.etlserver.utils.PreRegistrationExecutor;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import java.io.File;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public final class TransferredDataSetHandler
extends AbstractTopLevelDataSetRegistrator
implements IDataSetHandler,
IExtensibleDataSetHandler {
    public static final String TARGET_NOT_RELATIVE_TO_STORE_ROOT = "Target path '%s' is not relative to store root directory '%s'.";
    static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, TransferredDataSetHandler.class);
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, TransferredDataSetHandler.class);
    public static final NamedDataStrategy ERROR_DATA_STRATEGY = new NamedDataStrategy(DataStoreStrategyKey.ERROR);
    private final IStoreRootDirectoryHolder storeRootDirectoryHolder;
    private final IEncapsulatedOpenBISService limsService;
    private final IDataStrategyStore dataStrategyStore;
    private final IDataSetInfoExtractor dataSetInfoExtractor;
    private final IFileOperations fileOperations;
    private final Lock registrationLock;
    private final ITypeExtractor typeExtractor;
    private final IStorageProcessorTransactional storageProcessor;
    private final IMailClient mailClient;
    private final String dssCode;
    private final boolean notifySuccessfulRegistration;
    private final boolean useIsFinishedMarkerFile;
    private boolean stopped = false;
    private boolean deleteUnidentified = false;
    private DatabaseInstance homeDatabaseInstance;
    private final IDataSetHandler dataSetHandler;
    private final IDataSetValidator dataSetValidator;
    private final IPreRegistrationAction preRegistrationAction;
    private final IPostRegistrationAction postRegistrationAction;
    private final MarkerFileUtility markerFileUtility;

    public TransferredDataSetHandler(TopLevelDataSetRegistratorGlobalState globalState) {
        this(globalState, ETLServerPluginFactory.getPluginForThread(globalState.getThreadParameters()));
    }

    TransferredDataSetHandler(TopLevelDataSetRegistratorGlobalState globalState, IETLServerPlugin plugin) {
        super(globalState);
        plugin.getStorageProcessor().setStoreRootDirectory(globalState.getStoreRootDir());
        this.dssCode = globalState.getDssCode();
        assert (this.dssCode != null) : "Unspecified data store code";
        assert (plugin != null) : "IETLServerPlugin implementation can not be null.";
        this.storeRootDirectoryHolder = plugin.getStorageProcessor();
        assert (this.storeRootDirectoryHolder != null) : "Given store root directory holder can not be null.";
        this.limsService = globalState.getOpenBisService();
        assert (this.limsService != null) : "IEncapsulatedLimsService implementation can not be null.";
        this.mailClient = globalState.getMailClient();
        assert (this.mailClient != null) : "IMailClient implementation can not be null.";
        this.dataSetInfoExtractor = plugin.getDataSetInfoExtractor();
        this.typeExtractor = plugin.getTypeExtractor();
        this.storageProcessor = plugin.getStorageProcessor();
        this.dataSetHandler = plugin.getDataSetHandler(this, this.limsService);
        if (this.dataSetHandler instanceof IDataSetHandlerWithMailClient) {
            ((IDataSetHandlerWithMailClient)this.dataSetHandler).initializeMailClient(this.mailClient);
        }
        this.dataSetValidator = globalState.getDataSetValidator();
        this.dataStrategyStore = new DataStrategyStore(this.limsService, this.mailClient);
        this.notifySuccessfulRegistration = globalState.isNotifySuccessfulRegistration();
        this.registrationLock = new ReentrantLock();
        this.fileOperations = FileOperations.getMonitoredInstanceForCurrentThread();
        this.useIsFinishedMarkerFile = globalState.isUseIsFinishedMarkerFile();
        this.deleteUnidentified = globalState.isDeleteUnidentified();
        this.preRegistrationAction = PreRegistrationExecutor.create(globalState.getPreRegistrationScript());
        this.postRegistrationAction = PostRegistrationExecutor.create(globalState.getPostRegistrationScript());
        this.markerFileUtility = new MarkerFileUtility(operationLog, notificationLog, this.fileOperations, this.storeRootDirectoryHolder);
    }

    @Override
    public Lock getRegistrationLock() {
        return this.registrationLock;
    }

    @Override
    public final void handle(File file) {
        if (this.stopped) {
            return;
        }
        this.dataSetHandler.handleDataSet(file);
    }

    @Override
    public void handle(File file, String userSessionToken, DataSetInformation callerDataSetInformation, ITopLevelDataSetRegistratorDelegate delegate) {
        if (this.stopped) {
            return;
        }
        DataSetRegistrationHelper registrationHelper = this.createRegistrationHelper(file);
        IdentificationTrackingRunnerDelegate runnerDelegate = new IdentificationTrackingRunnerDelegate();
        List<DataSetInformation> registeredDataSets = new DataSetRegistrationAlgorithmRunner(registrationHelper, (DataSetRegistrationAlgorithmRunner.IDataSetRegistrationAlgorithmRunnerDelegate)runnerDelegate).runAlgorithm();
        if (runnerDelegate.didNotIdentifyDataSet) {
            throw new UserFailureException("No owning sample or experiment specified for data set");
        }
        if (!registeredDataSets.isEmpty()) {
            delegate.didRegisterDataSets(registeredDataSets);
        }
    }

    @Override
    public List<DataSetInformation> handleDataSet(File dataSet) {
        DataSetRegistrationHelper registrationHelper = this.createRegistrationHelper(dataSet);
        return new DataSetRegistrationAlgorithmRunner(registrationHelper).runAlgorithm();
    }

    @Override
    public List<DataSetInformation> handleDataSet(File dataSet, DataSetInformation dataSetInformation, DataSetRegistrationAlgorithm.IDataSetInApplicationServerRegistrator registrator) {
        dataSetInformation.setInstanceCode(this.getHomeDatabaseInstance().getCode());
        dataSetInformation.setInstanceUUID(this.getHomeDatabaseInstance().getUuid());
        DataSetRegistrationHelper registrationHelper = this.createRegistrationHelper(dataSet, dataSetInformation, registrator);
        return new DataSetRegistrationAlgorithmRunner(registrationHelper).runAlgorithm();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public final void check() throws ConfigurationFailureException, EnvironmentFailureException {
        new TopLevelDataSetChecker(operationLog, this.storeRootDirectoryHolder, this.fileOperations).runCheck();
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    DatabaseInstance getHomeDatabaseInstance() {
        if (this.homeDatabaseInstance == null) {
            this.homeDatabaseInstance = this.limsService.getHomeDatabaseInstance();
        }
        return this.homeDatabaseInstance;
    }

    private DataSetRegistrationHelper createRegistrationHelper(File file) {
        if (this.useIsFinishedMarkerFile) {
            return this.createRegistrationHelperWithIsFinishedFile(file, null, null);
        }
        return this.createRegistrationHelperWithQuietPeriodFilter(file, null, null);
    }

    private DataSetRegistrationHelper createRegistrationHelper(File dataSet, DataSetInformation dataSetInformation, DataSetRegistrationAlgorithm.IDataSetInApplicationServerRegistrator registrator) {
        if (this.useIsFinishedMarkerFile) {
            return this.createRegistrationHelperWithIsFinishedFile(dataSet, dataSetInformation, registrator);
        }
        return this.createRegistrationHelperWithQuietPeriodFilter(dataSet, dataSetInformation, registrator);
    }

    private DataSetRegistrationHelper createRegistrationHelperWithIsFinishedFile(final File isFinishedFile, final DataSetInformation dsInfo, DataSetRegistrationAlgorithm.IDataSetInApplicationServerRegistrator registrator) {
        assert (isFinishedFile != null) : "Unspecified is-finished file.";
        String name = isFinishedFile.getName();
        assert (name.startsWith(".MARKER_is_finished_")) : "A finished file must starts with '.MARKER_is_finished_'.";
        File incomingDataSetFile = this.getIncomingDataSetPathFromMarker(isFinishedFile);
        AbstractDelegatedActionWithResult<Boolean> cleanAftrewardsAction = new AbstractDelegatedActionWithResult<Boolean>(Boolean.valueOf(false)){

            @Override
            public Boolean execute() {
                return TransferredDataSetHandler.this.deleteAndLogIsFinishedMarkerFile(isFinishedFile);
            }
        };
        if (registrator != null) {
            return new OverridingRegistrationHelper(this, incomingDataSetFile, this.getGlobalState().getShareId(), cleanAftrewardsAction, this.preRegistrationAction, this.postRegistrationAction, registrator){

                @Override
                protected DataSetInformation extractDataSetInformation(File incomingDataSetPath) {
                    return dsInfo;
                }
            };
        }
        return new RegistrationHelper(this, incomingDataSetFile, this.getGlobalState().getShareId(), (IDelegatedActionWithResult<Boolean>)cleanAftrewardsAction, this.preRegistrationAction, this.postRegistrationAction);
    }

    private DataSetRegistrationHelper createRegistrationHelperWithQuietPeriodFilter(File incomingDataSetFile, final DataSetInformation dsInfo, DataSetRegistrationAlgorithm.IDataSetInApplicationServerRegistrator registrator) {
        AbstractDelegatedActionWithResult<Boolean> cleanAftrewardsAction = new AbstractDelegatedActionWithResult<Boolean>(true);
        if (registrator != null) {
            return new OverridingRegistrationHelper(this, incomingDataSetFile, this.getGlobalState().getShareId(), cleanAftrewardsAction, this.preRegistrationAction, this.postRegistrationAction, registrator){

                @Override
                protected DataSetInformation extractDataSetInformation(File incomingDataSetPath) {
                    return dsInfo;
                }
            };
        }
        return new RegistrationHelper(this, incomingDataSetFile, this.getGlobalState().getShareId(), cleanAftrewardsAction, this.preRegistrationAction, this.postRegistrationAction);
    }

    private final File getIncomingDataSetPathFromMarker(File isFinishedPath) {
        return this.markerFileUtility.getIncomingDataSetPathFromMarker(isFinishedPath);
    }

    private boolean deleteAndLogIsFinishedMarkerFile(File isFinishedFile) {
        return this.markerFileUtility.deleteAndLogIsFinishedMarkerFile(isFinishedFile);
    }

    @Override
    public File getStoreRootDir() {
        return this.getGlobalState().getStoreRootDir();
    }

    @Override
    public boolean shouldNotAddToFaultyPathsOrNull(File storeItem) {
        return false;
    }

    private static class IdentificationTrackingRunnerDelegate
    implements DataSetRegistrationAlgorithmRunner.IDataSetRegistrationAlgorithmRunnerDelegate {
        private boolean didNotIdentifyDataSet = false;

        private IdentificationTrackingRunnerDelegate() {
        }

        @Override
        public void didNotIdentifyDataSet() {
            this.didNotIdentifyDataSet = true;
        }
    }

    private class OverridingRegistrationHelper
    extends RegistrationHelper {
        OverridingRegistrationHelper(TransferredDataSetHandler transferredDataSetHandler2, File incomingDataSetFile, String shareId, IDelegatedActionWithResult<Boolean> cleanAftrewardsAction, IPreRegistrationAction preRegistrationAction, IPostRegistrationAction postRegistrationAction, DataSetRegistrationAlgorithm.IDataSetInApplicationServerRegistrator registrator) {
            super(transferredDataSetHandler2, incomingDataSetFile, shareId, cleanAftrewardsAction, preRegistrationAction, postRegistrationAction, registrator);
        }

        @Override
        protected boolean shouldDeleteUnidentified() {
            return true;
        }

        @Override
        protected boolean shouldNotifySuccessfulRegistration() {
            return false;
        }
    }

    private class RegistrationHelper
    extends DataSetRegistrationHelper {
        RegistrationHelper(TransferredDataSetHandler transferredDataSetHandler2, File incomingDataSetFile, String shareId, IDelegatedActionWithResult<Boolean> cleanAftrewardsAction, IPreRegistrationAction preRegistrationAction, IPostRegistrationAction postRegistrationAction) {
            super(incomingDataSetFile, shareId, cleanAftrewardsAction, preRegistrationAction, postRegistrationAction);
        }

        RegistrationHelper(TransferredDataSetHandler transferredDataSetHandler2, File incomingDataSetFile, String shareId, IDelegatedActionWithResult<Boolean> cleanAftrewardsAction, IPreRegistrationAction preRegistrationAction, IPostRegistrationAction postRegistrationAction, DataSetRegistrationAlgorithm.IDataSetInApplicationServerRegistrator appServerRegistrator) {
            super(incomingDataSetFile, shareId, cleanAftrewardsAction, preRegistrationAction, postRegistrationAction, appServerRegistrator);
        }

        @Override
        protected IEncapsulatedOpenBISService getOpenBisService() {
            return TransferredDataSetHandler.this.limsService;
        }

        @Override
        protected ITypeExtractor getTypeExtractor() {
            return TransferredDataSetHandler.this.typeExtractor;
        }

        @Override
        protected IStorageProcessorTransactional getStorageProcessor() {
            return TransferredDataSetHandler.this.storageProcessor;
        }

        @Override
        protected IDataSetInfoExtractor getDataSetInfoExtractor() {
            return TransferredDataSetHandler.this.dataSetInfoExtractor;
        }

        @Override
        protected DatabaseInstance getHomeDatabaseInstance() {
            return TransferredDataSetHandler.this.getHomeDatabaseInstance();
        }

        @Override
        protected Logger getOperationLog() {
            return operationLog;
        }

        @Override
        protected Logger getNotificationLog() {
            return notificationLog;
        }

        @Override
        protected IMailClient getMailClient() {
            return TransferredDataSetHandler.this.mailClient;
        }

        @Override
        protected IFileOperations getFileOperations() {
            return TransferredDataSetHandler.this.fileOperations;
        }

        @Override
        protected String getDataStoreCode() {
            return TransferredDataSetHandler.this.dssCode;
        }

        @Override
        protected IDataStrategyStore getDataStrategyStore() {
            return TransferredDataSetHandler.this.dataStrategyStore;
        }

        @Override
        protected IDataSetValidator getDataSetValidator() {
            return TransferredDataSetHandler.this.dataSetValidator;
        }

        @Override
        protected Lock getRegistrationLock() {
            return TransferredDataSetHandler.this.getRegistrationLock();
        }

        @Override
        protected boolean shouldDeleteUnidentified() {
            return TransferredDataSetHandler.this.deleteUnidentified;
        }

        @Override
        protected boolean shouldNotifySuccessfulRegistration() {
            return TransferredDataSetHandler.this.notifySuccessfulRegistration;
        }

        @Override
        protected void rollback(Throwable throwable) throws Error {
            TransferredDataSetHandler transferredDataSetHandler = TransferredDataSetHandler.this;
            transferredDataSetHandler.stopped = transferredDataSetHandler.stopped | throwable instanceof InterruptedExceptionUnchecked;
            new DataSetRegistrationRollbacker(TransferredDataSetHandler.this.stopped, this.registrationAlgorithm, this.incomingDataSetFile, notificationLog, operationLog, throwable).doRollback();
        }
    }
}

