/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeAndWaitingProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractArchiverProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncArchiveCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncArchiver;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.SshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetArchiveCleaner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchivingFinalizer;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchivingUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverContainerDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSourceUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IUnarchivingPreparation;
import ch.systemsx.cisd.openbis.dss.generic.shared.IncomingShareIdProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.translator.SimpleDataSetHelper;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class MultiDataSetArchiver
extends AbstractArchiverProcessingPlugin {
    static final String ARCHIVING_FINALIZER = "Archiving Finalizer";
    private static final long serialVersionUID = 1L;
    private transient IMultiDataSetFileOperationsManager fileOperations;
    private final FileOperationsManagerFactory fileOperationsFactory;
    public static final String MINIMUM_CONTAINER_SIZE_IN_BYTES = "minimum-container-size-in-bytes";
    public static final Long DEFAULT_MINIMUM_CONTAINER_SIZE_IN_BYTES = 0x280000000L;
    public static final String MAXIMUM_CONTAINER_SIZE_IN_BYTES = "maximum-container-size-in-bytes";
    public static final Long DEFAULT_MAXIMUM_CONTAINER_SIZE_IN_BYTES = 0x1400000000L;
    public static final long DEFAULT_FINALIZER_POLLING_TIME = 60000L;
    public static final long DEFAULT_FINALIZER_MAX_WAITING_TIME = 86400000L;
    public static final String DELAY_UNARCHIVING = "delay-unarchiving";
    public static final String CLEANER_PROPS = "cleaner";
    private transient IMultiDataSetArchiverReadonlyQueryDAO readonlyQuery;
    private transient IDataStoreServiceInternal dataStoreService;
    private transient IMultiDataSetArchiveCleaner cleaner;
    private final long minimumContainerSize;
    private final long maximumContainerSize;
    private final boolean delayUnarchiving;
    private final long finalizerPollingTime;
    private final long finalizerMaxWaitingTime;
    private final Properties cleanerProperties;

    public MultiDataSetArchiver(Properties properties, File storeRoot) {
        this(properties, storeRoot, SystemTimeProvider.SYSTEM_TIME_PROVIDER, null);
    }

    MultiDataSetArchiver(Properties properties, File storeRoot, ITimeAndWaitingProvider timeProvider, IFreeSpaceProvider freeSpaceProviderOrNull) {
        super(properties, storeRoot, null, null);
        this.delayUnarchiving = PropertyUtils.getBoolean(properties, DELAY_UNARCHIVING, false);
        this.minimumContainerSize = PropertyUtils.getLong(properties, MINIMUM_CONTAINER_SIZE_IN_BYTES, DEFAULT_MINIMUM_CONTAINER_SIZE_IN_BYTES);
        this.maximumContainerSize = PropertyUtils.getLong(properties, MAXIMUM_CONTAINER_SIZE_IN_BYTES, DEFAULT_MAXIMUM_CONTAINER_SIZE_IN_BYTES);
        this.fileOperationsFactory = new FileOperationsManagerFactory(properties, timeProvider, freeSpaceProviderOrNull);
        this.finalizerPollingTime = DateTimeUtils.getDurationInMillis(properties, "finalizer-polling-time", 60000L);
        this.finalizerMaxWaitingTime = DateTimeUtils.getDurationInMillis(properties, "finalizer-max-waiting-time", 86400000L);
        this.cleanerProperties = PropertyParametersUtil.extractSingleSectionProperties(properties, CLEANER_PROPS, false).getProperties();
        this.getCleaner();
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doArchive(List<DatasetDescription> paramDataSets, ArchiverTaskContext context, boolean removeFromDataStore) {
        LinkedList<DatasetDescription> dataSets = new LinkedList<DatasetDescription>(paramDataSets);
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses result = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        result.setStatusUpdatingSupressed(this.needsToWaitForReplication());
        this.filterBasedOnArchiveStatus(dataSets, result, FilterOption.FILTER_ARCHIVED, Status.OK, AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
        if (dataSets.isEmpty()) {
            return result;
        }
        IMultiDataSetArchiverDBTransaction transaction = this.getTransaction();
        try {
            this.verifyDataSetsSize(dataSets);
            AbstractArchiverProcessingPlugin.DatasetProcessingStatuses archiveResult = this.archiveDataSets(dataSets, context, removeFromDataStore, transaction);
            result.addResults(archiveResult);
            transaction.commit();
            transaction.close();
        }
        catch (Exception e) {
            operationLog.warn((Object)("Archiving of " + dataSets.size() + " data sets failed"), (Throwable)e);
            try {
                transaction.rollback();
                transaction.close();
            }
            catch (Exception ex) {
                operationLog.warn((Object)"Rollback of multi dataset db transaction failed", (Throwable)ex);
            }
            result.setStatusUpdatingSupressed(false);
            result.addResult(dataSets, Status.createError(e.getMessage()), AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
        }
        return result;
    }

    private void filterBasedOnArchiveStatus(LinkedList<? extends IDatasetLocation> dataSets, AbstractArchiverProcessingPlugin.DatasetProcessingStatuses result, FilterOption filterOption, Status status, AbstractArchiverProcessingPlugin.Operation operation) {
        Iterator iterator = dataSets.iterator();
        while (iterator.hasNext()) {
            boolean isFiltered;
            IDatasetLocation dataSet = (IDatasetLocation)iterator.next();
            boolean isPresentInArchive = this.isDataSetPresentInArchive(dataSet.getDataSetCode());
            switch (filterOption) {
                case FILTER_ARCHIVED: {
                    isFiltered = isPresentInArchive;
                    break;
                }
                case FILTER_UNARCHIVED: {
                    isFiltered = !isPresentInArchive;
                    break;
                }
                default: {
                    throw new IllegalStateException("All cases should be covered");
                }
            }
            if (!isFiltered) continue;
            result.addResult(dataSet.getDataSetCode(), status, operation);
            iterator.remove();
        }
    }

    private void verifyDataSetsSize(List<DatasetDescription> dataSets) {
        long datasetSize = SegmentedStoreUtils.calculateTotalSize(dataSets);
        if (dataSets.size() == 1) {
            if (datasetSize < this.minimumContainerSize) {
                throw new IllegalArgumentException("Dataset " + dataSets.get(0).getDataSetCode() + " is too small (" + FileUtilities.byteCountToDisplaySize(datasetSize) + ") to be archived with multi dataset archiver because minimum size is " + FileUtilities.byteCountToDisplaySize(this.minimumContainerSize) + ".");
            }
        } else {
            if (datasetSize < this.minimumContainerSize) {
                throw new IllegalArgumentException("Set of data sets specified for archiving is too small (" + FileUtilities.byteCountToDisplaySize(datasetSize) + ") to be archived with multi dataset archiver because minimum size is " + FileUtilities.byteCountToDisplaySize(this.minimumContainerSize) + ".");
            }
            if (datasetSize > this.maximumContainerSize) {
                throw new IllegalArgumentException("Set of data sets specified for archiving is too big (" + FileUtilities.byteCountToDisplaySize(datasetSize) + ") to be archived with multi dataset archiver because maximum size is " + FileUtilities.byteCountToDisplaySize(this.maximumContainerSize) + ".");
            }
        }
    }

    private AbstractArchiverProcessingPlugin.DatasetProcessingStatuses archiveDataSets(List<DatasetDescription> dataSets, ArchiverTaskContext context, boolean removeFromDataStore, IMultiDataSetArchiverDBTransaction transaction) throws Exception {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        String containerPath = this.getFileOperations().generateContainerPath(dataSets);
        this.establishContainerDataSetMapping(dataSets, containerPath, transaction);
        IHierarchicalContent archivedContent = null;
        try {
            try {
                Status status = this.getFileOperations().createContainer(containerPath, dataSets);
                if (status.isError()) {
                    throw new Exception("Couldn't create archive file " + containerPath + ". Reason: " + status.tryGetErrorMessage());
                }
                archivedContent = this.getFileOperations().getContainerAsHierarchicalContent(containerPath);
                this.checkArchivedDataSets(archivedContent, dataSets, context, statuses);
                this.scheduleFinalizer(containerPath, dataSets, context, removeFromDataStore);
            }
            catch (Exception ex) {
                this.getFileOperations().deleteContainerFromFinalDestination(this.getCleaner(), containerPath);
                throw ex;
            }
        }
        finally {
            this.getFileOperations().deleteContainerFromStage(this.getCleaner(), containerPath);
            if (archivedContent != null) {
                archivedContent.close();
            }
        }
        return statuses;
    }

    private void establishContainerDataSetMapping(List<DatasetDescription> dataSets, String containerPath, IMultiDataSetArchiverDBTransaction transaction) {
        MultiDataSetArchiverContainerDTO container = transaction.createContainer(containerPath);
        for (DatasetDescription dataSet : dataSets) {
            transaction.insertDataset(dataSet, container);
        }
    }

    private void scheduleFinalizer(String containerPath, List<DatasetDescription> dataSets, ArchiverTaskContext archiverContext, boolean removeFromDataStore) {
        if (!this.needsToWaitForReplication()) {
            return;
        }
        MultiDataSetArchivingFinalizer task = new MultiDataSetArchivingFinalizer(this.cleanerProperties, SystemTimeProvider.SYSTEM_TIME_PROVIDER);
        String userId = archiverContext.getUserId();
        String userEmail = archiverContext.getUserEmail();
        String userSessionToken = archiverContext.getUserSessionToken();
        LinkedHashMap<String, String> parameterBindings = new LinkedHashMap<String, String>();
        IMultiDataSetFileOperationsManager operations = this.getFileOperations();
        parameterBindings.put("original-file-path", operations.getOriginalArchiveFilePath(containerPath));
        parameterBindings.put("replicated-file-path", operations.getReplicatedArchiveFilePath(containerPath));
        parameterBindings.put("finalizer-polling-time", Long.toString(this.finalizerPollingTime));
        parameterBindings.put("finalizer-max-waiting-time", Long.toString(this.finalizerMaxWaitingTime));
        DataSetArchivingStatus status = removeFromDataStore ? DataSetArchivingStatus.ARCHIVED : DataSetArchivingStatus.AVAILABLE;
        parameterBindings.put("status", status.toString());
        this.getDataStoreService().scheduleTask(ARCHIVING_FINALIZER, task, parameterBindings, dataSets, userId, userEmail, userSessionToken);
    }

    private boolean needsToWaitForReplication() {
        return this.getFileOperations().isReplicatedArchiveDefined();
    }

    private void checkArchivedDataSets(IHierarchicalContent archivedContent, List<DatasetDescription> dataSets, ArchiverTaskContext context, AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses) {
        operationLog.info((Object)("Start sanity check on " + CollectionUtils.abbreviate(dataSets, 10)));
        for (DatasetDescription dataset : dataSets) {
            Status status;
            String dataSetCode = dataset.getDataSetCode();
            IHierarchicalContent content = null;
            try {
                content = context.getHierarchicalContentProvider().asContentWithoutModifyingAccessTimestamp(dataSetCode);
                IHierarchicalContentNode root = content.getRootNode();
                IHierarchicalContentNode archiveDataSetRoot = archivedContent.getNode(dataset.getDataSetCode());
                status = RsyncArchiver.checkHierarchySizeAndChecksums(root, dataSetCode, archiveDataSetRoot, RsyncArchiver.ChecksumVerificationCondition.IF_AVAILABLE);
                if (status.isError()) {
                    throw new RuntimeException(status.tryGetErrorMessage());
                }
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
            statuses.addResult(dataSetCode, status, AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
        }
        operationLog.info((Object)"Sanity check finished.");
    }

    @Override
    public List<String> getDataSetCodesForUnarchiving(List<String> dataSetCodes) {
        this.assertAllDataSetsInTheSameContainer(dataSetCodes);
        return this.getCodesOfAllDataSetsInContainer(dataSetCodes);
    }

    @Override
    protected IUnarchivingPreparation getUnarchivingPreparation() {
        Share scratchShare = this.findScratchShare();
        IDataSetDirectoryProvider directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        return new MultiDataSetUnarchivingPreparations(scratchShare, this.getShareIdManager(), this.getService(), directoryProvider);
    }

    private Share findScratchShare() {
        IFreeSpaceProvider freeSpaceProvider;
        Set<String> incomingShares;
        String dataStoreCode = ServiceProvider.getConfigProvider().getDataStoreCode();
        List<Share> shares = SegmentedStoreUtils.getSharesWithDataSets(this.storeRoot, dataStoreCode, SegmentedStoreUtils.FilterOptions.ARCHIVING_SCRATCH, incomingShares = IncomingShareIdProvider.getIdsOfIncomingShares(), freeSpaceProvider = this.createFreeSpaceProvider(), this.getService(), new Log4jSimpleLogger(operationLog));
        if (shares.size() != 1) {
            throw new ConfigurationFailureException("There should be exactly one unarchiving scratch share configured!");
        }
        Share scratchShare = shares.get(0);
        return scratchShare;
    }

    @Override
    protected boolean delayUnarchiving(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        if (!this.delayUnarchiving || context.isForceUnarchiving()) {
            return false;
        }
        IMultiDataSetArchiverDBTransaction transaction = this.getTransaction();
        try {
            List<String> dataSetCodes = this.translateToDataSetCodes(datasets);
            transaction.requestUnarchiving(dataSetCodes);
            transaction.commit();
            transaction.close();
        }
        catch (Exception e) {
            operationLog.warn((Object)("Requesting unarchiving of " + datasets.size() + " data sets failed"), (Throwable)e);
            try {
                transaction.rollback();
                transaction.close();
            }
            catch (Exception ex) {
                operationLog.warn((Object)"Rollback of multi dataset db transaction failed", (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doUnarchive(List<DatasetDescription> dataSets, ArchiverTaskContext context) {
        List<String> dataSetCodes = this.translateToDataSetCodes(dataSets);
        long containerId = this.assertAllDataSetsInTheSameContainer(dataSetCodes);
        this.assertNoAvailableDatasets(dataSetCodes);
        context.getUnarchivingPreparation().prepareForUnarchiving(dataSets);
        MultiDataSetArchiverContainerDTO container = this.getReadonlyQuery().getContainerForId(containerId);
        this.getFileOperations().restoreDataSetsFromContainerInFinalDestination(container.getPath(), dataSets);
        for (String dataSetCode : dataSetCodes) {
            this.getService().notifyDatasetAccess(dataSetCode);
        }
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses result = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        result.addResult(dataSets, Status.OK, AbstractArchiverProcessingPlugin.Operation.UNARCHIVE);
        return result;
    }

    private void assertNoAvailableDatasets(List<String> dataSetCodes) {
        List<PhysicalDataSet> dataSets = this.translateToPhysicalDataSets(dataSetCodes);
        for (PhysicalDataSet physicalDataSet : dataSets) {
            if (!physicalDataSet.isAvailable()) continue;
            throw new UserFailureException("Dataset '" + physicalDataSet.getCode() + "'specified for unarchiving is available");
        }
    }

    private List<String> getCodesOfAllDataSetsInContainer(List<String> dataSetCodes) {
        MultiDataSetArchiverDataSetDTO dataset = this.getReadonlyQuery().getDataSetForCode(dataSetCodes.get(0));
        Long containerId = dataset.getContainerId();
        List<MultiDataSetArchiverDataSetDTO> dbDataSets = this.getReadonlyQuery().listDataSetsForContainerId(containerId);
        LinkedList<String> enhancedDataSetCodes = new LinkedList<String>();
        for (MultiDataSetArchiverDataSetDTO dbDataSet : dbDataSets) {
            enhancedDataSetCodes.add(dbDataSet.getCode());
        }
        return enhancedDataSetCodes;
    }

    private List<PhysicalDataSet> translateToPhysicalDataSets(List<String> dataSetCodes) {
        LinkedList<PhysicalDataSet> result = new LinkedList<PhysicalDataSet>();
        for (AbstractExternalData dataSet : this.getService().listDataSetsByCode(dataSetCodes)) {
            if (dataSet.tryGetAsDataSet() != null) {
                result.add(dataSet.tryGetAsDataSet());
                continue;
            }
            throw new IllegalStateException("All data sets in container are expected to be physical datasets, but data set '" + dataSet.getCode() + "' is not ");
        }
        return result;
    }

    private List<String> translateToDataSetCodes(List<? extends IDatasetLocation> dataSets) {
        LinkedList<String> result = new LinkedList<String>();
        for (IDatasetLocation iDatasetLocation : dataSets) {
            result.add(iDatasetLocation.getDataSetCode());
        }
        return result;
    }

    private long assertAllDataSetsInTheSameContainer(List<String> dataSetCodes) {
        LinkedHashMap<Long, ArrayList<String>> containers = new LinkedHashMap<Long, ArrayList<String>>();
        long containerId = -1L;
        for (String code : dataSetCodes) {
            MultiDataSetArchiverDataSetDTO dataSet = this.getReadonlyQuery().getDataSetForCode(code);
            if (dataSet == null) {
                throw new UserFailureException("Dataset " + code + " was selected for unarchiving, but is not present in the archive");
            }
            ArrayList<String> list = (ArrayList<String>)containers.get(dataSet.getContainerId());
            if (list == null) {
                list = new ArrayList<String>();
                containers.put(dataSet.getContainerId(), list);
            }
            list.add(dataSet.getCode());
            containerId = dataSet.getContainerId();
        }
        if (containers.size() > 1) {
            throw new UserFailureException("Datasets selected for unarchiving do not all belong to one container, but to " + containers.size() + " different containers: " + containers);
        }
        return containerId;
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doDeleteFromArchive(List<? extends IDatasetLocation> datasets) {
        LinkedList<? extends IDatasetLocation> localDataSets = new LinkedList<IDatasetLocation>(datasets);
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses results = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        this.filterBasedOnArchiveStatus(localDataSets, results, FilterOption.FILTER_UNARCHIVED, Status.OK, AbstractArchiverProcessingPlugin.Operation.DELETE_FROM_ARCHIVE);
        if (localDataSets.size() > 0) {
            throw new NotImplementedException("Deleting from archive is not yet implemented for multi dataset archiver");
        }
        return results;
    }

    @Override
    protected BooleanStatus isDataSetSynchronizedWithArchive(DatasetDescription dataset, ArchiverTaskContext context) {
        return this.isDataSetPresentInArchive(dataset);
    }

    @Override
    protected BooleanStatus isDataSetPresentInArchive(DatasetDescription dataSet) {
        return BooleanStatus.createFromBoolean(this.isDataSetPresentInArchive(dataSet.getDataSetCode()));
    }

    protected boolean isDataSetPresentInArchive(String dataSetCode) {
        MultiDataSetArchiverDataSetDTO dataSetInArchiveDB = this.getReadonlyQuery().getDataSetForCode(dataSetCode);
        return dataSetInArchiveDB != null;
    }

    @Private
    IMultiDataSetFileOperationsManager getFileOperations() {
        if (this.fileOperations == null) {
            this.fileOperations = this.fileOperationsFactory.create();
        }
        return this.fileOperations;
    }

    @Private
    IMultiDataSetArchiverDBTransaction getTransaction() {
        return new MultiDataSetArchiverDBTransaction();
    }

    IMultiDataSetArchiverReadonlyQueryDAO getReadonlyQuery() {
        if (this.readonlyQuery == null) {
            this.readonlyQuery = MultiDataSetArchiverDataSourceUtil.getReadonlyQueryDAO();
        }
        return this.readonlyQuery;
    }

    IDataStoreServiceInternal getDataStoreService() {
        if (this.dataStoreService == null) {
            this.dataStoreService = ServiceProvider.getDataStoreService();
        }
        return this.dataStoreService;
    }

    IMultiDataSetArchiveCleaner getCleaner() {
        if (this.cleaner == null) {
            this.cleaner = MultiDataSetArchivingUtils.createCleaner(this.cleanerProperties);
        }
        return this.cleaner;
    }

    private static class FileOperationsManagerFactory
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Properties properties;
        private final ITimeAndWaitingProvider timeProvider;
        private IFreeSpaceProvider freeSpaceProviderOrNull;

        private FileOperationsManagerFactory(Properties properties, ITimeAndWaitingProvider timeProvider, IFreeSpaceProvider freeSpaceProviderOrNull) {
            this.properties = properties;
            this.timeProvider = timeProvider;
            this.freeSpaceProviderOrNull = freeSpaceProviderOrNull;
        }

        private IMultiDataSetFileOperationsManager create() {
            return new MultiDataSetFileOperationsManager(this.properties, new RsyncArchiveCopierFactory(), new SshCommandExecutorFactory(), this.freeSpaceProviderOrNull, this.timeProvider);
        }
    }

    private static enum FilterOption {
        FILTER_ARCHIVED,
        FILTER_UNARCHIVED;

    }

    private static class MultiDataSetUnarchivingPreparations
    implements IUnarchivingPreparation {
        private final Share scratchShare;
        private final IEncapsulatedOpenBISService service;
        private final IShareIdManager shareIdManager;
        private final IDataSetDirectoryProvider directoryProvider;

        MultiDataSetUnarchivingPreparations(Share scratchShare, IShareIdManager shareIdManager, IEncapsulatedOpenBISService service, IDataSetDirectoryProvider directoryProvider) {
            this.shareIdManager = shareIdManager;
            this.service = service;
            this.scratchShare = scratchShare;
            this.directoryProvider = directoryProvider;
        }

        @Override
        public void prepareForUnarchiving(List<DatasetDescription> dataSets) {
            for (DatasetDescription dataSet : dataSets) {
                SimpleDataSetInformationDTO translatedDataSet = SimpleDataSetHelper.translate(dataSet);
                String dataSetCode = dataSet.getDataSetCode();
                translatedDataSet.setDataSetShareId(null);
                String oldShareId = this.shareIdManager.getShareId(dataSetCode);
                String newShareId = this.scratchShare.getShareId();
                if (newShareId.equals(oldShareId)) continue;
                this.service.updateShareIdAndSize(dataSetCode, newShareId, dataSet.getDataSetSize());
                this.shareIdManager.setShareId(dataSetCode, newShareId);
            }
            SegmentedStoreUtils.freeSpace(this.scratchShare, this.service, dataSets, this.directoryProvider, this.shareIdManager, new Log4jSimpleLogger(operationLog));
        }
    }
}

