/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.entity;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.entity.PropertyTypesCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.entity.PropertyTypesFilterUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PropertyTypesCriteriaProvider
implements ICriteriaProvider<PropertyTypesCriteria> {
    private final IViewContext<?> viewContext;
    private final PropertyTypesCriteria criteria;
    private final EntityKind propertiesFilterOrNull;

    public PropertyTypesCriteriaProvider(IViewContext<?> viewContext, EntityKind propertiesFilterOrNull) {
        this.viewContext = viewContext;
        this.criteria = new PropertyTypesCriteria();
        this.propertiesFilterOrNull = propertiesFilterOrNull;
    }

    private void loadPropertyTypes(IDataRefreshCallback dataRefreshCallback) {
        DefaultResultSetConfig<String, TableModelRowWithObject<PropertyType>> config = DefaultResultSetConfig.createFetchAll();
        this.viewContext.getCommonService().listPropertyTypes(config, new ListPropertyTypesCallback(this.viewContext, dataRefreshCallback));
    }

    @Override
    public PropertyTypesCriteria tryGetCriteria() {
        if (this.criteria.tryGetPropertyTypes() == null) {
            return null;
        }
        return this.criteria;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications, IDataRefreshCallback dataRefreshCallback) {
        this.loadPropertyTypes(dataRefreshCallback);
    }

    private class ListPropertyTypesCallback
    extends AbstractAsyncCallback<TypedTableResultSet<PropertyType>> {
        private final IDataRefreshCallback dataRefreshCallback;

        public ListPropertyTypesCallback(IViewContext<?> viewContext, IDataRefreshCallback dataRefreshCallback) {
            super(viewContext);
            this.dataRefreshCallback = dataRefreshCallback;
        }

        @Override
        protected void process(TypedTableResultSet<PropertyType> result) {
            List<TableModelRowWithObject<PropertyType>> rows = result.getResultSet().getList().extractOriginalObjects();
            List<PropertyType> propertyTypes = new ArrayList<PropertyType>();
            for (TableModelRowWithObject<PropertyType> row : rows) {
                propertyTypes.add(row.getObjectOrNull());
            }
            if (PropertyTypesCriteriaProvider.this.propertiesFilterOrNull != null) {
                propertyTypes = PropertyTypesFilterUtil.filterPropertyTypesForEntityKind(propertyTypes, PropertyTypesCriteriaProvider.this.propertiesFilterOrNull);
            }
            PropertyTypesCriteriaProvider.this.criteria.setPropertyTypes(propertyTypes);
            this.dataRefreshCallback.postRefresh(true);
        }
    }
}

