/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class PersonsProvider
extends AbstractCommonTableModelProvider<Person> {
    private final TechId authorizationGroupIdOrNull;

    public PersonsProvider(ICommonServer commonServer, String sessionToken, TechId authorizationGroupIdOrNull) {
        super(commonServer, sessionToken);
        this.authorizationGroupIdOrNull = authorizationGroupIdOrNull;
    }

    @Override
    protected TypedTableModel<Person> createTableModel() {
        List<Person> persons = this.authorizationGroupIdOrNull == null ? this.commonServer.listPersons(this.sessionToken) : this.commonServer.listPersonInAuthorizationGroup(this.sessionToken, this.authorizationGroupIdOrNull);
        TypedTableModelBuilder<Person> builder = new TypedTableModelBuilder<Person>();
        builder.addColumn("USER_ID");
        builder.addColumn("FIRST_NAME");
        builder.addColumn("LAST_NAME");
        builder.addColumn("EMAIL").withDefaultWidth(200);
        builder.addColumn("REGISTRATOR");
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300);
        builder.addColumn("IS_ACTIVE").withDefaultWidth(80);
        for (Person person : persons) {
            builder.addRow(person);
            builder.column("USER_ID").addString(person.getUserId());
            builder.column("FIRST_NAME").addString(person.getFirstName());
            builder.column("LAST_NAME").addString(person.getLastName());
            builder.column("EMAIL").addString(person.getEmail());
            builder.column("REGISTRATOR").addPerson(person.getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(person.getRegistrationDate());
            builder.column("IS_ACTIVE").addString(Boolean.toString(person.isActive()));
        }
        return builder.getModel();
    }
}

