/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.managed_property;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.EntityLinkElementTranslator;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityLinkElement;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="entity-information-provider")
public class EntityInformationProvider
implements IEntityInformationProvider {
    private final IDAOFactory daoFactory;

    @Autowired
    public EntityInformationProvider(IDAOFactory daoFactory) {
        assert (daoFactory != null);
        this.daoFactory = daoFactory;
    }

    @Override
    public String getIdentifier(IEntityLinkElement entityLink) {
        EntityKind entityKind = EntityLinkElementTranslator.translate(entityLink.getEntityLinkKind());
        String permId = entityLink.getPermId();
        return this.getIdentifier(entityKind, permId);
    }

    private String getIdentifier(EntityKind entityKind, String permId) {
        IIdentifierHolder identifierHolderOrNull = null;
        switch (entityKind) {
            case EXPERIMENT: {
                identifierHolderOrNull = this.daoFactory.getExperimentDAO().tryGetByPermID(permId);
                break;
            }
            case SAMPLE: {
                identifierHolderOrNull = this.daoFactory.getSampleDAO().tryToFindByPermID(permId);
                break;
            }
            case DATA_SET: {
                identifierHolderOrNull = this.daoFactory.getDataDAO().tryToFindDataSetByCode(permId);
                break;
            }
            case MATERIAL: {
                MaterialIdentifier idOrNull = MaterialIdentifier.tryParseIdentifier(permId);
                if (idOrNull == null) {
                    return null;
                }
                final MaterialPE materialOrNull = this.daoFactory.getMaterialDAO().tryFindMaterial(idOrNull);
                if (materialOrNull == null) {
                    return null;
                }
                identifierHolderOrNull = new IIdentifierHolder(){

                    @Override
                    public String getIdentifier() {
                        return new MaterialIdentifier(materialOrNull.getCode(), materialOrNull.getEntityType().getCode()).print();
                    }
                };
            }
        }
        return identifierHolderOrNull == null ? null : identifierHolderOrNull.getIdentifier();
    }

    private SpacePE tryGetSpaceByCode(String spaceCode) {
        DatabaseInstancePE homeInstance = this.daoFactory.getDatabaseInstanceDAO().getHomeInstance();
        SpacePE space = this.daoFactory.getSpaceDAO().tryFindSpaceByCodeAndDatabaseInstance(spaceCode, homeInstance);
        if (space == null) {
            throw UserFailureException.fromTemplate("space '%s' doesn't exist ", spaceCode);
        }
        return space;
    }

    @Override
    public String getSamplePermId(String spaceCode, String sampleCode) {
        SpacePE space = this.tryGetSpaceByCode(spaceCode);
        SamplePE sample = this.daoFactory.getSampleDAO().tryFindByCodeAndSpace(sampleCode, space);
        return sample != null ? sample.getPermId() : null;
    }

    @Override
    public String getSamplePermId(String sampleIdentifier) {
        SampleIdentifier identifier = SampleIdentifierFactory.parse(sampleIdentifier);
        String sampleCode = identifier.getSampleCode();
        if (identifier.isSpaceLevel()) {
            String spaceCode = identifier.getSpaceLevel().getSpaceCode();
            return this.getSamplePermId(spaceCode, sampleCode);
        }
        DatabaseInstancePE homeInstance = this.daoFactory.getDatabaseInstanceDAO().getHomeInstance();
        SamplePE sample = this.daoFactory.getSampleDAO().tryFindByCodeAndDatabaseInstance(sampleCode, homeInstance);
        return sample != null ? sample.getPermId() : null;
    }

    private List<String> getSamplesPermIds(List<SamplePE> samples) {
        if (samples == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> samplePermIds = new ArrayList<String>(samples.size());
        for (SamplePE sample : samples) {
            samplePermIds.add(sample.getPermId());
        }
        return samplePermIds;
    }

    private SamplePE getSampleByPermId(String permId) {
        SamplePE sample = this.daoFactory.getSampleDAO().tryToFindByPermID(permId);
        if (sample == null) {
            throw UserFailureException.fromTemplate("sample '%s' doesn't exist", permId);
        }
        return sample;
    }

    @Override
    public List<String> getSampleParentPermIds(String spaceCode, String sampleCode) {
        SpacePE space = this.tryGetSpaceByCode(spaceCode);
        SamplePE sample = this.daoFactory.getSampleDAO().tryFindByCodeAndSpace(sampleCode, space);
        if (sample == null) {
            throw UserFailureException.fromTemplate("sample '%s' doesn't exist in space %s", sampleCode, spaceCode);
        }
        return this.getSamplesPermIds(sample.getParents());
    }

    @Override
    public List<String> getSampleParentPermIds(String permId) {
        return this.getSamplesPermIds(this.getSampleByPermId(permId).getParents());
    }

    @Override
    public String getSamplePropertyValue(String permId, String propertyCode) {
        SamplePE sample = this.getSampleByPermId(permId);
        for (SamplePropertyPE property : sample.getProperties()) {
            if (!propertyCode.equalsIgnoreCase(property.getEntityTypePropertyType().getPropertyType().getCode())) continue;
            return property.getValue();
        }
        return "";
    }
}

