/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.annotation.DoNotEscape;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@DoNotEscape
public class LastModificationState
implements Serializable {
    private static final long serialVersionUID = 35L;
    private Map<DatabaseModificationKind, Long> state = new HashMap<DatabaseModificationKind, Long>();
    private long initializationTimestamp = new Date().getTime();

    public synchronized void registerModification(DatabaseModificationKind kind, long currentTimestamp) {
        Long prev = this.state.get(kind);
        if (prev != null && prev > currentTimestamp) {
            return;
        }
        this.state.put(kind, currentTimestamp);
    }

    public long getLastModificationTime(DatabaseModificationKind kind) {
        Long lastModification = this.state.get(kind);
        if (lastModification == null) {
            return this.initializationTimestamp;
        }
        return lastModification;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<DatabaseModificationKind> keys = this.state.keySet();
        for (DatabaseModificationKind modification : keys) {
            sb.append("Time ");
            sb.append(new Date(this.state.get(modification)));
            sb.append(": ");
            sb.append(modification);
            sb.append("\n");
        }
        return sb.toString();
    }
}

