/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypeTranslator;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinRelatedSampleTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.SampleIDProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Occurrence;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.OccurrenceUtil;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinRelatedSample;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.AbstractSample;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.SampleAbundance;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.SamplePeptideModification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.DataSet;

class ProteinRelatedSampleTable
implements IProteinRelatedSampleTable {
    private final IDAOFactory daoFactory;
    private final IPhosphoNetXDAOFactory specificDAOFactory;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    private List<ProteinRelatedSample> result;

    ProteinRelatedSampleTable(IDAOFactory daoFactory, IPhosphoNetXDAOFactory specificDAOFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.daoFactory = daoFactory;
        this.specificDAOFactory = specificDAOFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    @Override
    public List<ProteinRelatedSample> getSamples() {
        return this.result;
    }

    @Override
    public void load(TechId experimentID, TechId proteinReferenceID, String sequenceOrNull) {
        SamplePE sample;
        String key;
        String experimentPermID = ((ExperimentPE)this.daoFactory.getExperimentDAO().getByTechId(experimentID)).getPermId();
        IProteinQueryDAO proteinQueryDAO = this.specificDAOFactory.getProteinQueryDAO(experimentID);
        Map<String, List<SampleAbundance>> sampleAbundanceMap = this.createSampleMap(proteinQueryDAO.listSampleAbundanceByProtein(experimentPermID, proteinReferenceID.getId()));
        Map<String, List<SamplePeptideModification>> samplePeptideModificationMap = this.createSampleMap(proteinQueryDAO.listSamplePeptideModificatioByProtein(experimentPermID, proteinReferenceID.getId()));
        this.result = new ArrayList<ProteinRelatedSample>();
        SampleIDProvider sampleIDProvider = new SampleIDProvider(this.daoFactory.getSampleDAO());
        HashMap<PropertyTypePE, PropertyType> cache = new HashMap<PropertyTypePE, PropertyType>();
        for (Map.Entry<String, List<SampleAbundance>> entry : sampleAbundanceMap.entrySet()) {
            key = entry.getKey();
            sample = sampleIDProvider.getSampleOrParentSample(key);
            List<SampleAbundance> sampleAbundances = entry.getValue();
            List<SamplePeptideModification> samplePeptideModifications = samplePeptideModificationMap.get(key);
            if (samplePeptideModifications == null) {
                for (SampleAbundance sampleAbundance : sampleAbundances) {
                    ProteinRelatedSample s = this.createFrom(sample, cache);
                    s.setAbundance(sampleAbundance.getAbundance());
                    this.result.add(s);
                }
                continue;
            }
            for (SampleAbundance sampleAbundance : sampleAbundances) {
                Double abundance = sampleAbundance.getAbundance();
                this.result.addAll(this.createSamplesForPeptideModifications(samplePeptideModifications, sample, abundance, sequenceOrNull, cache));
            }
        }
        for (Map.Entry<String, List<AbstractSample>> entry : samplePeptideModificationMap.entrySet()) {
            key = entry.getKey();
            if (sampleAbundanceMap.containsKey(key)) continue;
            sample = sampleIDProvider.getSampleOrParentSample(key);
            List<AbstractSample> samplePeptideModifications = entry.getValue();
            this.result.addAll(this.createSamplesForPeptideModifications(samplePeptideModifications, sample, null, sequenceOrNull, cache));
        }
    }

    private List<ProteinRelatedSample> createSamplesForPeptideModifications(List<SamplePeptideModification> samplePeptideModifications, SamplePE sample, Double abundanceOrNull, String sequenceOrNull, Map<PropertyTypePE, PropertyType> cache) {
        ArrayList<ProteinRelatedSample> samples = new ArrayList<ProteinRelatedSample>();
        for (SamplePeptideModification samplePeptideModification : samplePeptideModifications) {
            int position = samplePeptideModification.getPosition();
            if (sequenceOrNull != null) {
                List<Occurrence> occurances = OccurrenceUtil.findAllOccurrences(sequenceOrNull, samplePeptideModification.getSequence());
                for (Occurrence occurrence : occurances) {
                    samples.add(this.createProteinRelatedSample(samplePeptideModification, sample, abundanceOrNull, position + occurrence.getStartIndex(), cache));
                }
                continue;
            }
            samples.add(this.createProteinRelatedSample(samplePeptideModification, sample, abundanceOrNull, position, cache));
        }
        return samples;
    }

    private ProteinRelatedSample createProteinRelatedSample(SamplePeptideModification samplePeptideModification, SamplePE sample, Double abundanceOrNull, int position, Map<PropertyTypePE, PropertyType> cache) {
        ProteinRelatedSample s = this.createFrom(sample, cache);
        s.setAbundance(abundanceOrNull);
        int index = samplePeptideModification.getPosition() - 1;
        String sequence = samplePeptideModification.getSequence();
        if (index >= 0 && index < sequence.length()) {
            s.setModifiedAminoAcid(sequence.charAt(index));
        }
        s.setModificationFraction(samplePeptideModification.getFraction());
        s.setModificationMass(samplePeptideModification.getMass());
        s.setModificationPosition(Long.valueOf(position));
        return s;
    }

    private ProteinRelatedSample createFrom(SamplePE sample, Map<PropertyTypePE, PropertyType> cache) {
        ProteinRelatedSample s = new ProteinRelatedSample();
        s.setCode(sample.getCode());
        s.setEntityType(SampleTypeTranslator.translate(sample.getSampleType(), cache));
        s.setId(sample.getId());
        s.setIdentifier(sample.getIdentifier());
        s.setPermId(sample.getPermId());
        s.setProperties(EntityPropertyTranslator.translate(sample.getProperties(), cache, this.managedPropertyEvaluatorFactory));
        return s;
    }

    private <T extends AbstractSample> Map<String, List<T>> createSampleMap(DataSet<T> items) {
        LinkedHashMap<String, List<T>> map = new LinkedHashMap<String, List<T>>();
        try {
            for (AbstractSample item : items) {
                String samplePermID = item.getSamplePermID();
                ArrayList<AbstractSample> list = (ArrayList<AbstractSample>)map.get(samplePermID);
                if (list == null) {
                    list = new ArrayList<AbstractSample>();
                    map.put(samplePermID, list);
                }
                list.add(item);
            }
        }
        finally {
            items.close();
        }
        return map;
    }
}

