/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.IRealNumberRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.WellData;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.HeatmapPresenter;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.PlateLayouterModel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import java.util.Collections;
import java.util.List;

class WellTooltipGenerator
implements HeatmapPresenter.IWellTooltipGenerator {
    private static final String UNKNOWN_WELL_LABEL = "No well information available.";
    private static final String NEWLINE = "\n";
    private static final int MAX_DESCRIBED_FEATURES = 20;
    private final PlateLayouterModel model;
    private final IRealNumberRenderer realNumberRenderer;

    public WellTooltipGenerator(PlateLayouterModel model, IRealNumberRenderer realNumberRenderer) {
        this.model = model;
        this.realNumberRenderer = realNumberRenderer;
    }

    @Override
    public String generateTooltip(int rowIx, int colIx, CodeAndLabel distinguishedLabelOrNull) {
        WellData wellData = this.model.getWellMatrix()[rowIx][colIx];
        return this.generateShortDescription(wellData, distinguishedLabelOrNull);
    }

    private String generateShortDescription(WellData wellData, CodeAndLabel distinguishedLabelOrNull) {
        String labelOrNull;
        String tooltip = "";
        String string = labelOrNull = distinguishedLabelOrNull == null ? null : distinguishedLabelOrNull.getLabel();
        if (distinguishedLabelOrNull != null) {
            tooltip = String.valueOf(tooltip) + this.generateOneFeatureDescription(wellData, labelOrNull, true);
        }
        tooltip = String.valueOf(tooltip) + WellTooltipGenerator.generateMetadataDescription(wellData);
        int allFeaturesNum = this.getNumberOfAllFeatures();
        int loadedFeaturesNum = this.getNumberOfLoadedFeatures(wellData);
        if (loadedFeaturesNum - (distinguishedLabelOrNull != null ? 1 : 0) > 0) {
            tooltip = tooltip.length() == 0 ? String.valueOf(tooltip) + WellTooltipGenerator.getWellCodeDescription(wellData) : String.valueOf(tooltip) + NEWLINE;
            int describedFeaturesNum = Math.min(20, loadedFeaturesNum);
            int fCounter = 0;
            for (String featureLabel : wellData.getFeatureLabels()) {
                if (!featureLabel.equals(labelOrNull)) {
                    tooltip = String.valueOf(tooltip) + this.generateOneFeatureDescription(wellData, featureLabel, false);
                }
                if (++fCounter == describedFeaturesNum) break;
            }
            if (allFeaturesNum > describedFeaturesNum) {
                tooltip = String.valueOf(tooltip) + "...";
            }
        }
        return StringUtils.isBlank(tooltip) ? UNKNOWN_WELL_LABEL : tooltip;
    }

    private int getNumberOfLoadedFeatures(WellData wellData) {
        return wellData.getFeatureLabels().size();
    }

    private int getNumberOfAllFeatures() {
        return this.model.getAllFeatureNames().size();
    }

    private String generateOneFeatureDescription(WellData wellData, String featureLabel, boolean distinguished) {
        String textValue;
        FeatureValue value = wellData.tryGetFeatureValue(featureLabel);
        if (value == null && !distinguished) {
            return "";
        }
        String string = textValue = value == null ? "" : this.renderValue(value);
        if (distinguished) {
            textValue = "<b>" + textValue + "</b>";
        }
        return String.valueOf(featureLabel) + ": " + textValue + NEWLINE;
    }

    private String renderValue(FeatureValue value) {
        if (value.isFloat()) {
            return this.renderFloat(value.asFloat());
        }
        return value.toString();
    }

    private String renderFloat(float value) {
        return this.realNumberRenderer.render(value);
    }

    private static String generateMetadataDescription(WellData wellData) {
        WellMetadata metadata = wellData.tryGetMetadata();
        if (metadata == null) {
            return "";
        }
        String tooltip = WellTooltipGenerator.getWellCodeDescription(metadata);
        List<IEntityProperty> properties = metadata.getWellSample().getProperties();
        Collections.sort(properties);
        for (IEntityProperty property : properties) {
            PropertyType propertyType = property.getPropertyType();
            tooltip = String.valueOf(tooltip) + NEWLINE + propertyType.getLabel() + ": " + WellTooltipGenerator.getPropertyDisplayText(property);
            Material material = property.getMaterial();
            if (material == null || !material.getMaterialType().getCode().equalsIgnoreCase("GENE")) continue;
            List<IEntityProperty> geneProperties = material.getProperties();
            for (IEntityProperty geneProperty : geneProperties) {
                if (!geneProperty.getPropertyType().getCode().equalsIgnoreCase("GENE_SYMBOLS")) continue;
                tooltip = String.valueOf(tooltip) + " [" + geneProperty.tryGetAsString() + "]";
            }
        }
        return String.valueOf(tooltip) + NEWLINE;
    }

    private static String getPropertyDisplayText(IEntityProperty property) {
        Material material = property.getMaterial();
        if (material != null) {
            return String.valueOf(material.getCode()) + " (" + material.getMaterialType().getCode() + ")";
        }
        return property.tryGetAsString();
    }

    private static String getWellCodeDescription(WellData wellData) {
        WellMetadata metadata = wellData.tryGetMetadata();
        return metadata == null ? "" : String.valueOf(WellTooltipGenerator.getWellCodeDescription(metadata)) + NEWLINE;
    }

    private static String getWellCodeDescription(WellMetadata metadata) {
        Sample wellSample = metadata.getWellSample();
        String sampleTypeCode = wellSample.getSampleType().getCode();
        return String.valueOf(WellTooltipGenerator.printFriendlyCode(sampleTypeCode)) + ": " + wellSample.getSubCode();
    }

    static String printFriendlyCode(String code) {
        String[] tokens = code.split("_|-");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(WellTooltipGenerator.capitalizeFirst(tokens[i]));
            ++i;
        }
        return sb.toString();
    }

    private static String capitalizeFirst(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return String.valueOf(("" + value.charAt(0)).toUpperCase()) + value.substring(1).toLowerCase();
    }
}

