/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.BitBuffer;
import loci.formats.meta.MetadataStore;

public class APNGReader
extends FormatReader {
    private static final int GRAYSCALE = 0;
    private static final int TRUE_COLOR = 2;
    private static final int INDEXED = 3;
    private static final int GRAY_ALPHA = 4;
    private static final int TRUE_ALPHA = 6;
    private static final int NONE = 0;
    private static final int SUB = 1;
    private static final int UP = 2;
    private static final int AVERAGE = 3;
    private static final int PAETH = 4;
    private static final int[] PASS_WIDTHS = new int[]{1, 1, 2, 2, 4, 4, 8};
    private static final int[] PASS_HEIGHTS = new int[]{1, 1, 1, 2, 2, 4, 4};
    private Vector<PNGBlock> blocks;
    private Vector<int[]> frameCoordinates;
    private byte[][] lut;
    private byte[] lastImage;
    private int lastImageIndex = -1;
    private int compression;
    private int interlace;
    private int idatCount = 0;

    public APNGReader() {
        super("Animated PNG", "png");
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        byte[] signature = new byte[8];
        stream.read(signature);
        return signature[0] == -119 && signature[1] == 80 && signature[2] == 78 && signature[3] == 71 && signature[4] == 13 && signature[5] == 10 && signature[6] == 26 && signature[7] == 10;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (no == this.lastImageIndex && this.lastImage != null) {
            RandomAccessInputStream s = new RandomAccessInputStream(this.lastImage);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
            return buf;
        }
        if (no == 0) {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            int readIDATs = 0;
            for (PNGBlock block : this.blocks) {
                if (block.type.equals("IDAT")) {
                    this.in.seek(block.offset);
                    byte[] tmp = new byte[block.length];
                    this.in.read(tmp);
                    s.write(tmp);
                    tmp = null;
                    ++readIDATs;
                }
                if (readIDATs != this.idatCount) continue;
                break;
            }
            s.close();
            this.lastImage = this.decode(s.toByteArray());
            this.lastImageIndex = 0;
            RandomAccessInputStream pix = new RandomAccessInputStream(this.lastImage);
            this.readPlane(pix, x, y, w, h, buf);
            pix.close();
            return buf;
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        int readIDATs = 0;
        for (PNGBlock block : this.blocks) {
            if (block.type.equals("IDAT")) {
                this.in.seek(block.offset);
                byte[] tmp = new byte[block.length];
                this.in.read(tmp);
                s.write(tmp);
                tmp = null;
                ++readIDATs;
            }
            if (readIDATs != this.idatCount) continue;
            break;
        }
        boolean fdatValid = false;
        int fctlCount = 0;
        int[] coords = this.frameCoordinates.get(no);
        s = new ByteArrayOutputStream();
        for (PNGBlock block : this.blocks) {
            if (block.type.equals("fcTL")) {
                fdatValid = fctlCount == no;
                ++fctlCount;
                continue;
            }
            if (!block.type.equals("fdAT")) continue;
            this.in.seek(block.offset + 4L);
            if (!fdatValid) continue;
            byte[] tmp = new byte[block.length - 4];
            this.in.read(tmp);
            s.write(tmp);
            tmp = null;
        }
        s.close();
        this.lastImage = this.openBytes(0);
        byte[] newImage = this.decode(s.toByteArray(), coords[2], coords[3]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int len = coords[2] * bpp;
        int plane = this.getSizeX() * this.getSizeY() * bpp;
        int newPlane = len * coords[3];
        for (int c = 0; c < this.getRGBChannelCount(); ++c) {
            for (int row = 0; row < coords[3]; ++row) {
                System.arraycopy(newImage, c * newPlane + row * len, this.lastImage, c * plane + (coords[1] + row) * this.getSizeX() * bpp + coords[0] * bpp, len);
            }
        }
        this.lastImageIndex = no;
        RandomAccessInputStream pix = new RandomAccessInputStream(this.lastImage);
        this.readPlane(pix, x, y, w, h, buf);
        pix.close();
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lut = null;
            this.frameCoordinates = null;
            this.blocks = null;
            this.lastImage = null;
            this.lastImageIndex = -1;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        byte[] signature = new byte[8];
        this.in.read(signature);
        if (signature[0] != -119 || signature[1] != 80 || signature[2] != 78 || signature[3] != 71 || signature[4] != 13 || signature[5] != 10 || signature[6] != 26 || signature[7] != 10) {
            throw new FormatException("Invalid PNG signature.");
        }
        this.blocks = new Vector();
        this.frameCoordinates = new Vector();
        while (this.in.getFilePointer() < this.in.length()) {
            int length = this.in.readInt();
            String type = this.in.readString(4);
            PNGBlock block = new PNGBlock();
            block.length = length;
            block.type = type;
            block.offset = this.in.getFilePointer();
            this.blocks.add(block);
            if (type.equals("acTL")) {
                this.core[0].imageCount = this.in.readInt();
                int loop = this.in.readInt();
                this.addGlobalMeta("Loop count", loop);
            } else if (type.equals("fcTL")) {
                this.in.skipBytes(4);
                int w = this.in.readInt();
                int h = this.in.readInt();
                int x = this.in.readInt();
                int y = this.in.readInt();
                this.frameCoordinates.add(new int[]{x, y, w, h});
                this.in.skipBytes(length - 20);
            } else if (type.equals("IDAT")) {
                ++this.idatCount;
            } else if (type.equals("PLTE")) {
                this.core[0].indexed = true;
                this.lut = new byte[3][256];
                for (int i = 0; i < length / 3; ++i) {
                    for (int c = 0; c < 3; ++c) {
                        this.lut[c][i] = this.in.readByte();
                    }
                }
            } else if (type.equals("IHDR")) {
                this.core[0].sizeX = this.in.readInt();
                this.core[0].sizeY = this.in.readInt();
                this.core[0].bitsPerPixel = this.in.read();
                int colorType = this.in.read();
                this.compression = this.in.read();
                int filter = this.in.read();
                this.interlace = this.in.read();
                if (filter != 0) {
                    throw new FormatException("Invalid filter mode: " + filter);
                }
                switch (colorType) {
                    case 0: 
                    case 3: {
                        this.core[0].sizeC = 1;
                        break;
                    }
                    case 4: {
                        this.core[0].sizeC = 2;
                        break;
                    }
                    case 2: {
                        this.core[0].sizeC = 3;
                        break;
                    }
                    case 6: {
                        this.core[0].sizeC = 4;
                    }
                }
                this.core[0].pixelType = this.getBitsPerPixel() <= 8 ? 1 : 3;
                this.core[0].rgb = this.getSizeC() > 1;
            } else if (type.equals("IEND")) break;
            this.in.seek(block.offset + (long)length);
            if (this.in.getFilePointer() >= this.in.length() - 4L) continue;
            this.in.skipBytes(4);
        }
        if (this.core[0].imageCount == 0) {
            this.core[0].imageCount = 1;
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = this.getImageCount();
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].interleaved = false;
        this.core[0].falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private byte[] decode(byte[] bytes) throws FormatException, IOException {
        return this.decode(bytes, this.getSizeX(), this.getSizeY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decode(byte[] bytes, int width, int height) throws FormatException, IOException {
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int rowLen = width * this.getRGBChannelCount() * bpp;
        if (this.getBitsPerPixel() < bpp * 8) {
            rowLen /= bpp * 8 / this.getBitsPerPixel();
        }
        byte[] image = null;
        if (this.compression == 0 && this.interlace == 0) {
            byte[] filters = new byte[height];
            image = new byte[rowLen * height];
            InflaterInputStream decompressor = new InflaterInputStream(new ByteArrayInputStream(bytes));
            try {
                for (int row = 0; row < height; ++row) {
                    int n = 0;
                    while (n < 1) {
                        n = decompressor.read(filters, row, 1);
                    }
                    for (n = 0; n < rowLen; n += decompressor.read(image, row * rowLen + n, rowLen - n)) {
                    }
                }
            }
            finally {
                decompressor.close();
            }
            this.unfilter(filters, image, width, height);
        } else if (this.compression == 0) {
            boolean byteCount = false;
            byte[][] passImages = new byte[7][];
            int nRowBlocks = height / 8;
            int nColBlocks = width / 8;
            image = new byte[FormatTools.getPlaneSize(this)];
            InflaterInputStream decompressor = new InflaterInputStream(new ByteArrayInputStream(bytes));
            try {
                for (int i = 0; i < passImages.length; ++i) {
                    int passWidth = PASS_WIDTHS[i] * nColBlocks;
                    int passHeight = PASS_HEIGHTS[i] * nRowBlocks;
                    int rowSize = passWidth * bpp * this.getRGBChannelCount();
                    byte[] filters = new byte[passHeight];
                    passImages[i] = new byte[rowSize * passHeight];
                    for (int row = 0; row < passHeight; ++row) {
                        int n = 0;
                        while (n < 1) {
                            n = decompressor.read(filters, row, 1);
                        }
                        for (n = 0; n < rowSize; n += decompressor.read(passImages[i], row * rowSize + n, rowSize - n)) {
                        }
                    }
                    this.unfilter(filters, passImages[i], passWidth, passHeight);
                }
            }
            finally {
                decompressor.close();
            }
            int chunk = bpp * this.getRGBChannelCount();
            int[] passOffset = new int[7];
            for (int row = 0; row < height; ++row) {
                int rowOffset = row * width * chunk;
                for (int col = 0; col < width; ++col) {
                    int blockRow = row % 8;
                    int blockCol = col % 8;
                    int pass = -1;
                    pass = blockRow % 2 == 1 ? 6 : (blockRow == 0 || blockRow == 4 ? (blockCol % 2 == 1 ? 5 : (blockCol == 0 ? (blockRow == 0 ? 0 : 2) : (blockCol == 4 ? (blockRow == 0 ? 1 : 2) : 3))) : 4 + blockCol % 2);
                    int colOffset = col * chunk;
                    for (int c = 0; c < chunk; ++c) {
                        int n = pass;
                        int n2 = passOffset[n];
                        passOffset[n] = n2 + 1;
                        image[rowOffset + colOffset + c] = passImages[pass][n2];
                    }
                }
            }
        } else {
            throw new UnsupportedCompressionException("Compression type " + this.compression + " not supported");
        }
        if (this.getBitsPerPixel() < 8) {
            byte[] expandedImage = new byte[FormatTools.getPlaneSize(this)];
            BitBuffer bits = new BitBuffer(image);
            for (int i = 0; i < expandedImage.length; ++i) {
                expandedImage[i] = (byte)(bits.getBits(this.getBitsPerPixel()) & 0xFF);
            }
            image = expandedImage;
        }
        byte[] deinterleave = new byte[image.length];
        for (int c = 0; c < this.getRGBChannelCount(); ++c) {
            int plane = c * width * height * bpp;
            for (int row = 0; row < height; ++row) {
                int srcRow = row * width * this.getRGBChannelCount() * bpp;
                int destRow = row * width * bpp;
                for (int col = 0; col < width; ++col) {
                    int srcCol = col * this.getRGBChannelCount() * bpp;
                    int destCol = col * bpp;
                    for (int b = 0; b < bpp; ++b) {
                        deinterleave[plane + destRow + destCol + b] = image[srcRow + srcCol + c * bpp + b];
                    }
                }
            }
        }
        return deinterleave;
    }

    private void unfilter(byte[] filters, byte[] image, int width, int height) {
        int bpp = this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType());
        int rowLen = width * bpp;
        for (int row = 0; row < height; ++row) {
            byte filter = filters[row];
            if (filter == 0) continue;
            block7: for (int col = 0; col < rowLen; ++col) {
                int q = row * rowLen + col;
                int xx = image[q] & 0xFF;
                int a = col >= bpp ? image[q - bpp] & 0xFF : 0;
                int b = row > 0 ? image[q - bpp * width] & 0xFF : 0;
                int c = row > 0 && col >= bpp ? image[q - bpp * (width + 1)] & 0xFF : 0;
                switch (filter) {
                    case 1: {
                        image[q] = (byte)(xx + a & 0xFF);
                        continue block7;
                    }
                    case 2: {
                        image[q] = (byte)(xx + b & 0xFF);
                        continue block7;
                    }
                    case 3: {
                        image[q] = (byte)(xx + (int)Math.floor(a + b) / 2 & 0xFF);
                        continue block7;
                    }
                    case 4: {
                        int p = a + b - c;
                        int pa = Math.abs(p - a);
                        int pb = Math.abs(p - b);
                        int pc = Math.abs(p - c);
                        image[q] = pa <= pb && pa <= pc ? (byte)(xx + a & 0xFF) : (pb <= pc ? (byte)(xx + b & 0xFF) : (byte)(xx + c & 0xFF));
                    }
                }
            }
        }
    }

    class PNGBlock {
        public long offset;
        public int length;
        public String type;

        PNGBlock() {
        }
    }
}

