/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.IJ;
import java.util.HashSet;
import java.util.Iterator;

public final class LibraryChecker {
    public static final String IMAGEJ_VERSION = "1.43";
    public static final String IMAGEJ_MSG = "Sorry, the LOCI plugins require ImageJ v1.43 or later.";
    public static final String URL_LOCI_SOFTWARE = "http://www.loci.wisc.edu/software";

    private LibraryChecker() {
    }

    public static boolean checkClass(String className) {
        try {
            Class.forName(className);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void checkLibrary(Library library, HashSet<String> missing) {
        switch (library) {
            case BIO_FORMATS: {
                LibraryChecker.checkLibrary("org.apache.log4j.Logger", "log4j1.2.17.jar", missing);
                LibraryChecker.checkLibrary("org.slf4j.Logger", "slf4j-api-1.7.2.jar", missing);
                LibraryChecker.checkLibrary("org.slf4j.impl.Log4jLoggerFactory", "slf4j-log4j12-1.7.2.jar", missing);
                LibraryChecker.checkLibrary("loci.common.RandomAccessInputStream", "loci-common.jar", missing);
                LibraryChecker.checkLibrary("loci.formats.FormatHandler", "bio-formats.jar", missing);
                LibraryChecker.checkLibrary("loci.poi.poifs.filesystem.POIFSDocument", "poi-loci.jar", missing);
                LibraryChecker.checkLibrary("mdbtools.libmdb.MdbFile", "mdbtools-java.jar", missing);
                break;
            }
            case OME_JAVA_XML: {
                LibraryChecker.checkLibrary("ome.xml.OMEXMLNode", "ome-xml.jar", missing);
                break;
            }
            case OME_JAVA_DS: {
                LibraryChecker.checkLibrary("org.openmicroscopy.ds.DataServer", "ome-java.jar", missing);
                LibraryChecker.checkLibrary("org.apache.xmlrpc.XmlRpcClient", "xmlrpc-1.2-b1.jar", missing);
                LibraryChecker.checkLibrary("org.apache.commons.httpclient.HttpClient", "commons-httpclient-2.0-rc2.jar", missing);
                LibraryChecker.checkLibrary("org.apache.commons.logging.Log", "commons-logging.jar", missing);
                break;
            }
            case FORMS: {
                LibraryChecker.checkLibrary("com.jgoodies.forms.layout.FormLayout", "forms-1.3.0.jar", missing);
            }
        }
    }

    public static void checkLibrary(String className, String jarFile, HashSet<String> missing) {
        if (!LibraryChecker.checkClass(className)) {
            missing.add(jarFile);
        }
    }

    public static boolean checkJava() {
        String version = System.getProperty("java.version");
        double ver = Double.parseDouble(version.substring(0, 3));
        if (ver < 1.6) {
            IJ.error((String)"LOCI Plugins", (String)"Sorry, the LOCI plugins require Java 1.6 or later.\nYou can download ImageJ with JRE 1.6 from the ImageJ web site.");
            return false;
        }
        return true;
    }

    public static boolean checkImageJ() {
        return LibraryChecker.checkImageJ(IMAGEJ_VERSION, IMAGEJ_MSG);
    }

    public static boolean checkImageJ(String target, String msg) {
        return LibraryChecker.checkImageJ(target, msg, "LOCI Plugins");
    }

    public static boolean checkImageJ(String target, String msg, String title) {
        boolean success;
        try {
            String current = IJ.getVersion();
            success = current != null && current.compareTo(target) >= 0;
        }
        catch (NoSuchMethodError err) {
            success = false;
        }
        if (!success) {
            IJ.error((String)title, (String)msg);
        }
        return success;
    }

    public static boolean checkMissing(HashSet<String> missing) {
        int num = missing.size();
        if (num == 0) {
            return true;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("The following librar");
        sb.append(num == 1 ? "y was" : "ies were");
        sb.append(" not found:");
        Iterator<String> iter = missing.iterator();
        for (int i = 0; i < num; ++i) {
            sb.append("\n    " + iter.next());
        }
        String them = num == 1 ? "it" : "them";
        sb.append("\nPlease download ");
        sb.append(them);
        sb.append(" from the LOCI website at");
        sb.append("\n    http://www.loci.wisc.edu/software");
        sb.append("\nand place ");
        sb.append(them);
        sb.append(" in the ImageJ plugins folder.");
        IJ.error((String)"LOCI Plugins", (String)sb.toString());
        return false;
    }

    public static enum Library {
        BIO_FORMATS,
        OME_JAVA_XML,
        OME_JAVA_DS,
        FORMS;

    }
}

