/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DByte;
import opendap.dap.DConnect2;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DGrid;
import opendap.dap.DInt16;
import opendap.dap.DInt32;
import opendap.dap.DSequence;
import opendap.dap.DString;
import opendap.dap.DStructure;
import opendap.dap.DUInt16;
import opendap.dap.DUInt32;
import opendap.dap.DataDDS;
import opendap.dap.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileCache;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.ConvertD2N;
import ucar.nc2.dods.DODSAttribute;
import ucar.nc2.dods.DODSGrid;
import ucar.nc2.dods.DODSStructure;
import ucar.nc2.dods.DODSVariable;
import ucar.nc2.dods.DodsV;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DODSNetcdfFile
extends NetcdfFile {
    public static boolean debugCE = false;
    public static boolean debugServerCall = false;
    public static boolean debugOpenResult = false;
    public static boolean debugDataResult = false;
    public static boolean debugCharArray = false;
    public static boolean debugConvertData = false;
    public static boolean debugConstruct = false;
    public static boolean debugTime = false;
    public static boolean showNCfile = false;
    public static boolean debugAttributes = false;
    public static boolean debugCached = false;
    private static boolean accept_compress = false;
    private static boolean preload = true;
    private static boolean useGroups = false;
    private static Logger logger = LoggerFactory.getLogger(DODSNetcdfFile.class);
    private ConvertD2N convertD2N = new ConvertD2N();
    private DConnect2 dodsConnection = null;
    private DDS dds;
    private DAS das;

    public static void setAllowSessions(boolean b) {
        DConnect2.setAllowSessions((boolean)b);
    }

    public static void setAllowDeflate(boolean b) {
        accept_compress = b;
    }

    public static void setAllowCompression(boolean b) {
        accept_compress = b;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugCE = debugFlag.isSet("DODS/constraintExpression");
        debugServerCall = debugFlag.isSet("DODS/serverCall");
        debugOpenResult = debugFlag.isSet("DODS/debugOpenResult");
        debugDataResult = debugFlag.isSet("DODS/debugDataResult");
        debugCharArray = debugFlag.isSet("DODS/charArray");
        debugConstruct = debugFlag.isSet("DODS/constructNetcdf");
        debugTime = debugFlag.isSet("DODS/timeCalls");
        showNCfile = debugFlag.isSet("DODS/showNCfile");
        debugAttributes = debugFlag.isSet("DODS/attributes");
        debugCached = debugFlag.isSet("DODS/cache");
    }

    static void setPreload(boolean b) {
        preload = b;
    }

    public static String canonicalURL(String urlName) {
        if (urlName.startsWith("http:")) {
            return "dods:" + urlName.substring(5);
        }
        return urlName;
    }

    public DODSNetcdfFile(String datasetURL) throws IOException {
        this(datasetURL, null);
    }

    public DODSNetcdfFile(String datasetURL, CancelTask cancelTask) throws IOException {
        String urlName = datasetURL;
        this.location = datasetURL;
        if (datasetURL.startsWith("dods:")) {
            urlName = "http:" + datasetURL.substring(5);
        } else if (datasetURL.startsWith("http:")) {
            this.location = "dods:" + datasetURL.substring(5);
        } else {
            throw new MalformedURLException(datasetURL + " must start with dods: or http:");
        }
        if (debugServerCall) {
            System.out.println("DConnect to = <" + urlName + ">");
        }
        this.dodsConnection = new DConnect2(urlName, accept_compress);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        try {
            this.dds = this.dodsConnection.getDDS();
            if (debugServerCall) {
                System.out.println("DODSNetcdfFile readDDS");
            }
            if (debugOpenResult) {
                System.out.println("DDS = ");
                this.dds.print((OutputStream)System.out);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return;
            }
            this.das = this.dodsConnection.getDAS();
            if (debugServerCall) {
                System.out.println("DODSNetcdfFile readDAS");
            }
            if (debugOpenResult) {
                System.out.println("DAS = ");
                this.das.print((OutputStream)System.out);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return;
            }
            if (debugOpenResult) {
                System.out.println("dodsVersion = " + this.dodsConnection.getServerVersion());
            }
        }
        catch (ParseException e) {
            logger.info("DODSNetcdfFile " + datasetURL, e);
            throw new IOException(e.getMessage());
        }
        catch (DAP2Exception dodsE) {
            if (dodsE.getErrorCode() == 1) {
                throw new FileNotFoundException(dodsE.getMessage());
            }
            throw new IOException(dodsE.getMessage());
        }
        catch (Exception e) {
            logger.info("DODSNetcdfFile " + datasetURL, e);
            throw new IOException(e.getMessage());
        }
        DodsV rootDodsV = DodsV.parseDDS(this.dds);
        rootDodsV.parseDAS(this.das);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.constructTopVariables(rootDodsV, cancelTask);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.constructConstructors(rootDodsV, cancelTask);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.finish();
        this.parseGlobalAttributes(this.das, rootDodsV);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        int pos = urlName.indexOf(63);
        if (0 <= pos) {
            String datasetName = urlName.substring(0, pos);
            if (debugServerCall) {
                System.out.println(" reconnect to = <" + datasetName + ">");
            }
            this.dodsConnection = new DConnect2(datasetName, accept_compress);
            String CE = urlName.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(CE, " ,");
            while (stoke.hasMoreTokens()) {
                String proj = stoke.nextToken();
                int subsetPos = proj.indexOf(91);
                if (debugCE) {
                    System.out.println(" CE = " + proj + " " + subsetPos);
                }
                if (subsetPos <= 0) continue;
                String vname = proj.substring(0, subsetPos);
                String vCE = proj.substring(subsetPos);
                if (debugCE) {
                    System.out.println(" vCE = <" + vname + "><" + vCE + ">");
                }
                DODSVariable dodsVar = (DODSVariable)this.findVariable(vname);
                dodsVar.setCE(vCE);
                dodsVar.setCaching(true);
            }
        }
        if (preload) {
            ArrayList<Variable> preloadList = new ArrayList<Variable>();
            for (Variable dodsVar : this.variables) {
                if (!dodsVar.isCoordinateVariable() && !dodsVar.isCaching() && dodsVar.getDataType() != DataType.STRING) continue;
                dodsVar.setCaching(true);
                preloadList.add(dodsVar);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return;
            }
            this.readArrays(preloadList);
        }
        this.finish();
        if (showNCfile) {
            System.out.println("DODS nc file = " + this);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.getCacheState() == 1) {
            NetcdfFileCache.release(this);
        } else {
            this.isClosed = true;
        }
    }

    private void parseGlobalAttributes(DAS das, DodsV root) {
        List<DODSAttribute> atts = root.attributes;
        for (DODSAttribute ncatt : atts) {
            this.rootGroup.addAttribute(ncatt);
        }
        Enumeration tableNames = das.getNames();
        while (tableNames.hasMoreElements()) {
            DODSAttribute ncatt;
            opendap.dap.Attribute att;
            String attName;
            Enumeration attNames;
            String tableName = (String)tableNames.nextElement();
            AttributeTable attTable = das.getAttributeTableN(tableName);
            if (tableName.equals("DODS_EXTRA")) {
                attNames = attTable.getNames();
                while (attNames.hasMoreElements()) {
                    attName = (String)attNames.nextElement();
                    if (attName.equals("Unlimited_Dimension")) {
                        att = attTable.getAttribute(attName);
                        ncatt = new DODSAttribute(attName, att);
                        this.setUnlimited(ncatt.getStringValue());
                        continue;
                    }
                    logger.warn(" Unknown DODS_EXTRA attribute = " + attName + " " + this.location);
                }
                continue;
            }
            if (!tableName.equals("EXTRA_DIMENSION")) continue;
            attNames = attTable.getNames();
            while (attNames.hasMoreElements()) {
                attName = (String)attNames.nextElement();
                att = attTable.getAttribute(attName);
                ncatt = new DODSAttribute(attName, att);
                int length = ncatt.getNumericValue().intValue();
                Dimension extraDim = new Dimension(attName, length);
                this.addDimension(null, extraDim);
            }
        }
    }

    private void constructTopVariables(DodsV rootDodsV, CancelTask cancelTask) throws IOException {
        List<DodsV> topVariables = rootDodsV.children;
        for (DodsV dodsV : topVariables) {
            if (dodsV.bt instanceof DConstructor) continue;
            this.addVariable(this.rootGroup, null, dodsV);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    private void constructConstructors(DodsV rootDodsV, CancelTask cancelTask) throws IOException {
        List<DodsV> topVariables = rootDodsV.children;
        for (DodsV dodsV : topVariables) {
            if (dodsV.isDone) continue;
            this.addVariable(this.rootGroup, null, dodsV);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    Variable addVariable(Group parentGroup, Structure parentStructure, DodsV dodsV) throws IOException {
        Variable v = this.makeVariable(parentGroup, parentStructure, dodsV);
        if (v != null) {
            this.addAttributes(v, dodsV);
            if (parentStructure == null) {
                parentGroup.addVariable(v);
            } else {
                parentStructure.addMemberVariable(v);
            }
            dodsV.isDone = true;
        }
        return v;
    }

    private Variable makeVariable(Group parentGroup, Structure parentStructure, DodsV dodsV) throws IOException {
        BaseType dodsBT = dodsV.bt;
        String dodsShortName = dodsBT.getName();
        if (debugConstruct) {
            System.out.print("DODSNetcdf makeVariable try to init <" + dodsShortName + "> :");
        }
        if (dodsBT instanceof DString) {
            if (dodsV.darray == null) {
                if (debugConstruct) {
                    System.out.println("  assigned to DString: name = " + dodsShortName);
                }
                return new DODSVariable(this, parentGroup, parentStructure, dodsShortName, dodsBT, dodsV);
            }
            if (debugConstruct) {
                System.out.println("  assigned to Array of Strings: name = " + dodsShortName);
            }
            return new DODSVariable(this, parentGroup, parentStructure, dodsShortName, dodsV.darray, dodsBT, dodsV);
        }
        if (dodsBT instanceof DByte || dodsBT instanceof DFloat32 || dodsBT instanceof DFloat64 || dodsBT instanceof DInt16 || dodsBT instanceof DInt32 || dodsBT instanceof DUInt16 || dodsBT instanceof DUInt32) {
            if (dodsV.darray == null) {
                if (debugConstruct) {
                    System.out.println("  assigned to scalar " + dodsBT.getTypeName() + ": name = " + dodsShortName);
                }
                return new DODSVariable(this, parentGroup, parentStructure, dodsShortName, dodsBT, dodsV);
            }
            if (debugConstruct) {
                System.out.println("  assigned to array of type " + dodsBT.getClass().getName() + ": name = " + dodsShortName);
            }
            return new DODSVariable(this, parentGroup, parentStructure, dodsShortName, dodsV.darray, dodsBT, dodsV);
        }
        if (dodsBT instanceof DGrid) {
            if (dodsV.darray == null) {
                if (debugConstruct) {
                    System.out.println(" assigned to DGrid <" + dodsShortName + ">");
                }
                for (int i = 1; i < dodsV.children.size(); ++i) {
                    DodsV map = dodsV.children.get(i);
                    String shortName = DODSNetcdfFile.makeNetcdfName(map.bt.getName());
                    Variable mapV = parentGroup.findVariable(shortName);
                    if (mapV != null) continue;
                    mapV = this.addVariable(parentGroup, parentStructure, map);
                    this.makeCoordinateVariable(parentGroup, mapV, map.data);
                }
                return new DODSGrid(this, parentGroup, parentStructure, dodsShortName, dodsV);
            }
            if (debugConstruct) {
                System.out.println(" ERROR! array of DGrid <" + dodsShortName + ">");
            }
            return null;
        }
        if (dodsBT instanceof DSequence) {
            if (dodsV.darray == null) {
                if (debugConstruct) {
                    System.out.println(" assigned to DSequence <" + dodsShortName + ">");
                }
                return new DODSStructure(this, parentGroup, parentStructure, dodsShortName, dodsV);
            }
            if (debugConstruct) {
                System.out.println(" ERROR! array of DSequence <" + dodsShortName + ">");
            }
            return null;
        }
        if (dodsBT instanceof DStructure) {
            DStructure dstruct = (DStructure)dodsBT;
            if (dodsV.darray == null) {
                if (useGroups && parentStructure == null && this.isGroup(dstruct)) {
                    if (debugConstruct) {
                        System.out.println(" assigned to Group <" + dodsShortName + ">");
                    }
                    Group g = new Group(this, parentGroup, DODSNetcdfFile.makeNetcdfName(dodsShortName));
                    this.addAttributes(g, dodsV);
                    parentGroup.addGroup(g);
                    for (DodsV nested : dodsV.children) {
                        this.addVariable(g, null, nested);
                    }
                    return null;
                }
                if (debugConstruct) {
                    System.out.println(" assigned to DStructure <" + dodsShortName + ">");
                }
                return new DODSStructure(this, parentGroup, parentStructure, dodsShortName, dodsV);
            }
            if (debugConstruct) {
                System.out.println(" assigned to Array of DStructure <" + dodsShortName + "> ");
            }
            return new DODSStructure(this, parentGroup, parentStructure, dodsShortName, dodsV.darray, dodsV);
        }
        logger.warn("DODSNetcdf " + this.location + " didnt process basetype <" + dodsBT.getTypeName() + "> variable = " + dodsShortName);
        return null;
    }

    private void makeCoordinateVariable(Group parentGroup, Variable v, Array data) {
        String name = v.getShortName();
        Dimension oldDimension = v.getDimension(0);
        Dimension newDimension = new Dimension(name, oldDimension.getLength());
        v.setDimension(0, newDimension);
        Dimension old = parentGroup.findDimension(name);
        parentGroup.remove(old);
        parentGroup.addDimension(newDimension);
        if (data != null) {
            v.setCachedData(data, false);
            if (debugCached) {
                System.out.println(" cache for <" + name + "> length =" + data.getSize());
            }
        }
    }

    private boolean isGroup(DStructure dstruct) {
        BaseType parent = dstruct.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof DStructure) {
            return this.isGroup((DStructure)parent);
        }
        return true;
    }

    private void addAttributes(Variable v, DodsV dodsV) {
        List<DODSAttribute> atts = dodsV.attributes;
        for (DODSAttribute ncatt : atts) {
            v.addAttribute(ncatt);
        }
        Attribute axes = v.findAttribute("coordinates");
        Attribute _axes = v.findAttribute("_CoordinateAxes");
        if (null != axes && null != _axes) {
            v.addAttribute(new Attribute("_CoordinateAxes", axes.getStringValue() + " " + _axes.getStringValue()));
        }
    }

    private void addAttributes(Group g, DodsV dodsV) {
        List<DODSAttribute> atts = dodsV.attributes;
        for (DODSAttribute ncatt : atts) {
            g.addAttribute(ncatt);
        }
    }

    Dimension getNetcdfStrlenDim(DODSVariable v) {
        int dimLength;
        String dimName;
        AttributeTable table = this.das.getAttributeTableN(v.getName());
        if (table == null) {
            return null;
        }
        opendap.dap.Attribute dodsAtt = table.getAttribute("DODS");
        if (dodsAtt == null) {
            return null;
        }
        AttributeTable dodsTable = dodsAtt.getContainerN();
        if (dodsTable == null) {
            return null;
        }
        opendap.dap.Attribute att = dodsTable.getAttribute("strlen");
        if (att == null) {
            return null;
        }
        String strlen = att.getValueAtN(0);
        opendap.dap.Attribute att2 = dodsTable.getAttribute("dimName");
        String string = dimName = att2 == null ? null : att2.getValueAtN(0);
        if (debugCharArray) {
            System.out.println(v.getName() + " has strlen= " + strlen + " dimName= " + dimName);
        }
        try {
            dimLength = Integer.parseInt(strlen);
        }
        catch (NumberFormatException e) {
            logger.warn("DODSNetcdfFile " + this.location + " var = " + v.getName() + " error on strlen attribute = " + strlen);
            return null;
        }
        if (dimLength <= 0) {
            return null;
        }
        return new Dimension(dimName, dimLength, dimName != null);
    }

    Dimension getSharedDimension(Group group, Dimension d) {
        if (d.getName() == null) {
            return d;
        }
        if (group == null) {
            group = this.rootGroup;
        }
        for (Dimension sd : group.getDimensions()) {
            if (!sd.getName().equals(d.getName()) || sd.getLength() != d.getLength()) continue;
            return sd;
        }
        d.setShared(true);
        group.addDimension(d);
        return d;
    }

    List<Dimension> constructDimensions(Group group, DArray dodsArray) {
        if (group == null) {
            group = this.rootGroup;
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Enumeration enumerate = dodsArray.getDimensions();
        while (enumerate.hasMoreElements()) {
            Dimension myd;
            DArrayDimension dad = (DArrayDimension)enumerate.nextElement();
            String name = dad.getName();
            if (name != null) {
                name = StringUtil.unescape(dad.getName());
            }
            if (name == null) {
                myd = new Dimension("", dad.getSize(), false);
            } else {
                myd = group.findDimension(name);
                if (myd == null) {
                    myd = new Dimension(name, dad.getSize());
                    group.addDimension(myd);
                } else if (myd.getLength() != dad.getSize()) {
                    myd = new Dimension(name, dad.getSize(), false);
                }
            }
            dims.add(myd);
        }
        return dims;
    }

    private void setUnlimited(String dimName) {
        Dimension dim = this.rootGroup.findDimension(dimName);
        if (dim != null) {
            dim.setUnlimited(true);
        } else {
            logger.error(" DODS Unlimited_Dimension = " + dimName + " not found on " + this.location);
        }
    }

    protected int[] makeShape(DArray dodsArray) {
        int count = 0;
        Enumeration enumerate = dodsArray.getDimensions();
        while (enumerate.hasMoreElements()) {
            ++count;
            enumerate.nextElement();
        }
        int[] shape = new int[count];
        enumerate = dodsArray.getDimensions();
        count = 0;
        while (enumerate.hasMoreElements()) {
            DArrayDimension dad = (DArrayDimension)enumerate.nextElement();
            shape[count++] = dad.getSize();
        }
        return shape;
    }

    public static String getDODSshortName(Variable var) {
        if (var instanceof DODSVariable) {
            return ((DODSVariable)var).getDODSshortName();
        }
        if (var instanceof DODSStructure) {
            return ((DODSStructure)var).getDODSshortName();
        }
        return null;
    }

    private String makeDODSname(DodsV dodsV) {
        DodsV parent = dodsV.parent;
        if (parent.bt != null) {
            return this.makeDODSname(parent) + "." + dodsV.bt.getName();
        }
        return dodsV.bt.getName();
    }

    static String makeNetcdfName(String name) {
        return NetcdfFile.createValidNetcdfObjectName(StringUtil.unescape(name));
    }

    public static int convertToDODSType(DataType dataType, boolean isUnsigned) {
        if (dataType == DataType.STRING) {
            return 10;
        }
        if (dataType == DataType.BYTE) {
            return 3;
        }
        if (dataType == DataType.FLOAT) {
            return 8;
        }
        if (dataType == DataType.DOUBLE) {
            return 9;
        }
        if (dataType == DataType.SHORT) {
            return isUnsigned ? 5 : 4;
        }
        if (dataType == DataType.INT) {
            return isUnsigned ? 7 : 6;
        }
        if (dataType == DataType.BOOLEAN) {
            return 3;
        }
        if (dataType == DataType.LONG) {
            return 6;
        }
        return 10;
    }

    public static DataType convertToNCType(int dodsDataType) {
        switch (dodsDataType) {
            case 3: {
                return DataType.BYTE;
            }
            case 8: {
                return DataType.FLOAT;
            }
            case 9: {
                return DataType.DOUBLE;
            }
            case 4: {
                return DataType.SHORT;
            }
            case 5: {
                return DataType.SHORT;
            }
            case 6: {
                return DataType.INT;
            }
            case 7: {
                return DataType.INT;
            }
        }
        return DataType.STRING;
    }

    public static boolean isUnsigned(int dodsDataType) {
        return dodsDataType == 3 || dodsDataType == 5 || dodsDataType == 7;
    }

    public static DataType convertToNCType(BaseType dtype) {
        if (dtype instanceof DString) {
            return DataType.STRING;
        }
        if (dtype instanceof DStructure || dtype instanceof DSequence || dtype instanceof DGrid) {
            return DataType.STRUCTURE;
        }
        if (dtype instanceof DFloat32) {
            return DataType.FLOAT;
        }
        if (dtype instanceof DFloat64) {
            return DataType.DOUBLE;
        }
        if (dtype instanceof DUInt32) {
            return DataType.INT;
        }
        if (dtype instanceof DUInt16) {
            return DataType.SHORT;
        }
        if (dtype instanceof DInt32) {
            return DataType.INT;
        }
        if (dtype instanceof DInt16) {
            return DataType.SHORT;
        }
        if (dtype instanceof DByte) {
            return DataType.BYTE;
        }
        throw new IllegalArgumentException("DODSVariable illegal type = " + dtype.getTypeName());
    }

    public static boolean isUnsigned(BaseType dtype) {
        return dtype instanceof DByte || dtype instanceof DUInt16 || dtype instanceof DUInt32;
    }

    DataDDS readDataDDSfromServer(String CE) throws IOException, ParseException, DAP2Exception {
        if (debugServerCall) {
            System.out.println("DODSNetcdfFile.readDataDDSfromServer = <" + CE + ">");
        }
        long start = 0L;
        if (debugTime) {
            start = System.currentTimeMillis();
        }
        if (!CE.startsWith("?")) {
            CE = "?" + CE;
        }
        DataDDS data = this.dodsConnection.getData(CE, null);
        if (debugTime) {
            System.out.println("DODSNetcdfFile.readDataDDSfromServer took = " + (double)(System.currentTimeMillis() - start) / 1000.0);
        }
        if (debugDataResult) {
            System.out.println(" dataDDS return:");
            data.print((OutputStream)System.out);
        }
        return data;
    }

    @Override
    public List<Array> readArrays(List<Variable> preloadVariables) throws IOException {
        if (preloadVariables.size() == 0) {
            return new ArrayList<Array>();
        }
        ArrayList<DodsV> reqDodsVlist = new ArrayList<DodsV>();
        for (Variable var : preloadVariables) {
            if (var.hasCachedData()) continue;
            reqDodsVlist.add((DodsV)var.getSPobject());
        }
        Collections.sort(reqDodsVlist);
        HashMap<DodsV, DodsV> map = new HashMap<DodsV, DodsV>(2 * reqDodsVlist.size() + 1);
        if (reqDodsVlist.size() > 0) {
            DodsV root;
            StringBuffer requestString = new StringBuffer();
            for (int i = 0; i < reqDodsVlist.size(); ++i) {
                DodsV dodsV = (DodsV)reqDodsVlist.get(i);
                requestString.append(i == 0 ? "?" : ",");
                requestString.append(this.makeDODSname(dodsV));
            }
            try {
                DataDDS dataDDS = this.readDataDDSfromServer(requestString.toString());
                root = DodsV.parseDataDDS(dataDDS);
            }
            catch (Exception exc) {
                logger.error("ERROR readDataDDSfromServer on " + requestString, exc);
                throw new IOException(exc.getMessage());
            }
            for (DodsV ddsV : reqDodsVlist) {
                DodsV dataV = root.findDataV(ddsV);
                if (dataV != null) {
                    if (debugConvertData) {
                        System.out.println("readArray found dataV= " + this.makeDODSname(ddsV));
                    }
                    dataV.isDone = true;
                    map.put(ddsV, dataV);
                    continue;
                }
                logger.error("ERROR findDataV cant find " + this.makeDODSname(ddsV) + " on " + this.location);
            }
        }
        ArrayList<Array> result = new ArrayList<Array>();
        for (Variable var : preloadVariables) {
            if (var.hasCachedData()) {
                result.add(var.read());
                continue;
            }
            Array data = null;
            DodsV ddsV = (DodsV)var.getSPobject();
            DodsV dataV = (DodsV)map.get(ddsV);
            if (dataV == null) {
                logger.error("DODSNetcdfFile.readArrays cant find " + this.makeDODSname(ddsV) + " in dataDDS; " + this.location);
            } else {
                if (debugConvertData) {
                    System.out.println("readArray converting " + this.makeDODSname(ddsV));
                }
                dataV.isDone = true;
                try {
                    if (var.isMemberOfStructure()) {
                        while (dataV.parent != null && dataV.parent.bt != null) {
                            dataV = dataV.parent;
                        }
                        data = this.convertD2N.convertNestedVariable(var, null, dataV, true);
                    } else {
                        data = this.convertD2N.convertTopVariable(var, null, dataV);
                    }
                }
                catch (DAP2Exception de) {
                    logger.error("ERROR convertVariable on " + var.getName(), de);
                    throw new IOException(de.getMessage());
                }
                if (var.isCaching()) {
                    var.setCachedData(data, false);
                    if (debugCached) {
                        System.out.println(" cache for <" + var.getName() + "> length =" + data.getSize());
                    }
                }
            }
            result.add(data);
        }
        return result;
    }

    @Override
    protected Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        Array dataArray;
        StringBuffer buff = new StringBuffer(100);
        buff.setLength(0);
        buff.append(DODSNetcdfFile.getDODSshortName(v));
        if (!v.isVariableLength()) {
            int n;
            List<Range> dodsSection = section.getRanges();
            if (v.getDataType() == DataType.CHAR && (n = section.getRank()) == v.getRank()) {
                dodsSection = dodsSection.subList(0, n - 1);
            }
            this.makeSelector(buff, dodsSection);
        }
        try {
            DataDDS dataDDS = this.readDataDDSfromServer(buff.toString());
            DodsV root = DodsV.parseDataDDS(dataDDS);
            DodsV want = root.children.get(0);
            dataArray = this.convertD2N.convertTopVariable(v, section.getRanges(), want);
        }
        catch (DAP2Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        return dataArray;
    }

    @Override
    protected Array readMemberData(Variable v, Section section, boolean flatten) throws IOException, InvalidRangeException {
        Array dataArray;
        StringBuffer buff = new StringBuffer(100);
        buff.setLength(0);
        List<Range> ranges = section.getRanges();
        this.addParents(buff, v, ranges, 0);
        try {
            DataDDS dataDDS = this.readDataDDSfromServer(buff.toString());
            DodsV root = DodsV.parseDataDDS(dataDDS);
            DodsV want = root.children.get(0);
            dataArray = this.convertD2N.convertNestedVariable(v, ranges, want, flatten);
        }
        catch (DAP2Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        return dataArray;
    }

    public Array readWithCE(Variable v, String CE) throws IOException {
        Array dataArray;
        try {
            DataDDS dataDDS = this.readDataDDSfromServer(CE);
            DodsV root = DodsV.parseDataDDS(dataDDS);
            DodsV want = root.children.get(0);
            dataArray = v.isMemberOfStructure() ? this.convertD2N.convertNestedVariable(v, null, want, true) : this.convertD2N.convertTopVariable(v, null, want);
        }
        catch (DAP2Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        return dataArray;
    }

    private int addParents(StringBuffer buff, Variable s, List<Range> section, int start) {
        Structure parent = s.getParentStructure();
        if (parent != null) {
            start = this.addParents(buff, parent, section, start);
            buff.append(".");
        }
        List<Range> subSection = section.subList(start, start + s.getRank());
        buff.append(DODSNetcdfFile.getDODSshortName(s));
        if (!s.isVariableLength()) {
            this.makeSelector(buff, subSection);
        }
        return start + s.getRank();
    }

    private void makeSelector(StringBuffer buff, List<Range> section) {
        for (Range r : section) {
            buff.append("[");
            buff.append(r.first());
            buff.append(':');
            buff.append(r.stride());
            buff.append(':');
            buff.append(r.last());
            buff.append("]");
        }
    }

    public String toStringDebug() {
        StringBuffer buff = new StringBuffer(2000);
        buff.setLength(0);
        buff.append("=======================================\nNETCDF DODS file ").append(this.getLocation()).append("\n");
        buff.append("DDS = \n");
        ByteArrayOutputStream buffOS = new ByteArrayOutputStream(8000);
        this.dds.print((OutputStream)buffOS);
        buff.append(buffOS.toString());
        buff.append("===================\nDAS = \n");
        buffOS = new ByteArrayOutputStream(8000);
        this.das.print((OutputStream)buffOS);
        buff.append(buffOS.toString());
        buff.append("===================\n");
        return buff.toString();
    }

    public static void main(String[] arg) {
        String url = "http://localhost:8080/thredds/dodsC/testContent/testData.nc.ascii?reftime[0:1:0]";
        try {
            DODSNetcdfFile df = new DODSNetcdfFile(url, null);
            System.out.println("dods file = " + url + "\n" + df);
        }
        catch (Exception ioe) {
            System.out.println("error = " + url);
            ioe.printStackTrace();
        }
    }
}

