/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ucar.ma2.Array;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.unidata.geoloc.LatLonPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridAsPointDataset {
    private List<GridDatatype> grids;
    private List<Date> dates;

    public GridAsPointDataset(List<GridDatatype> grids) {
        this.grids = grids;
        HashSet<Date> dateHash = new HashSet<Date>();
        ArrayList<CoordinateAxis1DTime> timeAxes = new ArrayList<CoordinateAxis1DTime>();
        for (GridDatatype grid : grids) {
            Date[] timeDates;
            GridCoordSystem gcs = grid.getCoordinateSystem();
            CoordinateAxis1DTime timeAxis = gcs.getTimeAxis1D();
            if (timeAxis == null || timeAxes.contains(timeAxis)) continue;
            timeAxes.add(timeAxis);
            for (Date timeDate : timeDates = timeAxis.getTimeDates()) {
                dateHash.add(timeDate);
            }
        }
        this.dates = Arrays.asList(dateHash.toArray(new Date[dateHash.size()]));
        Collections.sort(this.dates);
    }

    public List<Date> getDates() {
        return this.dates;
    }

    public boolean hasTime(GridDatatype grid, Date date) {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1DTime timeAxis = gcs.getTimeAxis1D();
        return timeAxis != null && timeAxis.hasTime(date);
    }

    public double getMissingValue(GridDatatype grid) {
        return Double.NaN;
    }

    public Point readData(GridDatatype grid, Date date, double lat, double lon) throws IOException {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1DTime timeAxis = gcs.getTimeAxis1D();
        int tidx = timeAxis.findTimeIndexFromDate(date);
        int[] xy = gcs.findXYindexFromLatLon(lat, lon, null);
        Array data = grid.readDataSlice(tidx, -1, xy[1], xy[0]);
        LatLonPoint latlon = gcs.getLatLon(xy[0], xy[1]);
        Point p = new Point();
        p.lat = latlon.getLatitude();
        p.lon = latlon.getLongitude();
        p.dataValue = data.getDouble(data.getIndex());
        return p;
    }

    public boolean hasVert(GridDatatype grid, double zCoord) {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1D zAxis = gcs.getVerticalAxis();
        if (zAxis == null) {
            return false;
        }
        return zAxis.findCoordElement(zCoord) >= 0;
    }

    public Point readData(GridDatatype grid, Date date, double zCoord, double lat, double lon) throws IOException {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1DTime timeAxis = gcs.getTimeAxis1D();
        int tidx = timeAxis.findTimeIndexFromDate(date);
        CoordinateAxis1D zAxis = gcs.getVerticalAxis();
        int zidx = zAxis.findCoordElement(zCoord);
        int[] xy = gcs.findXYindexFromLatLon(lat, lon, null);
        Array data = grid.readDataSlice(tidx, zidx, xy[1], xy[0]);
        LatLonPoint latlon = gcs.getLatLon(xy[0], xy[1]);
        Point p = new Point();
        p.lat = latlon.getLatitude();
        p.lon = latlon.getLongitude();
        p.z = zAxis.getCoordValue(zidx);
        p.dataValue = data.getDouble(data.getIndex());
        return p;
    }

    public class Point {
        public double lat;
        public double lon;
        public double z;
        public double dataValue;
    }
}

