/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataType;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.HDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5ObjectReadOnlyInfoProviderHandler;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import java.util.List;

class HDF5ObjectReadOnlyInfoProviderHandler
implements IHDF5ObjectReadOnlyInfoProviderHandler {
    private final HDF5BaseReader baseReader;

    HDF5ObjectReadOnlyInfoProviderHandler(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public HDF5LinkInformation getLinkInformation(String objectPath) {
        this.baseReader.checkOpen();
        return this.baseReader.h5.getLinkInfo(this.baseReader.fileId, objectPath, false);
    }

    @Override
    public HDF5ObjectInformation getObjectInformation(String objectPath) {
        this.baseReader.checkOpen();
        return this.baseReader.h5.getObjectInfo(this.baseReader.fileId, objectPath, false);
    }

    @Override
    public HDF5ObjectType getObjectType(String objectPath, boolean followLink) {
        this.baseReader.checkOpen();
        if (followLink) {
            return this.baseReader.h5.getObjectTypeInfo(this.baseReader.fileId, objectPath, false);
        }
        return this.baseReader.h5.getLinkTypeInfo(this.baseReader.fileId, objectPath, false);
    }

    @Override
    public HDF5ObjectType getObjectType(String objectPath) {
        return this.getObjectType(objectPath, true);
    }

    @Override
    public boolean exists(String objectPath, boolean followLink) {
        if (!followLink) {
            this.baseReader.checkOpen();
            if ("/".equals(objectPath)) {
                return true;
            }
            return this.baseReader.h5.exists(this.baseReader.fileId, objectPath);
        }
        return this.exists(objectPath);
    }

    @Override
    public boolean exists(String objectPath) {
        this.baseReader.checkOpen();
        if ("/".equals(objectPath)) {
            return true;
        }
        return this.baseReader.h5.getObjectTypeId(this.baseReader.fileId, objectPath, false) >= 0;
    }

    @Override
    public String toHouseKeepingPath(String objectPath) {
        return HDF5Utils.toHouseKeepingPath(objectPath, this.baseReader.houseKeepingNameSuffix);
    }

    @Override
    public boolean isHouseKeepingObject(String objectPath) {
        return HDF5Utils.isInternalName(objectPath, this.baseReader.houseKeepingNameSuffix);
    }

    @Override
    public boolean isGroup(String objectPath, boolean followLink) {
        return HDF5ObjectType.isGroup(this.getObjectType(objectPath, followLink));
    }

    @Override
    public boolean isGroup(String objectPath) {
        return HDF5ObjectType.isGroup(this.getObjectType(objectPath));
    }

    @Override
    public boolean isDataSet(String objectPath, boolean followLink) {
        return HDF5ObjectType.isDataSet(this.getObjectType(objectPath, followLink));
    }

    @Override
    public boolean isDataSet(String objectPath) {
        return HDF5ObjectType.isDataSet(this.getObjectType(objectPath));
    }

    @Override
    public boolean isDataType(String objectPath, boolean followLink) {
        return HDF5ObjectType.isDataType(this.getObjectType(objectPath, followLink));
    }

    @Override
    public boolean isDataType(String objectPath) {
        return HDF5ObjectType.isDataType(this.getObjectType(objectPath));
    }

    @Override
    public boolean isSoftLink(String objectPath) {
        return HDF5ObjectType.isSoftLink(this.getObjectType(objectPath, false));
    }

    @Override
    public boolean isExternalLink(String objectPath) {
        return HDF5ObjectType.isExternalLink(this.getObjectType(objectPath, false));
    }

    @Override
    public boolean isSymbolicLink(String objectPath) {
        return HDF5ObjectType.isSymbolicLink(this.getObjectType(objectPath, false));
    }

    @Override
    public String tryGetSymbolicLinkTarget(String objectPath) {
        return this.getLinkInformation(objectPath).tryGetSymbolicLinkTarget();
    }

    @Override
    public String tryGetDataTypePath(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> dataTypeNameCallable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.openDataSet(((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                return HDF5ObjectReadOnlyInfoProviderHandler.this.baseReader.tryGetDataTypePath(dataTypeId);
            }
        };
        return this.baseReader.runner.call(dataTypeNameCallable);
    }

    @Override
    public String tryGetDataTypePath(HDF5DataType type) {
        assert (type != null);
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        return this.baseReader.tryGetDataTypePath(type.getStorageTypeId());
    }

    @Override
    public List<String> getAttributeNames(String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        return HDF5Utils.removeInternalNames(this.getAllAttributeNames(objectPath), this.baseReader.houseKeepingNameSuffix, "/".equals(objectPath));
    }

    @Override
    public List<String> getAllAttributeNames(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<List<String>> attributeNameReaderRunnable = new ICallableWithCleanUp<List<String>>(){

            @Override
            public List<String> call(ICleanUpRegistry registry) {
                int objectId = ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.openObject(((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.fileId, objectPath, registry);
                return ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.getAttributeNames(objectId, registry);
            }
        };
        return this.baseReader.runner.call(attributeNameReaderRunnable);
    }

    @Override
    public HDF5DataTypeInformation getAttributeInformation(String dataSetPath, String attributeName) {
        return this.getAttributeInformation(dataSetPath, attributeName, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public HDF5DataTypeInformation getAttributeInformation(final String dataSetPath, final String attributeName, final HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        assert (dataSetPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5DataTypeInformation> informationDeterminationRunnable = new ICallableWithCleanUp<HDF5DataTypeInformation>(){

            @Override
            public HDF5DataTypeInformation call(ICleanUpRegistry registry) {
                int[] dimensions;
                int objectId = ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.openObject(((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.fileId, dataSetPath, registry);
                int attributeId = ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int dataTypeId = ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                HDF5DataTypeInformation dataTypeInformation = HDF5ObjectReadOnlyInfoProviderHandler.this.baseReader.getDataTypeInformation(dataTypeId, dataTypeInfoOptions, registry);
                if (!dataTypeInformation.isArrayType() && (dimensions = MDAbstractArray.toInt((long[])((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry))).length > 0) {
                    dataTypeInformation.setDimensions(dimensions);
                }
                return dataTypeInformation;
            }
        };
        return this.baseReader.runner.call(informationDeterminationRunnable);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath) {
        return this.getDataSetInformation(dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        assert (dataSetPath != null);
        this.baseReader.checkOpen();
        return this.baseReader.getDataSetInformation(dataSetPath, dataTypeInfoOptions);
    }

    @Override
    public long getSize(String objectPath) {
        return this.getDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL).getSize();
    }

    @Override
    public long getNumberOfElements(String objectPath) {
        return this.getDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL).getNumberOfElements();
    }

    @Override
    public void copy(String sourceObject, IHDF5Writer destinationWriter, String destinationObject) {
        this.baseReader.checkOpen();
        HDF5Writer dwriter = (HDF5Writer)destinationWriter;
        if (dwriter.object() != this) {
            dwriter.checkOpen();
        }
        this.baseReader.copyObject(sourceObject, dwriter.getFileId(), destinationObject);
    }

    @Override
    public void copy(String sourceObject, IHDF5Writer destinationWriter) {
        this.copy(sourceObject, destinationWriter, "/");
    }

    @Override
    public void copyAll(IHDF5Writer destinationWriter) {
        this.copy("/", destinationWriter, "/");
    }

    @Override
    public List<String> getGroupMembers(String groupPath) {
        assert (groupPath != null);
        this.baseReader.checkOpen();
        return this.baseReader.getGroupMembers(groupPath);
    }

    @Override
    public List<String> getAllGroupMembers(String groupPath) {
        assert (groupPath != null);
        this.baseReader.checkOpen();
        return this.baseReader.getAllGroupMembers(groupPath);
    }

    @Override
    public List<String> getGroupMemberPaths(String groupPath) {
        assert (groupPath != null);
        this.baseReader.checkOpen();
        return this.baseReader.getGroupMemberPaths(groupPath);
    }

    @Override
    public List<HDF5LinkInformation> getGroupMemberInformation(String groupPath, boolean readLinkTargets) {
        this.baseReader.checkOpen();
        if (readLinkTargets) {
            return this.baseReader.h5.getGroupMemberLinkInfo(this.baseReader.fileId, groupPath, false, this.baseReader.houseKeepingNameSuffix);
        }
        return this.baseReader.h5.getGroupMemberTypeInfo(this.baseReader.fileId, groupPath, false, this.baseReader.houseKeepingNameSuffix);
    }

    @Override
    public List<HDF5LinkInformation> getAllGroupMemberInformation(String groupPath, boolean readLinkTargets) {
        this.baseReader.checkOpen();
        if (readLinkTargets) {
            return this.baseReader.h5.getGroupMemberLinkInfo(this.baseReader.fileId, groupPath, true, this.baseReader.houseKeepingNameSuffix);
        }
        return this.baseReader.h5.getGroupMemberTypeInfo(this.baseReader.fileId, groupPath, true, this.baseReader.houseKeepingNameSuffix);
    }

    @Override
    public HDF5DataTypeVariant tryGetTypeVariant(String objectPath) {
        this.baseReader.checkOpen();
        return this.baseReader.tryGetTypeVariant(objectPath);
    }

    @Override
    public HDF5DataTypeVariant tryGetTypeVariant(String objectPath, String attributeName) {
        this.baseReader.checkOpen();
        return this.baseReader.tryGetTypeVariant(objectPath, attributeName);
    }

    @Override
    public boolean hasAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Boolean> writeRunnable = new ICallableWithCleanUp<Boolean>(){

            @Override
            public Boolean call(ICleanUpRegistry registry) {
                int objectId = ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.openObject(((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.fileId, objectPath, registry);
                return ((HDF5ObjectReadOnlyInfoProviderHandler)HDF5ObjectReadOnlyInfoProviderHandler.this).baseReader.h5.existsAttribute(objectId, attributeName);
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }
}

