/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CompoundElement;
import ch.systemsx.cisd.hdf5.CompoundType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        CompoundType ct = clazz.getAnnotation(CompoundType.class);
        boolean includeAllFields = ct != null ? ct.mapAllFields() : true;
        Class<?> c = clazz;
        while (c != null) {
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                CompoundElement e = f.getAnnotation(CompoundElement.class);
                if (e != null && StringUtils.isNotEmpty((String)e.memberName())) {
                    map.put(e.memberName(), f);
                } else if (includeAllFields) {
                    map.put(f.getName(), f);
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return map;
    }

    public static void ensureAccessible(AccessibleObject memberOrNull) {
        if (memberOrNull != null && !memberOrNull.isAccessible()) {
            memberOrNull.setAccessible(true);
        }
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
        ReflectionUtils.ensureAccessible(defaultConstructor);
        return defaultConstructor;
    }

    public static <T> T newInstance(Class<T> clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
        ReflectionUtils.ensureAccessible(defaultConstructor);
        return defaultConstructor.newInstance(new Object[0]);
    }

    public static String[] getEnumOptions(Class<? extends Enum<?>> enumClass) {
        Enum<?>[] constants = enumClass.getEnumConstants();
        if (constants == null) {
            return new String[0];
        }
        String[] options = new String[constants.length];
        int i = 0;
        while (i < options.length) {
            options[i] = constants[i].name();
            ++i;
        }
        return options;
    }
}

