/*
 * Decompiled with CFR 0.152.
 */
package eu.basynthec.cisd.client.examples;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import eu.basynthec.cisd.client.examples.AbstractBaSynthecClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSetSearch
extends AbstractBaSynthecClient {
    private static final String STRAIN_NAMES_PROPERTY = "STRAIN_NAMES";
    private static final String STRAINS_HEADER = "Strains";
    private static final String REGISTERED_BY_HEADER = "Contact Person";
    private static final String DATA_SET_HEADER = "Data Set";
    private static final String PATH_HEADER = "Data Path";
    private final File downloadFolder;
    private List<DataSet> matchingDataSets;
    private List<Experiment> experiments;
    private HashMap<String, ArrayList<DataSet>> experimentDataSets;
    private HashMap<DataSet, File> dataSetFiles;

    public DataSetSearch(IOpenbisServiceFacade facade, File downloadFolder) {
        super(facade);
        this.downloadFolder = downloadFolder;
    }

    public void run(List<String> strainNames) {
        this.retrieveInformationFromOpenBis(strainNames);
        this.downloadDataSets();
        this.printHeader();
        for (Experiment experiment : this.experiments) {
            this.printExperiment(experiment);
        }
    }

    private void retrieveInformationFromOpenBis(List<String> strainNames) {
        this.matchingDataSets = this.retrieveDataSetsReferencingStrains(strainNames);
        ArrayList<String> experimentIdentifiers = new ArrayList<String>();
        for (DataSet dataSet : this.matchingDataSets) {
            experimentIdentifiers.add(dataSet.getExperimentIdentifier());
        }
        this.experiments = experimentIdentifiers.isEmpty() ? new ArrayList<Experiment>() : this.openBis.getExperiments(experimentIdentifiers);
        this.experimentDataSets = new HashMap();
        for (DataSet dataSet : this.matchingDataSets) {
            ArrayList<Object> dataSetsForExperiment = this.experimentDataSets.get(dataSet.getExperimentIdentifier());
            if (dataSetsForExperiment == null) {
                dataSetsForExperiment = new ArrayList();
                this.experimentDataSets.put(dataSet.getExperimentIdentifier(), dataSetsForExperiment);
            }
            dataSetsForExperiment.add(dataSet);
        }
    }

    private void downloadDataSets() {
        this.dataSetFiles = new HashMap();
        for (DataSet dataSet : this.matchingDataSets) {
            File location = dataSet.getLinkOrCopyOfContent(null, this.downloadFolder, "original/tsv");
            this.dataSetFiles.put(dataSet, location);
        }
    }

    private List<DataSet> retrieveDataSetsReferencingStrains(List<String> strainNames) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setOperator(SearchCriteria.SearchOperator.MATCH_ANY_CLAUSES);
        for (String strainName : strainNames) {
            searchCriteria.addMatchClause(SearchCriteria.MatchClause.createPropertyMatch((String)STRAIN_NAMES_PROPERTY, (String)strainName));
        }
        return this.openBis.searchForDataSets(searchCriteria);
    }

    private void printHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("Experiment");
        MetadataField[] metadataFieldArray = MetadataField.values();
        int n = metadataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataField field = metadataFieldArray[n2];
            sb.append("\t");
            sb.append(field.headerText);
            ++n2;
        }
        sb.append("\t");
        sb.append(REGISTERED_BY_HEADER);
        sb.append("\t");
        sb.append(DATA_SET_HEADER);
        sb.append("\t");
        sb.append(STRAINS_HEADER);
        sb.append("\t");
        sb.append(PATH_HEADER);
        this.println(sb.toString());
    }

    private void printEmptyExperimentInformationOn(StringBuffer sb) {
        sb.append("\t");
        MetadataField[] metadataFieldArray = MetadataField.values();
        int n = metadataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            sb.append("\t");
            ++n2;
        }
        sb.append("\t");
    }

    private void printExperiment(Experiment experiment) {
        StringBuffer sb = new StringBuffer();
        sb.append(experiment.getIdentifier());
        this.printExperimentPropertiesOn(experiment.getProperties(), sb);
        this.printRegisteredByOn(experiment.getRegistrationDetails(), sb);
        this.printDataSetsOn(experiment, sb);
        this.println(sb.toString());
    }

    private void printExperimentPropertiesOn(Map<String, String> properties, StringBuffer sb) {
        MetadataField[] metadataFieldArray = MetadataField.values();
        int n = metadataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataField field = metadataFieldArray[n2];
            sb.append("\t");
            String value = properties.get(field.toString());
            if (value != null) {
                sb.append(value);
            }
            ++n2;
        }
    }

    private void printDataSetsOn(Experiment experiment, StringBuffer sb) {
        sb.append("\t");
        ArrayList<DataSet> dataSets = this.experimentDataSets.get(experiment.getIdentifier());
        boolean isFirstLine = true;
        for (DataSet dataSet : dataSets) {
            String path;
            String dataSetCode = dataSet.getCode();
            String strainNames = (String)dataSet.getProperties().get(STRAIN_NAMES_PROPERTY);
            try {
                path = this.dataSetFiles.get(dataSet).getCanonicalPath();
            }
            catch (IOException ex) {
                throw new IOExceptionUnchecked(ex);
            }
            if (!isFirstLine) {
                sb.append("\n");
                this.printEmptyExperimentInformationOn(sb);
            }
            sb.append(dataSetCode);
            sb.append("\t");
            sb.append(strainNames);
            sb.append("\t");
            sb.append(path);
            isFirstLine = false;
        }
    }

    private void printRegisteredByOn(EntityRegistrationDetails registrationDetails, StringBuffer sb) {
        sb.append("\t");
        sb.append(registrationDetails.getUserEmail());
    }

    private static enum MetadataField {
        EXPERIMENT_DATE("Date"),
        DESCRIPTION("Description"),
        MEDIUM("Medium"),
        TEMPERATURE("Temperature"),
        MISC_GROWTH_CONDITIONS("Growth Conditions");

        private final String headerText;

        private MetadataField(String headerText) {
            this.headerText = headerText;
        }
    }
}

