/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import eu.basysbio.cisd.dss.DatabaseFeeder;
import eu.basysbio.cisd.dss.IDataSetUploader;
import eu.basysbio.cisd.dss.IDatabaseFeeder;
import eu.basysbio.cisd.dss.ITimeSeriesDAO;
import eu.basysbio.cisd.dss.TimeSeriesDataSetUploaderParameters;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;

abstract class AbstractDataSetUploader
implements IDataSetUploader {
    protected final ITimeSeriesDAO dao;
    protected final IEncapsulatedOpenBISService service;
    protected final TimeSeriesDataSetUploaderParameters parameters;
    protected final IDatabaseFeeder databaseFeeder;
    private Connection connection;

    AbstractDataSetUploader(DataSource dataSource, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        this.service = service;
        this.parameters = parameters;
        try {
            this.connection = dataSource.getConnection();
            this.connection.setAutoCommit(false);
            this.dao = (ITimeSeriesDAO)QueryTool.getQuery((Connection)this.connection, ITimeSeriesDAO.class);
            this.databaseFeeder = new DatabaseFeeder(this.dao, service, parameters);
        }
        catch (SQLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    AbstractDataSetUploader(ITimeSeriesDAO dao, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        this(dao, new DatabaseFeeder(dao, service, parameters), service, parameters);
    }

    AbstractDataSetUploader(ITimeSeriesDAO dao, IDatabaseFeeder databaseFeeder, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        this.dao = dao;
        this.service = service;
        this.parameters = parameters;
        this.databaseFeeder = databaseFeeder;
    }

    @Override
    public void commit() {
        try {
            try {
                if (this.connection != null) {
                    this.connection.commit();
                }
                this.dao.close();
            }
            catch (SQLException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        finally {
            this.connection = null;
        }
    }

    @Override
    public void rollback() {
        try {
            try {
                if (this.connection != null) {
                    this.connection.rollback();
                }
                this.dao.close();
            }
            catch (SQLException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        finally {
            this.connection = null;
        }
    }

    @Override
    public void upload(File originalData, DataSetInformation dataSetInformation) {
        ExperimentIdentifier experimentIdentifier = dataSetInformation.getExperimentIdentifier();
        if (experimentIdentifier == null) {
            throw new UserFailureException("Data set should be registered for an experiment and not for a sample.");
        }
        if (originalData.isFile()) {
            this.handleTSVFile(originalData, dataSetInformation);
        } else {
            File[] tsvFiles = originalData.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lowerCaseName = name.toLowerCase();
                    return lowerCaseName.endsWith(".txt") || lowerCaseName.endsWith(".tsv");
                }
            });
            if (tsvFiles == null || tsvFiles.length == 0) {
                throw new UserFailureException("No files of type '.txt', '.TXT', '.tsv', or '.TSV'. found in " + originalData);
            }
            File[] fileArray = tsvFiles;
            int n = tsvFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File tsvFile = fileArray[n2];
                this.handleTSVFile(tsvFile, dataSetInformation);
                ++n2;
            }
        }
    }

    protected abstract void handleTSVFile(File var1, DataSetInformation var2);
}

