/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import eu.basysbio.cisd.dss.IDataSetUploader;
import eu.basysbio.cisd.dss.IDataSetUploaderFactory;
import eu.basysbio.cisd.dss.ITimeSeriesDAO;
import eu.basysbio.cisd.dss.TimeSeriesDataSetUploaderParameters;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.DataSource;

class DataSetUploaderFactory
implements IDataSetUploaderFactory {
    private final Map<String, IDataSetUploaderFactory> factories = new LinkedHashMap<String, IDataSetUploaderFactory>();
    private final IDataSetUploaderFactory defaultFactory;
    private final Pattern pattern;

    DataSetUploaderFactory(IDataSetUploaderFactory defaultFactory, Pattern pattern) {
        this.defaultFactory = defaultFactory;
        this.pattern = pattern;
    }

    void register(String dataSetType, IDataSetUploaderFactory uploaderFactory) {
        this.factories.put(dataSetType, uploaderFactory);
    }

    @Override
    public IDataSetUploader create(DataSetInformation dataSetInformation, DataSource dataSource, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        IDataSetUploaderFactory factory = this.getFactory(dataSetInformation);
        return factory.create(dataSetInformation, dataSource, service, parameters);
    }

    @Override
    public IDataSetUploader create(DataSetInformation dataSetInformation, ITimeSeriesDAO dao, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        IDataSetUploaderFactory factory = this.getFactory(dataSetInformation);
        return factory.create(dataSetInformation, dao, service, parameters);
    }

    private IDataSetUploaderFactory getFactory(DataSetInformation dataSetInformation) {
        String dataSetType = dataSetInformation.getDataSetType().getCode();
        IDataSetUploaderFactory factory = this.factories.get(dataSetType);
        if (factory != null) {
            return factory;
        }
        if (!this.pattern.matcher(dataSetType).matches()) {
            throw new UserFailureException("Unable to handle data sets of type " + dataSetType);
        }
        return this.defaultFactory;
    }
}

