/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.utils;

import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupByMap<K, E> {
    private final Map<K, List<E>> map;
    private final IGroupKeyExtractor<K, E> extractor;

    public GroupByMap(IGroupKeyExtractor<K, E> extractor) {
        this.extractor = extractor;
        this.map = new HashMap<K, List<E>>();
    }

    public static <K, E> GroupByMap<K, E> create(Iterable<? extends E> rows, IGroupKeyExtractor<K, E> extractor) {
        GroupByMap<K, E> table = new GroupByMap<K, E>(extractor);
        for (E row : rows) {
            table.add(row);
        }
        return table;
    }

    public void add(E row) {
        K key = this.extractor.getKey(row);
        List<E> elements = this.map.get(key);
        if (elements == null) {
            elements = new ArrayList();
        }
        elements.add(row);
        this.map.put(key, elements);
    }

    public List<E> tryGet(K key) {
        return this.map.get(key);
    }

    public List<E> getOrDie(K key) {
        List<E> result = this.tryGet(key);
        if (result == null) {
            throw new IllegalStateException("No element with the key " + key);
        }
        return result;
    }

    public Set<K> getKeys() {
        return this.map.keySet();
    }

    public Map<K, List<E>> getMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

