/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeAndWaitingProvider;
import ch.systemsx.cisd.common.utilities.IWaitingCondition;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;

public class WaitingHelper {
    private static final long MINIMUM_LOG_INTERVAL = 60000L;
    private static final long MAXIMUM_LOG_INTERVAL = 3600000L;
    private static final double FACTOR = (Math.sqrt(5.0) + 1.0) / 2.0;
    private static final ISimpleLogger DUMMY_LOGGER = new ISimpleLogger(){

        @Override
        public void log(LogLevel level, String message, Throwable throwableOrNull) {
        }

        @Override
        public void log(LogLevel level, String message) {
        }
    };
    private final long timeOut;
    private final long pollingTime;
    private final ITimeAndWaitingProvider provider;
    private final ISimpleLogger logger;

    public WaitingHelper(long timeOut, long pollingTime, ISimpleLogger loggerOrNull) {
        this(timeOut, pollingTime, SystemTimeProvider.SYSTEM_TIME_PROVIDER, loggerOrNull);
    }

    public WaitingHelper(long timeOut, long pollingTime, ITimeAndWaitingProvider provider, ISimpleLogger loggerOrNull) {
        this.timeOut = timeOut;
        this.pollingTime = pollingTime;
        this.provider = provider;
        this.logger = loggerOrNull != null ? loggerOrNull : DUMMY_LOGGER;
    }

    public boolean waitOn(IWaitingCondition condition) {
        long t0;
        long t = t0 = this.provider.getTimeInMilliseconds();
        long lastLogTime = t0;
        long logInterval = 60000L;
        while (t < t0 + this.timeOut) {
            long duration = t - t0;
            String renderedDuration = DateTimeUtils.renderDuration(duration);
            if (condition.conditionFulfilled()) {
                this.log(renderedDuration, condition, true);
                return true;
            }
            if (duration == 0L || t >= lastLogTime + logInterval) {
                this.log(renderedDuration, condition, false);
                lastLogTime = t;
                logInterval = Math.min(3600000L, Math.round((double)logInterval * FACTOR));
            }
            this.provider.sleep(this.pollingTime);
            t = this.provider.getTimeInMilliseconds();
        }
        return false;
    }

    private void log(String renderedDuration, IWaitingCondition condition, boolean fulfilled) {
        this.logger.log(LogLevel.INFO, "Condition " + (fulfilled ? "" : "still not ") + "fulfilled after " + renderedDuration + ", condition: " + condition);
    }
}

