/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MaterialTranslator {
    private MaterialTranslator() {
    }

    public static NewMaterial translateToNewMaterial(Material material) {
        NewMaterial newMaterial = new NewMaterial(material.getCode());
        IEntityProperty[] properties = material.getProperties().toArray(new IEntityProperty[0]);
        newMaterial.setProperties(properties);
        return newMaterial;
    }

    public static final List<Material> translate(List<MaterialPE> materials, Map<Long, Set<Metaproject>> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        ArrayList<Material> result = new ArrayList<Material>();
        for (MaterialPE material : materials) {
            result.add(MaterialTranslator.translate(material, (Collection<Metaproject>)metaprojects.get(material.getId()), managedPropertyEvaluatorFactory));
        }
        return result;
    }

    public static final Material translate(MaterialPE materialPE, Collection<Metaproject> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        return MaterialTranslator.translate(materialPE, true, metaprojects, managedPropertyEvaluatorFactory);
    }

    public static final Material translate(MaterialPE materialPE, boolean withProperties, Collection<Metaproject> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        if (materialPE == null) {
            return null;
        }
        Material result = new Material();
        result.setCode(materialPE.getCode());
        result.setId(HibernateUtils.getId(materialPE));
        result.setModificationDate(materialPE.getModificationDate());
        result.setMaterialType(MaterialTypeTranslator.translate(materialPE.getMaterialType(), new HashMap<PropertyTypePE, PropertyType>()));
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(materialPE.getDatabaseInstance()));
        result.setRegistrator(PersonTranslator.translate(materialPE.getRegistrator()));
        result.setRegistrationDate(materialPE.getRegistrationDate());
        if (withProperties) {
            MaterialTranslator.setProperties(materialPE, result, managedPropertyEvaluatorFactory);
        }
        if (metaprojects != null) {
            result.setMetaprojects(metaprojects);
        }
        return result;
    }

    private static void setProperties(MaterialPE materialPE, Material result, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        if (materialPE.isPropertiesInitialized()) {
            result.setProperties(EntityPropertyTranslator.translate(materialPE.getProperties(), new HashMap<PropertyTypePE, PropertyType>(), managedPropertyEvaluatorFactory));
        } else {
            result.setProperties(new ArrayList<IEntityProperty>());
        }
    }
}

