/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.AbstractDataValidator;
import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBConnectionValidator
extends AbstractDataValidator {
    private static final String DEFAULT_ERROR_MESSAGE = "Cannot connect to the specified database.";
    private static final String JDBC_DRIVER_NAME = "org.postgresql.Driver";
    private static final String NO_PASSWORD = "";

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getErrorMessageId() {
        if (this.getErrorMessage() != null) {
            return this.getErrorMessage();
        }
        return DEFAULT_ERROR_MESSAGE;
    }

    @Override
    public String getWarningMessageId() {
        return this.getErrorMessageId();
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData data) {
        String ownerPassword;
        String owner;
        if (!Utils.isASInstalled(GlobalInstallationContext.installDir)) {
            return DataValidator.Status.OK;
        }
        String host = this.getHost();
        if (!this.testConnectionOK(host, owner = this.getOwner(), ownerPassword = this.getOwnerPassword(), "database.owner")) {
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    private String getHost() {
        return this.getProperty("database.url-host-part", "localhost");
    }

    private String getOwner() {
        String user = System.getProperty("user.name").toLowerCase();
        return this.getProperty("database.owner", user);
    }

    private String getOwnerPassword() {
        return this.getProperty("database.owner-password", NO_PASSWORD);
    }

    private String getProperty(String key, String defaultValue) {
        if (GlobalInstallationContext.isFirstTimeInstallation) {
            return defaultValue;
        }
        String property = Utils.tryToGetServicePropertyOfAS(GlobalInstallationContext.installDir, key);
        if (property != null && property.trim().length() > 0) {
            return property.trim();
        }
        return defaultValue;
    }

    private boolean testConnectionOK(String host, String username, String password, String messagePostfix) {
        boolean connected = false;
        try {
            Class.forName(JDBC_DRIVER_NAME);
            Connection connection = DriverManager.getConnection("jdbc:postgresql://" + host + "/template1", username, password);
            if (connection != null) {
                connected = true;
                connection.close();
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.createMessage(cnfe, messagePostfix);
        }
        catch (SQLException e) {
            this.createMessage(e, messagePostfix);
        }
        return connected;
    }

    private void createMessage(Exception exception, String messagePostfix) {
        this.setErrorMessage(String.valueOf(exception.getMessage()) + ".\nThe error is probably caused by an ill-configured " + messagePostfix + ".");
    }
}

