/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class ResourceManager {
    private static final Logger LOGGER = Logger.getLogger(ResourceManager.class.getName());
    private String locale = "eng";
    public final String resourceBasePathDefaultConstant = "/resources/";
    private String resourceBasePath = "/resources/";
    private String bundleName = null;
    private static ResourceManager instance = null;

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager(new Properties());
        }
        return instance;
    }

    public ResourceManager(Properties properties) {
        String systemPropertyBundleName = properties.getProperty("resource.bundle.system.property");
        if (systemPropertyBundleName != null) {
            this.setBundleName(System.getProperty(systemPropertyBundleName));
        }
    }

    public void setDefaultOrResourceBasePath(String aDefaultBasePath) {
        if (aDefaultBasePath != null) {
            this.setResourceBasePath(aDefaultBasePath);
        } else {
            this.setResourceBasePath("/resources/");
        }
    }

    private String getLanguageResourceString(String resource) {
        if (resource.charAt(0) == '/') {
            return this.getAbsoluteLanguageResourceString(resource);
        }
        return this.getAbsoluteLanguageResourceString(String.valueOf(this.getResourceBasePath()) + resource);
    }

    private boolean resourceExists(String resourcePath) {
        boolean result = true;
        InputStream in = ResourceManager.class.getResourceAsStream(resourcePath);
        if (in == null) {
            result = false;
        }
        return result;
    }

    private String getAbsoluteLanguageResourceString(String resource) {
        String resourcePath = String.valueOf(resource) + "_" + this.locale;
        InputStream in = ClassLoader.getSystemResourceAsStream(resourcePath);
        if (in != null) {
            return resourcePath;
        }
        in = ClassLoader.getSystemResourceAsStream(resource);
        if (in != null) {
            return resource;
        }
        if (resource.charAt(0) == '/') {
            return this.getAbsoluteLanguageResourceString(resource.substring(1));
        }
        throw new ResourceNotFoundException("Cannot find named Resource: '" + resource + "' AND '" + resourcePath + "'");
    }

    public boolean isResourceExist(String resource) {
        return this.getLanguageResourceString(resource) != null;
    }

    public InputStream getInputStream(String resource) throws ResourceNotFoundException {
        String resourcepath = this.getLanguageResourceString(resource);
        return ClassLoader.getSystemResourceAsStream(resourcepath);
    }

    public InputStream getInputStream(String resource, InputStream defaultValue) {
        String resourcepath = this.getLanguageResourceString(resource);
        if (resourcepath == null) {
            return defaultValue;
        }
        return ClassLoader.getSystemResourceAsStream(resourcepath);
    }

    public URL getLocalizedURL(String resource) {
        return ClassLoader.getSystemResource(this.getLanguageResourceString(resource));
    }

    private URL getURL(String resource) {
        if (resource.charAt(0) == '/') {
            return this.getClass().getResource(resource);
        }
        return this.getClass().getResource(String.valueOf(this.getResourceBasePath()) + resource);
    }

    public String getTextResource(String resource, String encoding) throws IOException {
        int bytesInBuffer;
        InputStream in = this.getInputStream(resource);
        ByteArrayOutputStream infoData = new ByteArrayOutputStream();
        byte[] buffer = new byte[5120];
        while ((bytesInBuffer = in.read(buffer)) != -1) {
            infoData.write(buffer, 0, bytesInBuffer);
        }
        if (encoding != null) {
            return infoData.toString(encoding);
        }
        return infoData.toString();
    }

    public String getTextResource(String resource) throws IOException {
        return this.getTextResource(resource, null);
    }

    public ImageIcon getImageIconResource(String resource, String ... fallback) {
        URL location = this.getURL(resource);
        if (location != null) {
            return new ImageIcon(location);
        }
        String[] stringArray = fallback;
        int n = fallback.length;
        int n2 = 0;
        while (n2 < n) {
            String fallbackResource = stringArray[n2];
            location = this.getURL(fallbackResource);
            if (location != null) {
                return new ImageIcon(location);
            }
            ++n2;
        }
        LOGGER.info("Image icon resource not found in " + resource + " and in fallbacks " + Arrays.toString(fallback));
        return null;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getResourceBasePath() {
        return this.resourceBasePath;
    }

    public void setResourceBasePath(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath;
    }

    public InputStream getLangPack(String localeISO3) {
        return ClassLoader.getSystemResourceAsStream(String.valueOf(this.getResourceBasePath()) + "/langpacks/" + localeISO3 + ".xml");
    }

    public InputStream getLangPack() {
        return this.getLangPack(this.locale);
    }

    public List<String> getAvailableLangPacks() {
        List available;
        try {
            InputStream in = this.getInputStream("langpacks.info");
            ObjectInputStream objIn = new ObjectInputStream(in);
            available = (List)objIn.readObject();
            objIn.close();
        }
        catch (Exception e) {
            throw new IzPackException("Could not read the langpack", e);
        }
        return available;
    }

    protected void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    protected String getBundleName() {
        return this.bundleName;
    }

    private String getBundlePath() {
        String basePath = this.resourceBasePath;
        if (this.bundleName != null) {
            basePath = String.valueOf(basePath) + this.bundleName + "/";
        }
        return basePath;
    }
}

