/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.core.variable.ValueImpl;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import java.io.Serializable;

public class ExecValue
extends ValueImpl
implements Serializable {
    private static final long serialVersionUID = -6438593229737421526L;
    private String[] cmd;
    private String dir;
    private boolean useStdErr = true;

    public ExecValue(String[] command, String dir, boolean isShellCommand, boolean useStdErr) {
        if (isShellCommand) {
            if (OsVersion.IS_WINDOWS) {
                this.cmd = new String[command.length + 2];
                this.cmd[0] = "cmd";
                this.cmd[1] = "/C";
                int i = 2;
                while (i < this.cmd.length) {
                    this.cmd[i] = command[i - 2];
                    ++i;
                }
            } else if (OsVersion.IS_UNIX) {
                this.cmd = new String[command.length + 1];
                this.cmd[0] = "sh";
                int i = 1;
                while (i < this.cmd.length) {
                    this.cmd[i] = command[i - 1];
                    ++i;
                }
            } else {
                this.cmd = command;
            }
        } else {
            this.cmd = command;
        }
        this.dir = dir;
        this.useStdErr = useStdErr;
    }

    public String[] getCmd() {
        return this.cmd;
    }

    public void setCmd(String[] cmd) {
        this.cmd = cmd;
    }

    @Override
    public void validate() throws Exception {
        if (this.cmd == null || this.cmd.length <= 0) {
            throw new IllegalArgumentException("Bad command line");
        }
    }

    @Override
    public String resolve() {
        VariableSubstitutorImpl substitutor = new VariableSubstitutorImpl(this.getInstallData().getVariables());
        return this.resolve(substitutor);
    }

    @Override
    public String resolve(VariableSubstitutor ... substitutors) {
        String _dir_ = null;
        String[] _cmd_ = new String[this.cmd.length];
        VariableSubstitutor[] variableSubstitutorArray = substitutors;
        int n = substitutors.length;
        int n2 = 0;
        while (n2 < n) {
            VariableSubstitutor substitutor = variableSubstitutorArray[n2];
            _dir_ = substitutor.substitute(this.dir, null);
            ++n2;
        }
        int i = 0;
        while (i < this.cmd.length) {
            String _cmdarg_ = this.cmd[i];
            VariableSubstitutor[] variableSubstitutorArray2 = substitutors;
            int n3 = substitutors.length;
            int n4 = 0;
            while (n4 < n3) {
                VariableSubstitutor substitutor = variableSubstitutorArray2[n4];
                _cmdarg_ = substitutor.substitute(_cmdarg_, null);
                ++n4;
            }
            _cmd_[i] = _cmdarg_;
            ++i;
        }
        String[] execOut = new String[2];
        int ret = new FileExecutor().executeCommand(_cmd_, execOut, _dir_);
        if (ret == 0) {
            if (this.useStdErr) {
                return execOut[1];
            }
            return execOut[0];
        }
        return null;
    }
}

