/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.event.ActionBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.util.JavaEnvUtils;

public class AntAction
extends ActionBase {
    private static final long serialVersionUID = 3258131345250005557L;
    public static final String ANTACTIONS = "antactions";
    public static final String ANTACTION = "antaction";
    public static final String ANTCALL = "antcall";
    private boolean quiet = false;
    private boolean verbose = false;
    private Properties properties = new Properties();
    private List<String> targets = new ArrayList<String>();
    private List<String> uninstallTargets = new ArrayList<String>();
    private File logFile = null;
    private File buildFile = null;
    private String conditionId = null;
    private List<String> propertyFiles = new ArrayList<String>();

    public void performInstallAction() throws Exception {
        this.performAction(false);
    }

    public void performUninstallAction() throws Exception {
        this.performAction(true);
    }

    public void performAction(boolean uninstall) throws Exception {
        if (this.verbose) {
            System.out.println("Calling ANT with buildfile: " + this.buildFile);
        }
        SecurityManager oldsm = null;
        if (!JavaEnvUtils.isJavaVersion((String)"1.0") && !JavaEnvUtils.isJavaVersion((String)"1.1")) {
            oldsm = System.getSecurityManager();
        }
        PrintStream err = System.err;
        PrintStream out = System.out;
        try {
            List<String> choosenTargets;
            Project antProj = new Project();
            antProj.setName("antcallproject");
            antProj.addBuildListener((BuildListener)this.createLogger());
            antProj.setInputHandler((InputHandler)new DefaultInputHandler());
            antProj.setSystemProperties();
            this.addProperties(antProj, this.getProperties());
            this.addPropertiesFromPropertyFiles(antProj);
            antProj.fireBuildStarted();
            antProj.init();
            ArrayList<Ant> antcalls = new ArrayList<Ant>();
            List<String> list = choosenTargets = uninstall ? this.uninstallTargets : this.targets;
            if (choosenTargets.size() > 0) {
                Ant antcall = null;
                for (String choosenTarget : choosenTargets) {
                    antcall = (Ant)antProj.createTask("ant");
                    antcall.setAntfile(this.getBuildFile().getAbsolutePath());
                    antcall.setTarget(choosenTarget);
                    antcalls.add(antcall);
                }
            }
            Target target = new Target();
            target.setName("calltarget");
            for (Ant antcall : antcalls) {
                target.addTask((Task)antcall);
            }
            antProj.addTarget(target);
            System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(antProj, false)));
            System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(antProj, true)));
            antProj.executeTarget("calltarget");
        }
        finally {
            if (oldsm != null) {
                System.setSecurityManager(oldsm);
            }
            System.setOut(out);
            System.setErr(err);
        }
    }

    public String getConditionId() {
        return this.conditionId;
    }

    public void setConditionId(String conditionId) {
        this.conditionId = conditionId;
    }

    public File getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(File buildFile) {
        this.buildFile = buildFile;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public List<String> getPropertyFiles() {
        return this.propertyFiles;
    }

    public void addPropertyFile(String propertyFile) {
        this.propertyFiles.add(propertyFile);
    }

    public void setPropertyFiles(List<String> propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList<String> targets) {
        this.targets = targets;
    }

    public void addTarget(String target) {
        this.targets.add(target);
    }

    public List<String> getUninstallTargets() {
        return this.uninstallTargets;
    }

    public void setUninstallTargets(ArrayList<String> targets) {
        this.uninstallTargets = targets;
    }

    public void addUninstallTarget(String target) {
        this.uninstallTargets.add(target);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private BuildLogger createLogger() {
        int msgOutputLevel = 2;
        if (this.verbose) {
            msgOutputLevel = 4;
        } else if (this.quiet) {
            msgOutputLevel = 1;
        }
        DefaultLogger logger = new DefaultLogger();
        logger.setMessageOutputLevel(msgOutputLevel);
        if (this.logFile != null) {
            try {
                this.logFile.getParentFile().mkdirs();
                PrintStream printStream = new PrintStream(new FileOutputStream(this.logFile));
                logger.setOutputPrintStream(printStream);
                logger.setErrorPrintStream(printStream);
            }
            catch (FileNotFoundException e) {
                logger.setOutputPrintStream(System.out);
                logger.setErrorPrintStream(System.err);
            }
        } else {
            logger.setOutputPrintStream(System.out);
            logger.setErrorPrintStream(System.err);
        }
        return logger;
    }

    private void addProperties(Project proj, Properties props) {
        if (proj == null) {
            return;
        }
        if (props.size() > 0) {
            for (Object o : props.keySet()) {
                String key = (String)o;
                proj.setProperty(key, props.getProperty(key));
            }
        }
    }

    private void addPropertiesFromPropertyFiles(Project proj) throws Exception {
        if (proj == null) {
            return;
        }
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            for (String propertyFile : this.propertyFiles) {
                File file = new File(propertyFile);
                if (file.exists()) {
                    fis = new FileInputStream(file);
                    props.load(fis);
                    fis.close();
                    continue;
                }
                throw new Exception("Required propertyfile " + file + " for antcall doesn't exist.");
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        this.addProperties(proj, props);
    }
}

