/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.resolve;

import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.merge.file.FileMerge;
import com.izforge.izpack.merge.jar.JarMerge;
import com.izforge.izpack.merge.resolve.ResolveUtils;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class MergeableResolver {
    private Map<OutputStream, List<String>> mergeContent;

    public MergeableResolver(Map<OutputStream, List<String>> mergeContent) {
        this.mergeContent = mergeContent;
    }

    public Mergeable getMergeableFromURL(URL url) {
        if (!ResolveUtils.isJar(url)) {
            return new FileMerge(url, this.mergeContent);
        }
        return new JarMerge(url, ResolveUtils.processUrlToJarPath(url), this.mergeContent);
    }

    public Mergeable getMergeableFromURL(URL url, String resourcePath) {
        if (ResolveUtils.isJar(url)) {
            return new JarMerge(url, ResolveUtils.processUrlToJarPath(url), this.mergeContent);
        }
        return new FileMerge(url, resourcePath, this.mergeContent);
    }

    public Mergeable getMergeableFromURLWithDestination(URL url, String destination) {
        if (ResolveUtils.isJar(url)) {
            if (ResolveUtils.isFileInJar(url)) {
                return new JarMerge(ResolveUtils.processUrlToJarPath(url), ResolveUtils.processUrlToInsidePath(url), destination, this.mergeContent);
            }
            return new JarMerge(ResolveUtils.processUrlToJarPath(url), ResolveUtils.processUrlToJarPackage(url), destination, this.mergeContent);
        }
        return new FileMerge(url, destination, this.mergeContent);
    }
}

