/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.util.Debug;
import java.util.ArrayList;
import java.util.List;

public class PacksPanelAutomationHelper
implements PanelAutomation {
    @Override
    public void makeXMLData(AutomatedInstallData idata, IXMLElement panelRoot) {
        int i = 0;
        while (i < idata.getAvailablePacks().size()) {
            Pack pack = idata.getAvailablePacks().get(i);
            XMLElementImpl packElement = new XMLElementImpl("pack", panelRoot);
            packElement.setAttribute("index", Integer.toString(i));
            packElement.setAttribute("name", pack.name);
            Boolean selected = idata.getSelectedPacks().contains(pack);
            packElement.setAttribute("selected", selected.toString());
            panelRoot.addChild(packElement);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void runAutomated(AutomatedInstallData idata, IXMLElement panelRoot) {
        void var5_10;
        final class PInfo {
            private boolean _selected;
            private int _index;
            private String _name = "";

            PInfo(boolean selected, String index, String name) {
                this._selected = selected;
                try {
                    this._index = Integer.valueOf(index);
                }
                catch (NumberFormatException e) {
                    this._index = -100;
                }
                if (name != null) {
                    this._name = name;
                }
            }

            public boolean isSelected() {
                return this._selected;
            }

            public boolean equals(int index) {
                return this._index == index && this._name.equals("");
            }

            public boolean equals(String name) {
                return this._name.equals(name);
            }

            public String toString() {
                String retVal = "";
                if (!this._name.equals("")) {
                    retVal = "Name: " + this._name + " and ";
                }
                retVal = String.valueOf(retVal) + "Index: " + String.valueOf(this._index);
                return retVal;
            }
        }
        ArrayList<PInfo> autoinstallPackInfoList = new ArrayList<PInfo>();
        List<IXMLElement> packList = panelRoot.getChildrenNamed("pack");
        Debug.log("Read pack list from xml definition.");
        for (IXMLElement iXMLElement : packList) {
            String index = iXMLElement.getAttribute("index");
            String name = iXMLElement.getAttribute("name");
            String selectedString = iXMLElement.getAttribute("selected");
            boolean selected = selectedString.equalsIgnoreCase("true") || selectedString.equalsIgnoreCase("on");
            PInfo packInfo = new PInfo(selected, index, name);
            autoinstallPackInfoList.add(packInfo);
            Debug.log("Try to " + (selected ? "add to" : "remove from") + " selection [" + packInfo.toString() + "]");
        }
        Debug.log("Modify pack selection.");
        block1: for (Pack pack : idata.getAvailablePacks()) {
            int indexOfAvailablePack = idata.getAvailablePacks().indexOf(pack);
            for (PInfo packInfo : autoinstallPackInfoList) {
                if (!packInfo.equals(pack.name) && !packInfo.equals(indexOfAvailablePack)) continue;
                if (pack.required) {
                    if (packInfo.isSelected()) continue block1;
                    Debug.log("Pack [" + packInfo.toString() + "] must be installed because it is required!");
                    continue block1;
                }
                if (packInfo.isSelected()) {
                    RulesEngine rules = idata.getRules();
                    if (idata.getSelectedPacks().indexOf(pack) >= 0 || pack.id == null || !rules.canInstallPack(pack.id, idata.getVariables())) continue block1;
                    idata.getSelectedPacks().add(pack);
                    Debug.log("Pack [" + packInfo.toString() + "] added to selection.");
                    continue block1;
                }
                idata.getSelectedPacks().remove(pack);
                Debug.log("Pack [" + packInfo.toString() + "] removed from selection.");
                continue block1;
            }
        }
        int n = panelRoot.getChildrenCount();
        while (var5_10 > 0) {
            panelRoot.removeChild(panelRoot.getChildAtIndex(0));
            --var5_10;
        }
        this.makeXMLData(idata, panelRoot);
    }
}

