/*
 * Copyright 2010 ETH Zuerich, CISD
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto;

import java.io.Serializable;

/**
 * Immutable class of a property key. Two instances are equal if their IDs are equal.
 *
 * @author Franz-Josef Elmer
 */
public final class PropertyKey implements Serializable
{

    private static final long serialVersionUID = 1L;
    
    private final String id;
    
    private final String label;

    /**
     * Creates a new instance for specified ID and label.
     */
    public PropertyKey(String id, String label)
    {
        this.id = id;
        this.label = label;
    }
    
    /**
     * Returns the ID.
     */
    public String getId()
    {
        return id;
    }
    
    /**
     * Returns the label.
     */
    public String getLabel()
    {
        return label;
    }
    
    @Override
    public boolean equals(Object obj)
    {
        if (this == obj)
        {
            return true;
        }
        if (obj instanceof PropertyKey == false)
        {
            return false;
        }
        PropertyKey key = (PropertyKey) obj;
        return key.id.equals(id);
    }

    @Override
    public int hashCode()
    {
        return id.hashCode();
    }

    /**
     * Renders this key in the form <code>&lt;label&gt;[&lt;id&gt;]</code>.
     */
    @Override
    public String toString()
    {
        return label + "[" + id + "]";
    }
    
}
