/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython.evaluator;

import ch.systemsx.cisd.common.jython.PythonInterpreter;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTraceback;

public final class Evaluator {
    private final PythonInterpreter interpreter;
    private final String expression;
    private final PyCode compiledExpression;

    public static void initialize() {
        PySystemState.initialize();
    }

    public Evaluator(String expression) throws EvaluatorException {
        this(expression, null, null);
    }

    public Evaluator(String expression, Class<?> supportFunctionsOrNull, String initialScriptOrNull) throws EvaluatorException {
        this(expression, null, supportFunctionsOrNull, initialScriptOrNull, true);
    }

    public Evaluator(String expression, String[] pythonPath, Class<?> supportFunctionsOrNull, String initialScriptOrNull, boolean blockFileAccess) throws EvaluatorException {
        if (Evaluator.isMultiline(expression)) {
            throw new EvaluatorException("Expression '" + expression + "' contains line breaks");
        }
        this.interpreter = PythonInterpreter.createIsolatedPythonInterpreter();
        this.interpreter.addToPath(pythonPath);
        try {
            if (blockFileAccess) {
                this.interpreter.exec("def open():\n   pass");
            }
            if (supportFunctionsOrNull != null) {
                this.interpreter.exec("from " + supportFunctionsOrNull.getCanonicalName() + " import *");
            }
            if (initialScriptOrNull != null) {
                this.interpreter.exec(initialScriptOrNull);
            }
            this.expression = expression;
            this.compiledExpression = Evaluator.doCompile(expression);
        }
        catch (PyException ex) {
            throw this.toEvaluatorException(ex);
        }
    }

    public boolean hasFunction(String functionName) {
        PyObject pyObject = this.interpreter.get(functionName);
        return pyObject instanceof PyFunction;
    }

    /*
     * Unable to fully structure code
     */
    public Object evalFunction(String functionName, Object ... args) {
        try {
            pyObject = this.interpreter.get(functionName);
            if (pyObject == null) {
                throw new PyException((PyObject)new PyString("Unknown function"), functionName);
            }
            if (!(pyObject instanceof PyFunction)) {
                throw new PyException((PyObject)new PyString("Not a function"), "'" + functionName + "' is of type " + pyObject.getType().getName() + ".");
            }
            func = (PyFunction)pyObject;
            pyArgs = new PyObject[args.length];
            i = 0;
            while (i < args.length) {
                pyArgs[i] = this.translateToPython(args[i]);
                ++i;
            }
            result = func.__call__(pyArgs);
            return this.translateToJava(result);
        }
        catch (PyException ex) {
            builder = new CommaSeparatedListBuilder();
            var8_12 = args;
            var7_13 = args.length;
            var6_11 = 0;
            ** while (var6_11 < var7_13)
        }
lbl-1000:
        // 1 sources

        {
            argument = var8_12[var6_11];
            builder.append(argument);
            ++var6_11;
            continue;
        }
lbl26:
        // 1 sources

        throw Evaluator.toEvaluatorException(ex, String.valueOf(functionName) + "(" + builder + ")");
    }

    private PyObject translateToPython(Object javaObject) {
        if (javaObject instanceof String) {
            return new PyString((String)javaObject);
        }
        return Py.java2py(javaObject);
    }

    private static PyCode doCompile(String expression) throws EvaluatorException {
        try {
            return Py.compile_flags("__result__=(" + expression + ")", "expression: " + expression, CompileMode.exec, new CompilerFlags());
        }
        catch (PyException ex) {
            throw Evaluator.toEvaluatorException(ex, expression);
        }
    }

    public void set(String name, Object value) {
        this.interpreter.set(name, value);
    }

    public Object get(String name) {
        return this.interpreter.get(name);
    }

    public void delete(String name) {
        this.interpreter.getLocals().__delitem__(name);
    }

    public boolean has(String name) {
        return ((PyStringMap)this.interpreter.getLocals()).has_key(new PyString(name));
    }

    public ReturnType getType() {
        this.doEval();
        PyObject obj = this.getInterpreterResult();
        if (obj instanceof PyBoolean) {
            return ReturnType.BOOLEAN;
        }
        if (obj instanceof PyInteger) {
            return ReturnType.INTEGER;
        }
        if (obj instanceof PyLong) {
            return ReturnType.BIGINT;
        }
        if (obj instanceof PyFloat) {
            return ReturnType.DOUBLE;
        }
        if (obj instanceof PyString) {
            return ReturnType.STRING;
        }
        return ReturnType.OTHER;
    }

    public Object evalLegacy2_2() {
        this.doEval();
        PyObject obj = this.getInterpreterResult();
        Object result = this.translateToJavaLegacy(obj);
        if (!(result == null || result instanceof Long || result instanceof Double || result instanceof String)) {
            return result.toString();
        }
        return result;
    }

    public Object eval() {
        this.doEval();
        return this.translateToJava(this.getInterpreterResult());
    }

    private Object translateToJavaLegacy(PyObject obj) {
        if (obj instanceof PyInteger) {
            return new Long(((PyInteger)obj).getValue());
        }
        if (obj instanceof PyLong) {
            return new Long(((PyLong)obj).getValue().longValue());
        }
        if (obj instanceof PyFloat) {
            return new Double(((PyFloat)obj).getValue());
        }
        if (obj instanceof PyNone) {
            return null;
        }
        if (obj instanceof PyList) {
            PyList pyList = (PyList)obj;
            PyObject[] array = pyList.getArray();
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            int n = pyList.size();
            while (i < n) {
                list.add(this.translateToJavaLegacy(array[i]));
                ++i;
            }
            return list;
        }
        return this.translateToJava(obj);
    }

    private Object translateToJava(PyObject obj) {
        return obj == null ? null : obj.__tojava__(Object.class);
    }

    private PyObject getInterpreterResult() {
        return this.interpreter.get("__result__");
    }

    public boolean evalToBoolean() throws EvaluatorException {
        this.doEval();
        try {
            return ((PyBoolean)this.getInterpreterResult()).getBooleanValue();
        }
        catch (ClassCastException classCastException) {
            ReturnType type = this.getType();
            throw new EvaluatorException("Expected a result of type " + (Object)((Object)ReturnType.BOOLEAN) + ", found " + (Object)((Object)type));
        }
    }

    public int evalToInt() throws EvaluatorException {
        this.doEval();
        try {
            return ((PyInteger)this.getInterpreterResult()).getValue();
        }
        catch (ClassCastException classCastException) {
            ReturnType type = this.getType();
            throw new EvaluatorException("Expected a result of type " + (Object)((Object)ReturnType.INTEGER) + ", found " + (Object)((Object)type));
        }
    }

    public BigInteger evalToBigInt() throws EvaluatorException {
        this.doEval();
        try {
            return ((PyLong)this.getInterpreterResult()).getValue();
        }
        catch (ClassCastException classCastException) {
            ReturnType type = this.getType();
            throw new EvaluatorException("Expected a result of type " + (Object)((Object)ReturnType.BIGINT) + ", found " + (Object)((Object)type));
        }
    }

    public double evalToDouble() throws EvaluatorException {
        this.doEval();
        try {
            return ((PyFloat)this.getInterpreterResult()).getValue();
        }
        catch (ClassCastException classCastException) {
            ReturnType type = this.getType();
            throw new EvaluatorException("Expected a result of type " + (Object)((Object)ReturnType.DOUBLE) + ", found " + (Object)((Object)type));
        }
    }

    public String evalAsStringLegacy2_2() throws EvaluatorException {
        Object result = this.evalLegacy2_2();
        return result == null ? null : result.toString();
    }

    public String evalAsString() throws EvaluatorException {
        Object result = this.eval();
        return result == null ? null : result.toString();
    }

    private void doEval() throws EvaluatorException {
        try {
            this.interpreter.exec(this.compiledExpression);
        }
        catch (PyException ex) {
            throw this.toEvaluatorException(ex);
        }
    }

    private EvaluatorException toEvaluatorException(PyException ex) {
        return Evaluator.toEvaluatorException(ex, this.expression);
    }

    private static EvaluatorException toEvaluatorException(PyException ex, String expressionOrNull) {
        Throwable exception = ex;
        PyObject value = ex.value;
        Object object = value.__tojava__(Object.class);
        if (object instanceof Throwable) {
            exception = (Throwable)object;
        }
        String msg = Evaluator.extractExceptionMessage(ex);
        if (expressionOrNull != null) {
            PyTraceback traceback = ex.traceback;
            String details = traceback == null ? "" : "occurred in line " + traceback.tb_lineno + " of the script when ";
            msg = "Error " + details + "evaluating '" + expressionOrNull + "': " + msg;
        }
        return new EvaluatorException(msg, exception);
    }

    private static String extractExceptionMessage(PyException ex) {
        String[] description = StringUtils.split(ex.toString(), '\n');
        return description[description.length - 1];
    }

    public static boolean isMultiline(String expression) {
        return expression.indexOf(10) >= 0;
    }

    public void releaseResources() {
        this.interpreter.releaseResources();
    }

    public Collection<String> getGlobalVariables() {
        HashSet<String> results = new HashSet<String>();
        PyStringMap locals = (PyStringMap)this.interpreter.getLocals();
        for (Object key : locals.keys()) {
            results.add(key.toString());
        }
        return Collections.unmodifiableCollection(results);
    }

    public static enum ReturnType {
        BOOLEAN,
        INTEGER,
        BIGINT,
        DOUBLE,
        STRING,
        OTHER;

    }
}

