/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchSubCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonObject(value="SearchCriteria")
public class SearchCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SearchOperator operator = SearchOperator.MATCH_ALL_CLAUSES;
    private ArrayList<MatchClause> matchClauses = new ArrayList();
    private ArrayList<SearchSubCriteria> subCriterias = new ArrayList();

    public void setOperator(SearchOperator operator2) {
        this.operator = operator2;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public List<MatchClause> getMatchClauses() {
        return Collections.unmodifiableList(this.matchClauses);
    }

    public void addMatchClause(MatchClause criterion) {
        this.matchClauses.add(criterion);
    }

    public List<SearchSubCriteria> getSubCriterias() {
        return Collections.unmodifiableList(this.subCriterias);
    }

    public void addSubCriteria(SearchSubCriteria criteria) {
        this.subCriterias.add(criteria);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getOperator(), (Object)other.getOperator());
        builder.append(this.getMatchClauses(), other.getMatchClauses());
        builder.append(this.getSubCriterias(), other.getSubCriterias());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getOperator());
        builder.append(this.getMatchClauses());
        builder.append(this.getSubCriterias());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getOperator());
        builder.append(this.getMatchClauses());
        builder.append(this.getSubCriterias());
        return builder.toString();
    }

    private void setMatchClauses(ArrayList<MatchClause> matchClauses) {
        this.matchClauses = matchClauses;
    }

    private void setSubCriterias(ArrayList<SearchSubCriteria> subCriterias) {
        this.subCriterias = subCriterias;
    }

    @JsonObject(value="AnyFieldMatchClause")
    public static class AnyFieldMatchClause
    extends MatchClause {
        private static final long serialVersionUID = 1L;

        protected AnyFieldMatchClause(String desiredValue) {
            super(MatchClauseFieldType.ANY_FIELD, null, desiredValue, CompareMode.EQUALS);
            assert (desiredValue != null);
        }

        private AnyFieldMatchClause() {
        }
    }

    @JsonObject(value="AnyPropertyMatchClause")
    public static class AnyPropertyMatchClause
    extends MatchClause {
        private static final long serialVersionUID = 1L;

        protected AnyPropertyMatchClause(String desiredValue) {
            super(MatchClauseFieldType.ANY_PROPERTY, null, desiredValue, CompareMode.EQUALS);
            assert (desiredValue != null);
        }

        private AnyPropertyMatchClause() {
        }
    }

    @JsonObject(value="AttributeMatchClause")
    public static class AttributeMatchClause
    extends MatchClause {
        private static final long serialVersionUID = 1L;
        private MatchClauseAttribute attribute;

        protected AttributeMatchClause(MatchClauseAttribute attribute, String desiredValue) {
            super(MatchClauseFieldType.ATTRIBUTE, attribute.toString(), desiredValue, CompareMode.EQUALS);
            this.attribute = attribute;
        }

        public MatchClauseAttribute getAttribute() {
            return this.attribute;
        }

        private AttributeMatchClause() {
        }

        private void setAttribute(MatchClauseAttribute attribute) {
            this.attribute = attribute;
        }
    }

    @JsonObject(value="CompareMode")
    public static enum CompareMode {
        LESS_THAN_OR_EQUAL,
        EQUALS,
        GREATER_THAN_OR_EQUAL;

    }

    @JsonObject(value="MatchClause")
    public static class MatchClause
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private MatchClauseFieldType fieldType;
        private String fieldCode;
        private String desiredValue;
        private CompareMode compareMode = CompareMode.EQUALS;

        protected MatchClause(MatchClauseFieldType fieldType, String fieldCode, String desiredValue, CompareMode compareMode) {
            this.fieldType = fieldType;
            this.fieldCode = fieldCode;
            this.desiredValue = desiredValue;
            this.compareMode = compareMode;
        }

        public static MatchClause createPropertyMatch(String propertyCode, String desiredValue) {
            return new PropertyMatchClause(propertyCode, desiredValue);
        }

        public static MatchClause createAttributeMatch(MatchClauseAttribute attribute, String desiredValue) {
            return new AttributeMatchClause(attribute, desiredValue);
        }

        public static MatchClause createTimeAttributeMatch(MatchClauseTimeAttribute attribute, CompareMode mode, String date, String timezone) {
            return new TimeAttributeMatchClause(attribute, date, timezone, mode);
        }

        public static MatchClause createAnyPropertyMatch(String desiredValue) {
            return new AnyPropertyMatchClause(desiredValue);
        }

        public static MatchClause createAnyFieldMatch(String desiredValue) {
            return new AnyFieldMatchClause(desiredValue);
        }

        public static String escape(String s) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&') {
                    sb.append('\\');
                }
                sb.append(c);
                ++i;
            }
            return sb.toString();
        }

        public MatchClauseFieldType getFieldType() {
            return this.fieldType;
        }

        protected String getFieldCode() {
            return this.fieldCode;
        }

        public String getDesiredValue() {
            return this.desiredValue;
        }

        public CompareMode getCompareMode() {
            if (this.compareMode == null) {
                return CompareMode.EQUALS;
            }
            return this.compareMode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MatchClause)) {
                return false;
            }
            MatchClause other = (MatchClause)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getFieldType(), (Object)other.getFieldType());
            builder.append(this.getFieldCode(), other.getFieldCode());
            builder.append(this.getDesiredValue(), other.getDesiredValue());
            builder.append((Object)this.getCompareMode(), (Object)other.getCompareMode());
            return builder.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.getFieldType());
            builder.append(this.getFieldCode());
            builder.append(this.getDesiredValue());
            builder.append((Object)this.getCompareMode());
            return builder.toHashCode();
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
            builder.append((Object)this.getFieldType());
            builder.append(this.getFieldCode());
            builder.append(this.getDesiredValue());
            builder.append((Object)this.getCompareMode());
            return builder.toString();
        }

        private MatchClause() {
        }

        private void setFieldType(MatchClauseFieldType fieldType) {
            this.fieldType = fieldType;
        }

        private void setFieldCode(String fieldCode) {
            this.fieldCode = fieldCode;
        }

        private void setDesiredValue(String desiredValue) {
            this.desiredValue = desiredValue;
        }

        private void setCompareMode(CompareMode mode) {
            this.compareMode = mode;
        }
    }

    @JsonObject(value="MatchClauseAttribute")
    public static enum MatchClauseAttribute {
        CODE,
        TYPE,
        PERM_ID,
        SPACE,
        PROJECT,
        METAPROJECT;

    }

    @JsonObject(value="MatchClauseFieldType")
    public static enum MatchClauseFieldType {
        PROPERTY,
        ATTRIBUTE,
        ANY_FIELD,
        ANY_PROPERTY;

    }

    @JsonObject(value="MatchClauseTimeAttribute")
    public static enum MatchClauseTimeAttribute {
        REGISTRATION_DATE,
        MODIFICATION_DATE;

    }

    @JsonObject(value="PropertyMatchClause")
    public static class PropertyMatchClause
    extends MatchClause {
        private static final long serialVersionUID = 1L;
        private String propertyCode;

        protected PropertyMatchClause(String propertyCode, String desiredValue) {
            super(MatchClauseFieldType.PROPERTY, propertyCode, desiredValue, CompareMode.EQUALS);
            this.propertyCode = propertyCode;
            assert (propertyCode != null);
            assert (desiredValue != null);
        }

        public String getPropertyCode() {
            return this.propertyCode;
        }

        private PropertyMatchClause() {
        }

        private void setPropertyCode(String propertyCode) {
            this.propertyCode = propertyCode;
        }
    }

    @JsonObject(value="SearchOperator")
    public static enum SearchOperator {
        MATCH_ALL_CLAUSES,
        MATCH_ANY_CLAUSES;

    }

    @JsonObject(value="TimeAttributeMatchClause")
    public static class TimeAttributeMatchClause
    extends MatchClause {
        private static final long serialVersionUID = 1L;
        private MatchClauseTimeAttribute attribute;
        private String timezone;

        protected TimeAttributeMatchClause(MatchClauseTimeAttribute attribute, String desiredDate, String timezone, CompareMode mode) {
            super(MatchClauseFieldType.ATTRIBUTE, attribute.toString(), desiredDate, mode);
            this.timezone = timezone;
            this.attribute = attribute;
        }

        public MatchClauseTimeAttribute getAttribute() {
            return this.attribute;
        }

        public String getTimeZone() {
            return this.timezone;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TimeAttributeMatchClause)) {
                return false;
            }
            TimeAttributeMatchClause other = (TimeAttributeMatchClause)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getFieldType(), (Object)other.getFieldType());
            builder.append(this.getFieldCode(), other.getFieldCode());
            builder.append(this.getDesiredValue(), other.getDesiredValue());
            builder.append((Object)this.getCompareMode(), (Object)other.getCompareMode());
            builder.append(this.getTimeZone(), other.getTimeZone());
            return builder.isEquals();
        }

        @Override
        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.getFieldType());
            builder.append(this.getFieldCode());
            builder.append(this.getDesiredValue());
            builder.append((Object)this.getCompareMode());
            builder.append(this.getTimeZone());
            return builder.toHashCode();
        }

        private TimeAttributeMatchClause() {
        }

        private void setAttribute(MatchClauseTimeAttribute attribute) {
            this.attribute = attribute;
        }

        private void setTimeZone(String timezone) {
            this.timezone = timezone;
        }
    }
}

