/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.beans.PropertyAccessException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    public void processMissingFieldError(String missingField, BindingResult bindingResult) {
        String fixedField = bindingResult.getNestedPath() + missingField;
        String[] codes = bindingResult.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, missingField);
        Object[] arguments2 = this.getArgumentsForBindError(bindingResult.getObjectName(), fixedField);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), fixedField, "", true, codes, arguments2, "Field '" + fixedField + "' is required"));
    }

    public void processPropertyAccessException(PropertyAccessException ex, BindingResult bindingResult) {
        String field = ex.getPropertyChangeEvent().getPropertyName();
        Object value = ex.getPropertyChangeEvent().getNewValue();
        String[] codes = bindingResult.resolveMessageCodes(ex.getErrorCode(), field);
        Object[] arguments2 = this.getArgumentsForBindError(bindingResult.getObjectName(), field);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), field, value, true, codes, arguments2, ex.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String objectName, String field) {
        String[] codes = new String[]{objectName + "." + field, field};
        String defaultMessage = field;
        return new Object[]{new DefaultMessageSourceResolvable(codes, defaultMessage)};
    }
}

