/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import java.util.HashSet;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.StringUtils;

public class ExposablePropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    public static final String PROPERTY_CONFIGURER_BEAN_NAME = "propertyConfigurer";
    private Properties resolvedProps;

    public final Properties getResolvedProps() {
        return this.resolvedProps;
    }

    @Override
    protected final String convertPropertyValue(String originalValue) {
        return StringUtils.trimWhitespace(originalValue);
    }

    @Override
    protected final void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        this.resolvedProps = new Properties();
        for (Object key : props.keySet()) {
            String keyStr = key.toString();
            this.resolvedProps.setProperty(keyStr, this.parseStringValue(props.getProperty(keyStr), props, new HashSet()));
        }
    }
}

