/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.dataset.IDataSetId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.material.IMaterialId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.ISampleId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicMetaprojectUpdates;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class NewMetaproject
implements Serializable {
    private static final long serialVersionUID = 35L;
    private String name;
    private String description;
    private String ownerId;
    private List<ISampleId> samples;
    private List<IExperimentId> experiments;
    private List<IDataSetId> datasets;
    private List<IMaterialId> materials;

    public NewMetaproject(String name, String descriptionOrNull, String ownerId) {
        this.name = name;
        this.description = descriptionOrNull;
        this.ownerId = ownerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public List<ISampleId> getSamples() {
        return this.samples;
    }

    public List<IExperimentId> getExperiments() {
        return this.experiments;
    }

    public List<IDataSetId> getDatasets() {
        return this.datasets;
    }

    public List<IMaterialId> getMaterials() {
        return this.materials;
    }

    public void setEntities(Collection<IObjectId> entities) {
        this.samples = Collections.unmodifiableList(BasicMetaprojectUpdates.filterSamples(entities));
        this.experiments = Collections.unmodifiableList(BasicMetaprojectUpdates.filterExperiments(entities));
        this.datasets = Collections.unmodifiableList(BasicMetaprojectUpdates.filterDataSets(entities));
        this.materials = Collections.unmodifiableList(BasicMetaprojectUpdates.filterMaterials(entities));
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("name", this.getName());
        builder.append("description", this.getDescription());
        builder.append("ownerId", this.getOwnerId());
        return builder.toString();
    }
}

