/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.server;

public class ServiceConversationServerConfig {
    private int numberOfCoreThreads = 10;
    private int maxNumberOfThreads = Integer.MAX_VALUE;
    private int workQueueSize = 0;
    private int shutdownTimeoutMillis = 60000;
    private boolean daemonize = true;

    public int getNumberOfCoreThreads() {
        return this.numberOfCoreThreads;
    }

    public static ServiceConversationServerConfig create() {
        return new ServiceConversationServerConfig();
    }

    public ServiceConversationServerConfig numberOfCoreThreads(int numberOfCoreThreads) {
        this.numberOfCoreThreads = numberOfCoreThreads;
        if (this.maxNumberOfThreads < numberOfCoreThreads) {
            this.maxNumberOfThreads = numberOfCoreThreads;
        }
        return this;
    }

    public int getMaxNumberOfThreads() {
        return this.maxNumberOfThreads;
    }

    public ServiceConversationServerConfig maxNumberOfThreads(int maxNumberOfThreads) {
        this.maxNumberOfThreads = maxNumberOfThreads;
        return this;
    }

    public int getWorkQueueSize() {
        return this.workQueueSize;
    }

    public ServiceConversationServerConfig workQueueSize(int workQueueSize) {
        this.workQueueSize = workQueueSize;
        this.maxNumberOfThreads = this.numberOfCoreThreads;
        return this;
    }

    public int getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    public ServiceConversationServerConfig shutdownTimeoutMillis(int shutdownTimeoutMillis) {
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
        return this;
    }

    public boolean isDaemonize() {
        return this.daemonize;
    }

    public ServiceConversationServerConfig daemonize(boolean daemonize) {
        this.daemonize = daemonize;
        return this;
    }

    public ServiceConversationServerConfig undaemonize() {
        this.daemonize = false;
        return this;
    }
}

