/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.admin;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.admin.AbstractCommand;
import ch.systemsx.cisd.openbis.dss.client.admin.CommonArguments;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class MoveDataSetsCommand
extends AbstractCommand {
    private MoveDataSetsCommandArguments arguments = new MoveDataSetsCommandArguments();

    MoveDataSetsCommand() {
        super("move-to");
    }

    @Override
    protected MoveDataSetsCommandArguments getArguments() {
        return this.arguments;
    }

    @Override
    protected String getRequiredArgumentsString() {
        return "<share id> <data set code 1> [<data set code 2> <data set code 3> ...]";
    }

    @Override
    void execute() {
        String shareId = this.arguments.getShareId();
        Set<String> dataSetCodes = this.arguments.getDataSetCodes();
        for (String dataSetCode : dataSetCodes) {
            try {
                this.service.shuffleDataSet(this.sessionToken, dataSetCode, shareId);
                System.out.println("Data set " + dataSetCode + " successfully moved to share " + shareId + ".");
            }
            catch (UserFailureException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    static final class MoveDataSetsCommandArguments
    extends CommonArguments {
        MoveDataSetsCommandArguments() {
        }

        Set<String> getDataSetCodes() {
            if (this.arguments.isEmpty()) {
                return Collections.emptySet();
            }
            return new TreeSet<String>(this.arguments.subList(1, this.arguments.size()));
        }

        String getShareId() {
            return this.arguments.size() < 2 ? "" : (String)this.arguments.get(0);
        }

        @Override
        protected boolean allAdditionalMandatoryArgumentsPresent() {
            return this.arguments.size() >= 2;
        }
    }
}

