/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.dss.plugins;

import ch.ethz.bsse.cisd.dsu.dss.plugins.ChipResultsSummary;
import ch.ethz.bsse.cisd.dsu.dss.plugins.IlluminaSummary;
import ch.ethz.bsse.cisd.dsu.dss.plugins.LaneResultsSummary;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.xml.JaxbXmlParser;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class IlluminaSummaryReportingPlugin
extends AbstractTableModelReportingPlugin {
    private static final String UNALIGNED_PATH = "/Unaligned_no_mismatch";
    private static final int MEGA = 1000000;
    private static final int KILO = 1000;
    private static final long serialVersionUID = 1L;
    private static final String SUMMARY_FILE_NAME = "Summary.xml";
    private static final String BUSTARD_SUMMARY_FILE_NAME = "BustardSummary.xml";
    private static final String DATA_INTENSITIES_BASE_CALLS_PATH = "/Data/Intensities/BaseCalls";
    private static final String GERALD_DIR = "GERALD";
    private static final String BASECALL_DIR = "Basecall";
    private static final String[] PROPERTIES = new String[]{"GENOME_ANALYZER", "END_TYPE", "ILLUMINA_PIPELINE_VERSION", "CYCLES_REQUESTED_BY_CUSTOMER"};
    private static final String[] COLUMNS = new String[]{"Sample Code", "Clusters", "Clusters (PF)", "Yield (Mbases)", "Density Ratio", "PhiX: Clusters", "PhiX: ClustersPF", "PhiX: Yield (Mbases)", "PhiX: % Align (PF)", "Software", "Eland finished"};

    public IlluminaSummaryReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    private File[] findFile(DataSetProcessingContext context, DatasetDescription dataset, final String summaryFilePath, String path) {
        File originalData = this.getDataSubDir(context.getDirectoryProvider(), dataset);
        File childDirectory = new File(originalData, path);
        File[] files = childDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith(summaryFilePath);
            }
        });
        return files;
    }

    private static void createRows(File[] f, String fileName, SimpleTableModelBuilder b, DatasetDescription dataset) {
        File summaryFile = new File(f[0], fileName);
        IlluminaSummaryReportingPlugin.describe(b, dataset, summaryFile);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        builder = new SimpleTableModelBuilder();
        var7_4 = IlluminaSummaryReportingPlugin.COLUMNS;
        var6_5 = IlluminaSummaryReportingPlugin.COLUMNS.length;
        var5_7 = 0;
        while (var5_7 < var6_5) {
            column = var7_4[var5_7];
            builder.addHeader(column);
            ++var5_7;
        }
        var7_4 = IlluminaSummaryReportingPlugin.PROPERTIES;
        var6_5 = IlluminaSummaryReportingPlugin.PROPERTIES.length;
        var5_7 = 0;
        while (var5_7 < var6_5) {
            property = var7_4[var5_7];
            builder.addHeader(property);
            ++var5_7;
        }
        for (DatasetDescription dataset : datasets) {
            f = this.findFile(context, dataset, "GERALD", String.valueOf(dataset.getSampleCode()) + "/Data/Intensities/BaseCalls");
            if (f != null && f.length > 0) {
                IlluminaSummaryReportingPlugin.createRows(f, "Summary.xml", builder, dataset);
                continue;
            }
            fileNewCasava = this.findFile(context, dataset, "Basecall", "/Unaligned_no_mismatch");
            try {
                IlluminaSummaryReportingPlugin.createRows(fileNewCasava, "BustardSummary.xml", builder, dataset);
                continue;
            }
            catch (RuntimeException v0) {
                row = new ArrayList<ISerializableComparable>();
                row.add(new StringTableCell(dataset.getSampleCode()));
                i = 0;
                ** while (i <= IlluminaSummaryReportingPlugin.COLUMNS.length + IlluminaSummaryReportingPlugin.PROPERTIES.length - 2)
            }
lbl-1000:
            // 1 sources

            {
                row.add(new StringTableCell(""));
                ++i;
                continue;
            }
lbl37:
            // 1 sources

            builder.addRow(row);
        }
        return builder.getTableModel();
    }

    private static void describe(SimpleTableModelBuilder builder, DatasetDescription dataset, File summaryFile) {
        IlluminaSummary summary = IlluminaSummaryXMLLoader.readSummaryXML(summaryFile);
        IlluminaSummaryReportingPlugin.describeSummary(builder, dataset, summary);
    }

    private static void describeSummary(SimpleTableModelBuilder builder, DatasetDescription dataset, IlluminaSummary summary) {
        ChipResultsSummary chipResultSummary = summary.getChipResultsSummary();
        LaneResultsSummary laneResultSummary = summary.getLaneResultsSummary();
        ArrayList<ISerializableComparable> row = new ArrayList<ISerializableComparable>();
        row.add(new StringTableCell(dataset.getSampleCode()));
        IlluminaSummaryReportingPlugin.addTableRow(chipResultSummary.getClusterCountRaw(), row);
        IlluminaSummaryReportingPlugin.addTableRow(chipResultSummary.getClusterCountPF(), row);
        IlluminaSummaryReportingPlugin.addTableRow(chipResultSummary.getYield() / 1000000L, row);
        IlluminaSummaryReportingPlugin.addTableRow(chipResultSummary.getDensityRatio(), row);
        IlluminaSummaryReportingPlugin.addTableRow(laneResultSummary.getRead().getLanes().get(4).getClusterCountRaw().getMean(), row);
        IlluminaSummaryReportingPlugin.addTableRow(laneResultSummary.getRead().getLanes().get(4).getClusterCountPF().getMean(), row);
        IlluminaSummaryReportingPlugin.addTableRow(laneResultSummary.getRead().getLanes().get(4).getLaneYield() / 1000L, row);
        try {
            IlluminaSummaryReportingPlugin.addTableRow(laneResultSummary.getRead().getLanes().get(4).getPercentUniquelyAlignedPF().getMean(), row);
        }
        catch (RuntimeException runtimeException) {
            row.add(new StringTableCell(""));
        }
        IlluminaSummaryReportingPlugin.addTableRow(summary.getSoftware(), row);
        IlluminaSummaryReportingPlugin.addTableRow(summary.getDate(), row);
        IlluminaSummaryReportingPlugin.addPropertyColumnValues(dataset, row);
        builder.addRow(row);
    }

    private static void addTableRow(Long number, List<ISerializableComparable> row) {
        try {
            row.add(new IntegerTableCell(number));
        }
        catch (RuntimeException runtimeException) {
            row.add(new StringTableCell(""));
        }
    }

    private static void addTableRow(Double number, List<ISerializableComparable> row) {
        try {
            row.add(new DoubleTableCell(number));
        }
        catch (RuntimeException runtimeException) {
            row.add(new StringTableCell(""));
        }
    }

    private static void addTableRow(String s, List<ISerializableComparable> row) {
        try {
            row.add(new StringTableCell(s));
        }
        catch (RuntimeException runtimeException) {
            row.add(new StringTableCell(""));
        }
    }

    private static void addPropertyColumnValues(DatasetDescription dataset, List<ISerializableComparable> row) {
        Sample sample = IlluminaSummaryReportingPlugin.getSample(dataset);
        String[] stringArray = PROPERTIES;
        int n = PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyCode = stringArray[n2];
            boolean found = false;
            for (IEntityProperty property : sample.getProperties()) {
                if (!property.getPropertyType().getCode().equals(propertyCode)) continue;
                row.add(new StringTableCell(property.tryGetAsString()));
                found = true;
                break;
            }
            if (!found) {
                row.add(new StringTableCell(""));
            }
            ++n2;
        }
    }

    private static Sample getSample(DatasetDescription dataset) {
        String spaceCode = dataset.getSpaceCode();
        String sampleCode = dataset.getSampleCode();
        String databaseInstanceCode = dataset.getDatabaseInstanceCode();
        SampleIdentifier sampleIdentifier = new SampleIdentifier(new SpaceIdentifier(databaseInstanceCode, spaceCode), sampleCode);
        Sample sampleOrNull = ServiceProvider.getOpenBISService().tryGetSampleWithExperiment(sampleIdentifier);
        if (sampleOrNull == null) {
            throw new EnvironmentFailureException(String.format("Couldn't get sample %s for dataset %s.", dataset.getSampleCode(), dataset.getDataSetCode()));
        }
        return sampleOrNull;
    }

    static class IlluminaSummaryXMLLoader {
        private static JaxbXmlParser<IlluminaSummary> PARSER_INSTANCE = new JaxbXmlParser<IlluminaSummary>(IlluminaSummary.class, false);

        IlluminaSummaryXMLLoader() {
        }

        public static IlluminaSummary readSummaryXML(File summaryXml) {
            return PARSER_INSTANCE.doParse(summaryXml);
        }
    }
}

