/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.main;

import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.util.Properties;

public class Parameters {
    private static final String OPENBIS_USER = "openbis-user";
    private static final String OPENBIS_PASSWORD = "openbis-password";
    private static final String OPENBIS_SERVER_URL = "openbis-server-url";
    private static final String PERMLINK_URL = "permlink-url";
    private static final String TRACKING_ADMIN_EMAIL = "tracking-admin-email";
    private static final String NOTIFICATION_EMAIL_FROM = "mail.from";
    private final String openbisUser;
    private final String openbisPassword;
    private final String openbisServerURL;
    private final String permlinkURL;
    private final IMailClient mailClient;
    private final String adminEmail;
    private final String notificationEmail;

    public Parameters(Properties props) {
        this.openbisUser = PropertyUtils.getMandatoryProperty(props, OPENBIS_USER);
        this.openbisPassword = PropertyUtils.getMandatoryProperty(props, OPENBIS_PASSWORD);
        this.openbisServerURL = PropertyUtils.getMandatoryProperty(props, OPENBIS_SERVER_URL);
        this.permlinkURL = PropertyUtils.getProperty(props, PERMLINK_URL, this.openbisServerURL);
        this.mailClient = new MailClient(props);
        this.adminEmail = PropertyUtils.getProperty(props, TRACKING_ADMIN_EMAIL);
        this.notificationEmail = PropertyUtils.getProperty(props, NOTIFICATION_EMAIL_FROM);
    }

    public String getOpenbisUser() {
        return this.openbisUser;
    }

    public String getOpenbisPassword() {
        return this.openbisPassword;
    }

    public String getOpenbisServerURL() {
        return this.openbisServerURL;
    }

    public IMailClient getMailClient() {
        return this.mailClient;
    }

    public String getPermlinkURL() {
        return this.permlinkURL;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public String getNotificationEmail() {
        return this.notificationEmail;
    }
}

