/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.concurrent.InactivityMonitor;
import ch.systemsx.cisd.common.exceptions.StatusWithResult;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.log4j.Logger;

public abstract class AbstractCopyActivitySensor
implements InactivityMonitor.IDescribingActivitySensor {
    protected static final int DEFAULT_MAX_ERRORS_TO_IGNORE = 3;
    protected final int maxErrorsToIgnore;
    protected final long timeOfCreation;
    protected long timeOfLastConfirmedActivity;
    protected long timeOfLastReportedActivity;
    protected long lastNonErrorResult;
    protected StatusWithResult<Long> currentResult;
    protected int errorCount;

    protected AbstractCopyActivitySensor() {
        this(3);
    }

    protected AbstractCopyActivitySensor(int maxErrorsToIgnore) {
        this.timeOfLastConfirmedActivity = this.timeOfCreation = System.currentTimeMillis();
        this.timeOfLastReportedActivity = this.timeOfCreation;
        this.lastNonErrorResult = -1L;
        this.errorCount = 0;
        this.maxErrorsToIgnore = maxErrorsToIgnore;
        this.currentResult = null;
    }

    protected abstract StatusWithResult<Long> getTargetTimeOfLastActivityMoreRecentThan(long var1);

    protected abstract String getTargetDescription();

    protected abstract Logger getMachineLog();

    @Override
    public long getLastActivityMillisMoreRecentThan(long thresholdMillis) {
        this.currentResult = this.getTargetTimeOfLastActivityMoreRecentThan(thresholdMillis);
        long now = System.currentTimeMillis();
        if (this.currentResult.isError()) {
            ++this.errorCount;
            if (this.errorCount <= this.maxErrorsToIgnore) {
                this.timeOfLastReportedActivity = now;
                this.getMachineLog().warn(String.valueOf(this.currentResult.tryGetErrorMessage()) + String.format(" (error count: %d <= %d, goes unreported)", this.errorCount, this.maxErrorsToIgnore));
            } else {
                this.getMachineLog().error(String.valueOf(this.describeInactivity(now)) + String.format(" (error count: %s, reported to monitor)", this.errorCount));
            }
        } else {
            if (this.currentResult.tryGetResult() != this.lastNonErrorResult) {
                this.timeOfLastConfirmedActivity = now;
                this.lastNonErrorResult = this.currentResult.tryGetResult();
                if (this.getMachineLog().isDebugEnabled()) {
                    this.getMachineLog().debug("Observing write activity on " + this.getTargetDescription());
                }
            }
            this.timeOfLastReportedActivity = this.timeOfLastConfirmedActivity;
            this.errorCount = 0;
        }
        return this.timeOfLastReportedActivity;
    }

    @Override
    public boolean hasActivityMoreRecentThan(long thresholdMillis) {
        long now = System.currentTimeMillis();
        return now - this.getLastActivityMillisMoreRecentThan(thresholdMillis) < thresholdMillis;
    }

    @Override
    public String describeInactivity(long now) {
        if (this.currentResult.isError()) {
            return "Error: Unable to determine the time of write activity on " + this.getTargetDescription() + "\n" + this.currentResult;
        }
        String inactivityPeriod = DurationFormatUtils.formatDurationHMS((long)(now - this.timeOfLastConfirmedActivity));
        return "No write activity on " + this.getTargetDescription() + " for " + inactivityPeriod;
    }
}

