/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MonitoredIOStreamCopier {
    private final byte[] buffer;
    private ISimpleLogger logger;
    private ITimeProvider timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
    private Statistics readStatistics;
    private Statistics writeStatistics;

    public MonitoredIOStreamCopier(int bufferSize) {
        this.buffer = new byte[bufferSize];
    }

    public void setLogger(ISimpleLogger logger) {
        this.logger = logger;
        if (logger != null) {
            this.readStatistics = new Statistics(this.buffer.length);
            this.writeStatistics = new Statistics(this.buffer.length);
        }
    }

    void setTimeProvider(ITimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public long copy(InputStream input, OutputStream output) {
        long totalNumberOfBytes = 0L;
        try {
            int numberOfBytes = 0;
            while (-1 != (numberOfBytes = this.readBytes(input))) {
                this.writeBytes(output, numberOfBytes);
                totalNumberOfBytes += (long)numberOfBytes;
            }
            return totalNumberOfBytes;
        }
        catch (IOException ex) {
            throw new EnvironmentFailureException("Error after " + totalNumberOfBytes + " bytes copied: " + ex, ex);
        }
    }

    public void close() {
        if (this.logger != null) {
            this.logger.log(LogLevel.INFO, "Reading statistics for input stream: " + this.readStatistics);
            this.logger.log(LogLevel.INFO, "Writing statistics for output stream: " + this.writeStatistics);
        }
    }

    private int readBytes(InputStream input) throws IOException {
        long t0 = this.startIO();
        int numberOfBytes = input.read(this.buffer);
        this.recordTime(numberOfBytes, t0, this.readStatistics);
        return numberOfBytes;
    }

    private void writeBytes(OutputStream output, int numberOfBytes) throws IOException {
        long t0 = this.startIO();
        output.write(this.buffer, 0, numberOfBytes);
        this.recordTime(numberOfBytes, t0, this.writeStatistics);
    }

    private long startIO() {
        return this.logger != null ? this.timeProvider.getTimeInMilliseconds() : -1L;
    }

    private void recordTime(int numberOfBytes, long t0, Statistics statistics) {
        if (this.logger != null) {
            statistics.add(numberOfBytes, t0, this.timeProvider.getTimeInMilliseconds());
        }
    }

    private static final class NumberOfBytesAndIOTime {
        private int numberOfBytes;
        private long ioTime;

        NumberOfBytesAndIOTime(int numberOfBytes, long ioTime) {
            this.numberOfBytes = numberOfBytes;
            this.ioTime = ioTime;
        }
    }

    private static final class Statistics {
        private final List<NumberOfBytesAndIOTime> data = new ArrayList<NumberOfBytesAndIOTime>();
        private final int minNumberOfBytes;

        public Statistics(int minNumberOfBytes) {
            this.minNumberOfBytes = minNumberOfBytes;
        }

        void add(int numberOfBytes, long startTime, long endTime) {
            if (numberOfBytes > 0) {
                this.data.add(new NumberOfBytesAndIOTime(numberOfBytes, endTime - startTime));
            }
        }

        public String toString() {
            ArrayList<Double> speed = new ArrayList<Double>(this.data.size());
            long totalNumberOfBytes = 0L;
            long totalTime = 0L;
            for (NumberOfBytesAndIOTime nt : this.data) {
                totalNumberOfBytes += (long)nt.numberOfBytes;
                totalTime += nt.ioTime;
                if (nt.numberOfBytes < this.minNumberOfBytes || nt.ioTime <= 0L) continue;
                speed.add(1000.0 * (double)nt.numberOfBytes / (double)nt.ioTime);
            }
            String medianSpeedInfo = "";
            if (!speed.isEmpty()) {
                long medianBytesPerSecond = Math.round(this.calculateMedian(speed));
                medianSpeedInfo = " Median speed: " + FileUtilities.byteCountToDisplaySize(medianBytesPerSecond) + "/sec.";
            }
            String averageSpeedInfo = "";
            if (totalNumberOfBytes >= (long)this.minNumberOfBytes && totalTime > 0L) {
                long averageBytesPerSecond = Math.round(1000.0 * (double)totalNumberOfBytes / (double)totalTime);
                averageSpeedInfo = " Average speed: " + FileUtilities.byteCountToDisplaySize(averageBytesPerSecond) + "/sec.";
            }
            return String.valueOf(FileUtilities.byteCountToDisplaySize(totalNumberOfBytes)) + " bytes in " + this.data.size() + " chunks took " + DateTimeUtils.renderDuration(totalTime) + "." + averageSpeedInfo + medianSpeedInfo;
        }

        private double calculateMedian(List<Double> speed) {
            Collections.sort(speed);
            int size = speed.size();
            double medianSpeed = speed.get(size / 2);
            if (size % 2 == 0) {
                medianSpeed = 0.5 * (speed.get(size / 2 - 1) + speed.get(size / 2));
            }
            return medianSpeed;
        }
    }
}

